/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                              *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 *  Heavily based on kiss by Ronald Bultje <rbultje@ronald.bitfreak.net>
 */

#ifndef __TIMER_H__
#define __TIMER_H__

#include <qobject.h>

#include <gst/gst.h>

class QSlider;
class QLabel;
class QTimer;
class QTime;

class Timer : public QObject
{
	Q_OBJECT

public:
	Timer(GstElement *play);
	~Timer ();

	long getTotalTimeMS()
	{
		return m_totalTimeMS;
	}
	long getCurrentTimeMS()
	{
		return m_currentTimeMS;
	}

	void seekPercent(uint percent);

	QLabel* getLabel() const;
	QSlider* getSlider() const;

public slots:
	void slotUpdate();
	void slotStartseek ();
	void slotSeek(int val);
	void slotEndseek();

private:
	void newState(GstElementState old_state, GstElementState new_state);

	//callbacks
	static void cb_state (GstElement* play, GstElementState old_state, GstElementState new_state, gpointer data);

private:
	QTimer *m_timer;
	QLabel *m_label;
	QSlider *m_slider;
	GstElement *m_play;

	long m_currentTimeMS;
	long m_totalTimeMS;
	guint64 m_len, m_pos;
	bool m_seeking;
};

#endif /* __TIMER_H__ */
