/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                              *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Last modified: $Date: 2005/07/18 18:15:37 $ by $Author: juergenk $
 */

#ifndef STARTWINDOW_H
#define STARTWINDOW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <kiconview.h>

/**
A icon view for quickstart.

@author Jürgen Kofler
*/

class QPixmap;
class QString;

class StartWindow : public QWidget
{
	Q_OBJECT

public:
	StartWindow(QWidget* parent = 0, const char* name = 0);
	virtual ~StartWindow();

	void enableDiscIcons(bool);
	void enableDVBIcon(bool);

private:
	QPixmap getIcon(QString name, bool enabled = true);

signals:
	void signalPlaylistPlay();
	void signalOpenFile();
	void signalOpenURL();
	void signalOpenDirectory();
	void signalOpenDVD();
	void signalOpenVCD();
	void signalOpenAudioCD();
	void signalShowPlayerWindow();
	void signalDVB();

private slots:
	void slotItemExecuted(QIconViewItem*);

private:
	bool m_discIconsEnabled;
	bool m_dvbEnabled;
	QIconViewItem* m_items[9];

};

#endif
