/***************************************************************************
                           systemtray.cpp
                             -------------------
    begin                : Son Okt 26 2003
    revision             : $Revision: 1.18 $
    last modified        : $Date: 2005/07/23 17:17:19 $ by $Author: juergenk $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kaction.h>

#include <qtimer.h>
#include <qlabel.h>
#include <qtooltip.h>

#include "systemtray.h"
#include "systemtray.moc"


class TitleLabel : public QLabel
{

public:
	TitleLabel() : QLabel(0, "tray_osd", WStyle_Customize | WStyle_NoBorder | WStyle_StaysOnTop | WX11BypassWM)
	{}
	virtual ~TitleLabel() {}

protected:
	void enterEvent(QEvent*)
	{
		hide();
	}
};

SystemTray::SystemTray(QWidget *parent, const char *name ) : KSystemTray(parent,name)
{
	kdDebug() << "SystemTray: Create System Tray" << endl;


	KAction* play = new KAction(i18n("Play"), "player_play", 0, this, SIGNAL(signalPlay()), actionCollection(), "trayplay");
	KAction* next = new KAction(i18n("&Next"), "next", 0, this, SIGNAL(signalNext()), actionCollection(), "traynext");
	KAction* previous = new KAction(i18n("&Previous"), "previous", 0, this, SIGNAL(signalPrevious()), actionCollection(), "trayprevious");
	KAction* stop = new KAction(i18n("Stop"), "player_stop", 0, this, SIGNAL(signalStop()), actionCollection(), "traystop");
	KAction* mute = new KAction(i18n("&Mute"), "player_mute", 0, this, SIGNAL(signalMute()), actionCollection(), "traymute");

	play->plug(contextMenu());
	next->plug(contextMenu());
	previous->plug(contextMenu());
	stop->plug(contextMenu());
	mute->plug(contextMenu());

	m_osd = new TitleLabel;
	m_osd->setFrameStyle(QFrame::Panel | QFrame::Plain);
	m_osd->setLineWidth(1);
	m_osd->setAlignment(SingleLine);
	connect(&m_hideTimer, SIGNAL(timeout()), this, SLOT(slotHideOSD()));

	setPixmap(KGlobal::iconLoader()->loadIcon("kaffeine", KIcon::Panel, 22));
	QToolTip::add(this, i18n("Kaffeine Player"));
}


SystemTray::~SystemTray()
{}

void SystemTray::wheelEvent(QWheelEvent *e)
{
	if(e->delta() > 0)
		actionCollection()->action("traynext")->activate();
	else
		actionCollection()->action("trayprevious")->activate();
	e->accept();
}

void SystemTray::showTitle(const QString& title, uint secs)
{
	if (title.isEmpty())
		return;

	QToolTip::remove(this); // all the time remove it before add it.
	QToolTip::add(this, title);
	if (secs > 0)
	{
		m_osd->setText(QString("<nobr><b>") + title + "</b></nobr>");
		m_osd->adjustSize();
		QPoint global = mapToGlobal(QPoint(0,0));
		m_osd->move(global.x() - m_osd->width() + 10, global.y() - m_osd->height() + 15);
		m_osd->show();
		m_hideTimer.start(secs * 1000);
	}
}

void SystemTray::slotHideOSD()
{
	m_osd->hide();
	m_hideTimer.stop();
}





