/***************************************************************************
                          cdlisten.h  -  description
                             -------------------
    begin                : Wed Apr 01 2005
    copyright            : (C) 2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/04/28 11:56:28 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDLISTEN_H
#define CDLISTEN_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <qobject.h>
#include <qthread.h>
#include <qtimer.h>
#include <qstring.h>

class CdListen : public QObject, public QThread
{
	Q_OBJECT

public:

	CdListen();
	~CdListen();
	virtual void run();
	bool go( const QString &ad, int port );
	void stop();

private slots:

	void updateList();

private:

	int sock;
	struct sockaddr_in addr;
	bool isRunning;
	QTimer timer;
	QString currentList, newList;

signals:

	void listChanged( const QString& );
};
#endif
