/***************************************************************************
                           systemtray.h 
                             -------------------
    begin                : Son Okt 26 2003
    revision             : $Revision: 1.7 $
    last modified        : $Date: 2005/02/02 10:08:20 $ by $Author: juergenk $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYSTEMTRAY_H
#define SYSTEMTRAY_H

#include <ksystemtray.h>

#include <qwidget.h>

/**
  *@author Jürgen  Kofler
  */

  
class TitleLabel;
class QTimer;  

class SystemTray : public KSystemTray  {
   Q_OBJECT
public: 
  SystemTray(QWidget *parent = 0, const char *name = 0);
  virtual ~SystemTray();
  
  void showTitle(const QString&, uint secs = 5);
  
protected:
   virtual void wheelEvent(QWheelEvent *e);
   void mousePressEvent(QMouseEvent *e);

signals:
   void signalPlay();
   void signalNext();
   void signalPrevious();
   void signalStop();
   void signalMute();

private slots:
  void slotHideOSD();   
   
private:
  TitleLabel* m_osd;
  QTimer m_hideTimer;
};

#endif
