//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  A wrapper class for the most commonly used encoding and
	///  decoding algorithms.  Currently there is support for encoding
	///  and decoding input using base64, uu and the quoted-printable
	///  specifications.
	///  <b></b>sage:
	///  <pre>
	///  QByteArray input = "Aladdin:open sesame";
	///  QByteArray result = KCodecs.Base64Encode(input);
	///  cout << "Result: " << result.data() << endl;
	///  </pre>
	///  <pre>
	///  Output should be
	///  Result: QWxhZGRpbjpvcGVuIHNlc2FtZQ==
	///  </pre>
	///  The above example makes use of the convenience functions
	///  (ones that accept/return null-terminated strings) to encode/decode
	///  a string.  If what you need is to encode or decode binary data, then
	///  it is highly recommended that you use the functions that take an input
	///  and output QByteArray as arguments.  These functions are specifically
	///  tailored for encoding and decoding binary data.
	/// </remarks>		<author> Rik Hemsley <rik@kde.org>
	///  </author>
	/// 		<short> A collection of commonly used encoding and decoding algorithms. </short>

	[SmokeClass("KCodecs")]
	public class KCodecs : Object {
		protected SmokeInvocation interceptor = null;
		private static SmokeInvocation staticInterceptor = null;
		static KCodecs() {
			staticInterceptor = new SmokeInvocation(typeof(KCodecs), null);
		}
		/// <remarks>
		///  Encodes the given data using the quoted-printable algorithm.
		/// <param> name="in" data to be encoded.
		/// </param><param> name="useCRLF" if true the input data is expected to have
		///                 CRLF line breaks and the output will have CRLF line
		///                 breaks, too.
		/// </param></remarks>		<return> quoted-printable encoded string.
		///    </return>
		/// 		<short>    Encodes the given data using the quoted-printable algorithm.</short>
		public static QByteArray QuotedPrintableEncode(QByteArray arg1, bool useCRLF) {
			return (QByteArray) staticInterceptor.Invoke("quotedPrintableEncode#$", "quotedPrintableEncode(const QByteArray&, bool)", typeof(QByteArray), typeof(QByteArray), arg1, typeof(bool), useCRLF);
		}
		public static QByteArray QuotedPrintableEncode(QByteArray arg1) {
			return (QByteArray) staticInterceptor.Invoke("quotedPrintableEncode#", "quotedPrintableEncode(const QByteArray&)", typeof(QByteArray), typeof(QByteArray), arg1);
		}
		/// <remarks>
		///  Encodes the given data using the quoted-printable algorithm.
		///  Use this function if you want the result of the encoding
		///  to be placed in another array which cuts down the number
		///  of copy operation that have to be performed in the process.
		///  This is also the preferred method for encoding binary data.
		///  NOTE: the output array is first reset and then resized
		///  appropriately before use, hence, all data stored in the
		///  output array will be lost.
		/// <param> name="in" data to be encoded.
		/// </param><param> name="out" encoded data.
		/// </param><param> name="useCRLF" if true the input data is expected to have
		///                 CRLF line breaks and the output will have CRLF line
		///                 breaks, too.
		///    </param></remarks>		<short>    Encodes the given data using the quoted-printable algorithm.</short>
		public static void QuotedPrintableEncode(QByteArray arg1, QByteArray arg2, bool useCRLF) {
			staticInterceptor.Invoke("quotedPrintableEncode##$", "quotedPrintableEncode(const QByteArray&, QByteArray&, bool)", typeof(void), typeof(QByteArray), arg1, typeof(QByteArray), arg2, typeof(bool), useCRLF);
		}
		/// <remarks>
		///  Decodes a quoted-printable encoded data.
		///  Accepts data with CRLF or standard unix line breaks.
		/// <param> name="in" data to be decoded.
		/// </param></remarks>		<return> decoded string.
		///    </return>
		/// 		<short>    Decodes a quoted-printable encoded data.</short>
		public static QByteArray QuotedPrintableDecode(QByteArray arg1) {
			return (QByteArray) staticInterceptor.Invoke("quotedPrintableDecode#", "quotedPrintableDecode(const QByteArray&)", typeof(QByteArray), typeof(QByteArray), arg1);
		}
		/// <remarks>
		///  Decodes a quoted-printable encoded data.
		///  Accepts data with CRLF or standard unix line breaks.
		///  Use this function if you want the result of the decoding
		///  to be placed in another array which cuts down the number
		///  of copy operation that have to be performed in the process.
		///  This is also the preferred method for decoding an encoded
		///  binary data.
		///  NOTE: the output array is first reset and then resized
		///  appropriately before use, hence, all data stored in the
		///  output array will be lost.
		/// <param> name="in" data to be decoded.
		/// </param><param> name="out" decoded data.
		///    </param></remarks>		<short>    Decodes a quoted-printable encoded data.</short>
		public static void QuotedPrintableDecode(QByteArray arg1, QByteArray arg2) {
			staticInterceptor.Invoke("quotedPrintableDecode##", "quotedPrintableDecode(const QByteArray&, QByteArray&)", typeof(void), typeof(QByteArray), arg1, typeof(QByteArray), arg2);
		}
		/// <remarks>
		///  Encodes the given data using the uuencode algorithm.
		///  The output is split into lines starting with the number of
		///  encoded octets in the line and ending with a newline.  No
		///  line is longer than 45 octets (60 characters), excluding the
		///  line terminator.
		/// <param> name="in" data to be uuencoded
		/// </param></remarks>		<return> uuencoded string.
		///    </return>
		/// 		<short>    Encodes the given data using the uuencode algorithm.</short>
		public static QByteArray Uuencode(QByteArray arg1) {
			return (QByteArray) staticInterceptor.Invoke("uuencode#", "uuencode(const QByteArray&)", typeof(QByteArray), typeof(QByteArray), arg1);
		}
		/// <remarks>
		///  Encodes the given data using the uuencode algorithm.
		///  Use this function if you want the result of the encoding
		///  to be placed in another array and cut down the number of
		///  copy operation that have to be performed in the process.
		///  This is the preffered method for encoding binary data.
		///  NOTE: the output array is first reset and then resized
		///  appropriately before use, hence, all data stored in the
		///  output array will be lost.
		/// <param> name="in" data to be uuencoded.
		/// </param><param> name="out" uudecoded data.
		///    </param></remarks>		<short>    Encodes the given data using the uuencode algorithm.</short>
		public static void Uuencode(QByteArray arg1, QByteArray arg2) {
			staticInterceptor.Invoke("uuencode##", "uuencode(const QByteArray&, QByteArray&)", typeof(void), typeof(QByteArray), arg1, typeof(QByteArray), arg2);
		}
		/// <remarks>
		///  Decodes the given data using the uudecode algorithm.
		///  Any 'begin' and 'end' lines like those generated by
		///  the utilities in unix and unix-like OS will be
		///  automatically ignored.
		/// <param> name="in" data to be decoded.
		/// </param></remarks>		<return> decoded string.
		///    </return>
		/// 		<short>    Decodes the given data using the uudecode algorithm.</short>
		public static QByteArray Uudecode(QByteArray arg1) {
			return (QByteArray) staticInterceptor.Invoke("uudecode#", "uudecode(const QByteArray&)", typeof(QByteArray), typeof(QByteArray), arg1);
		}
		/// <remarks>
		///  Decodes the given data using the uudecode algorithm.
		///  Use this function if you want the result of the decoding
		///  to be placed in another array which cuts down the number
		///  of copy operation that have to be performed in the process.
		///  This is the preferred method for decoding binary data.
		///  Any 'begin' and 'end' lines like those generated by
		///  the utilities in unix and unix-like OS will be
		///  automatically ignored.
		///  NOTE: the output array is first reset and then resized
		///  appropriately before use, hence, all data stored in the
		///  output array will be lost.
		/// <param> name="in" data to be decoded.
		/// </param><param> name="out" uudecoded data.
		///    </param></remarks>		<short>    Decodes the given data using the uudecode algorithm.</short>
		public static void Uudecode(QByteArray arg1, QByteArray arg2) {
			staticInterceptor.Invoke("uudecode##", "uudecode(const QByteArray&, QByteArray&)", typeof(void), typeof(QByteArray), arg1, typeof(QByteArray), arg2);
		}
		/// <remarks>
		///  Encodes the given data using the base64 algorithm.
		///  The boolean argument determines if the encoded data is
		///  going to be restricted to 76 characters or less per line
		///  as specified by RFC 2045.  If <code>insertLFs</code> is true, then
		///  there will be 76 characters or less per line.
		/// <param> name="in" data to be encoded.
		/// </param><param> name="insertLFs" limit the number of characters per line.
		/// </param></remarks>		<return> base64 encoded string.
		///    </return>
		/// 		<short>    Encodes the given data using the base64 algorithm.</short>
		public static QByteArray Base64Encode(QByteArray arg1, bool insertLFs) {
			return (QByteArray) staticInterceptor.Invoke("base64Encode#$", "base64Encode(const QByteArray&, bool)", typeof(QByteArray), typeof(QByteArray), arg1, typeof(bool), insertLFs);
		}
		public static QByteArray Base64Encode(QByteArray arg1) {
			return (QByteArray) staticInterceptor.Invoke("base64Encode#", "base64Encode(const QByteArray&)", typeof(QByteArray), typeof(QByteArray), arg1);
		}
		/// <remarks>
		///  Encodes the given data using the base64 algorithm.
		///  Use this function if you want the result of the encoding
		///  to be placed in another array which cuts down the number
		///  of copy operation that have to be performed in the process.
		///  This is also the preferred method for encoding binary data.
		///  The boolean argument determines if the encoded data is going
		///  to be restricted to 76 characters or less per line as specified
		///  by RFC 2045.  If <code>insertLFs</code> is true, then there will be 76
		///  characters or less per line.
		///  NOTE: the output array is first reset and then resized
		///  appropriately before use, hence, all data stored in the
		///  output array will be lost.
		/// <param> name="in" data to be encoded.
		/// </param><param> name="out" encoded data.
		/// </param><param> name="insertLFs" limit the number of characters per line.
		///    </param></remarks>		<short>    Encodes the given data using the base64 algorithm.</short>
		public static void Base64Encode(QByteArray arg1, QByteArray arg2, bool insertLFs) {
			staticInterceptor.Invoke("base64Encode##$", "base64Encode(const QByteArray&, QByteArray&, bool)", typeof(void), typeof(QByteArray), arg1, typeof(QByteArray), arg2, typeof(bool), insertLFs);
		}
		public static void Base64Encode(QByteArray arg1, QByteArray arg2) {
			staticInterceptor.Invoke("base64Encode##", "base64Encode(const QByteArray&, QByteArray&)", typeof(void), typeof(QByteArray), arg1, typeof(QByteArray), arg2);
		}
		/// <remarks>
		///  Decodes the given data that was encoded using the
		///  base64 algorithm.
		/// <param> name="in" data to be decoded.
		/// </param></remarks>		<return> decoded string.
		///    </return>
		/// 		<short>    Decodes the given data that was encoded using the  base64 algorithm.</short>
		public static QByteArray Base64Decode(QByteArray arg1) {
			return (QByteArray) staticInterceptor.Invoke("base64Decode#", "base64Decode(const QByteArray&)", typeof(QByteArray), typeof(QByteArray), arg1);
		}
		/// <remarks>
		///  Decodes the given data that was encoded with the base64
		///  algorithm.
		///  Use this function if you want the result of the decoding
		///  to be placed in another array which cuts down the number
		///  of copy operation that have to be performed in the process.
		///  This is also the preferred method for decoding an encoded
		///  binary data.
		///  NOTE: the output array is first reset and then resized
		///  appropriately before use, hence, all data stored in the
		///  output array will be lost.
		/// <param> name="in" data to be decoded.
		/// </param><param> name="out" decoded data.
		///    </param></remarks>		<short>    Decodes the given data that was encoded with the base64  algorithm.</short>
		public static void Base64Decode(QByteArray arg1, QByteArray arg2) {
			staticInterceptor.Invoke("base64Decode##", "base64Decode(const QByteArray&, QByteArray&)", typeof(void), typeof(QByteArray), arg1, typeof(QByteArray), arg2);
		}
	}
}
