//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  This class should be used as a base class by all resource agents,
    ///  because it encapsulates large parts of the protocol between
    ///  resource agent, agent manager and the Akonadi storage.
    ///  It provides many convenience methods to make implementing a
    ///  new Akonadi resource agent as simple as possible.
    ///  <h4>How to write a resource</h4>
    ///  The following provides an overview of what you need to do to implement
    ///  your own Akonadi resource. In the following, the term 'backend' refers
    ///  to the entity the resource connects with Akonadi, be it a single file
    ///  or a remote server.
    ///  @todo Complete this (online/offline state management)
    ///  <h5>Basic %Resource Framework</h5>
    ///  The following is needed to create a new resource:
    ///  - A new class deriving from Akonadi.ResourceBase, implementing at least all
    ///    pure-methods, see below for further details.
    ///  - call init() in your main() function.
    ///  - a .desktop file similar to the following example
    ///    <pre>
    ///  [Desktop Entry]
    ///  Encoding=UTF-8
    ///  Name=My Akonadi Resource
    ///  Type=AkonadiResource
    ///  Exec=akonadi_my_resource
    ///  Icon=my-icon
    ///  X-Akonadi-MimeTypes=<supported-mimetypes>
    ///  X-Akonadi-Capabilities=Resource
    ///  X-Akonadi-Identifier=akonadi_my_resource
    ///    </pre>
    ///  <h5>Handling PIM Items</h5>
    ///  To follow item changes in the backend, the following steps are necessary:
    ///  - Implement retrieveItems() to synchronize all items in the given
    ///    collection. If the backend supports incremental retrieval,
    ///    implementing support for that is recommended to improve performance.
    ///  - Convert the items provided by the backend to Akonadi items.
    ///    This typically happens either in retrieveItems() if you retrieved
    ///    the collection synchronously (not recommended for network backends) or
    ///    in the result slot of the asynchronous retrieval job.
    ///    Converting means to create Akonadi.Item objects for every retrieved
    ///    item. It's very important that every object has its remote identifier set.
    ///  - Call itemsRetrieved() or itemsRetrievedIncremental() respectively
    ///    with the item objects created above. The Akonadi storage will then be
    ///    updated automatically. Note that it is usually not necessary to manipulate
    ///    any item in the Akonadi storage manually.
    ///  To fetch item data on demand, the method retrieveItem() needs to be
    ///  reimplemented. Fetch the requested data there and call itemRetrieved()
    ///  with the result item.
    ///  To write local changes back to the backend, you need to re-implement
    ///  the following three methods:
    ///  - itemAdded()
    ///  - itemChanged()
    ///  - itemRemoved()
    ///  Once you have handled changes in these methods call changeCommitted().
    ///  These methods are called whenever a local item related to this resource is
    ///  added, modified or deleted. They are only called if the resource is online, otherwise
    ///  all changes are recorded and replayed as soon the resource is online again.
    ///  <h5>Handling Collections</h5>
    ///  To follow collection changes in the backend, the following steps are necessary:
    ///  - Implement retrieveCollections() to retrieve collections from the backend.
    ///    If the backend supports incremental collections updates, implementing
    ///    support for that is recommended to improve performance.
    ///  - Convert the collections of the backend to Akonadi collections.
    ///    This typically happens either in retrieveCollections() if you retrieved
    ///    the collection synchronously (not recommended for network backends) or
    ///    in the result slot of the asynchronous retrieval job.
    ///    Converting means to create Akonadi.Collection objects for every retrieved
    ///    collection. It's very important that every object has its remote identifier
    ///    and its parent remote identifier set.
    ///  - Call collectionsRetrieved() or collectionsRetrievedIncremental() respectively
    ///    with the collection objects created above. The Akonadi storage will then be
    ///    updated automatically. Note that it is usually not necessary to manipulate
    ///    any collection in the Akonadi storage manually.
    ///  To write local collection changes back to the backend, you need to re-implement
    ///  the following three methods:
    ///  - collectionAdded()
    ///  - collectionChanged()
    ///  - collectionRemoved()
    ///  Once you have handled changes in these methods call changeCommitted().
    ///  These methods are called whenever a local collection related to this resource is
    ///  added, modified or deleted. They are only called if the resource is online, otherwise
    ///  all changes are recorded and replayed as soon the resource is online again.
    ///  @todo Convenience base class for collection-less resources
    ///   See <see cref="IResourceBaseSignals"></see> for signals emitted by ResourceBase
    /// </remarks>        <short> The base class for all Akonadi resources. </short>
    [SmokeClass("Akonadi::ResourceBase")]
    public abstract class ResourceBase : Akonadi.AgentBase {
        protected ResourceBase(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ResourceBase), this);
        }
        // bool retrieveItem(const Akonadi::Item& arg1,const QSet<QByteArray>& arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  This method is used to set the name of the resource.
        ///      </remarks>        <short>    This method is used to set the name of the resource.</short>
        public void SetName(string name) {
            interceptor.Invoke("setName$", "setName(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Returns the name of the resource.
        ///      </remarks>        <short>    Returns the name of the resource.</short>
        public string Name() {
            return (string) interceptor.Invoke("name", "name() const", typeof(string));
        }
        /// <remarks>
        ///  Creates a base resource.
        /// <param> name="id" The instance id of the resource.
        ///      </param></remarks>        <short>    Creates a base resource.</short>
        public ResourceBase(string id) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ResourceBase$", "ResourceBase(const QString&)", typeof(void), typeof(string), id);
        }
        /// <remarks>
        ///  Call this method from retrieveItem() once the result is available.
        /// <param> name="item" The retrieved item.
        ///      </param></remarks>        <short>    Call this method from retrieveItem() once the result is available.</short>
        protected void ItemRetrieved(Akonadi.Item item) {
            interceptor.Invoke("itemRetrieved#", "itemRetrieved(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
        }
        /// <remarks>
        ///  Resets the dirty flag of the given item and updates the remote id.
        ///  Call whenever you have successfully written changes back to the server.
        ///  This implicitly calls changeProcessed().
        /// <param> name="item" The changed item.
        ///      </param></remarks>        <short>    Resets the dirty flag of the given item and updates the remote id.</short>
        protected void ChangeCommitted(Akonadi.Item item) {
            interceptor.Invoke("changeCommitted#", "changeCommitted(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
        }
        /// <remarks>
        ///  Call whenever you have successfully handled or ignored a collection
        ///  change notification.
        ///  This will update the remote identifier of <code>collection</code> if necessary,
        ///  as well as any other collection attributes.
        ///  This implicitly calls changeProcessed().
        /// <param> name="collection" The collection which changes have been handled.
        ///     </param></remarks>        <short>    Call whenever you have successfully handled or ignored a collection  change notification.</short>
        protected void ChangeCommitted(Akonadi.Collection collection) {
            interceptor.Invoke("changeCommitted#", "changeCommitted(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection);
        }
        /// <remarks>
        ///  Call this to supply the full folder tree retrieved from the remote server.
        /// <param> name="collections" A list of collections.
        /// </param></remarks>        <short>    Call this to supply the full folder tree retrieved from the remote server.</short>
        ///         <see> collectionsRetrievedIncremental</see>
        protected void CollectionsRetrieved(List<Akonadi.Collection> collections) {
            interceptor.Invoke("collectionsRetrieved?", "collectionsRetrieved(const QList<Akonadi::Collection>&)", typeof(void), typeof(List<Akonadi.Collection>), collections);
        }
        /// <remarks>
        ///  Call this to supply incrementally retrieved collections from the remote server.
        /// <param> name="changedCollections" Collections that have been added or changed.
        /// </param><param> name="removedCollections" Collections that have been deleted.
        /// </param></remarks>        <short>    Call this to supply incrementally retrieved collections from the remote server.</short>
        ///         <see> collectionsRetrieved</see>
        protected void CollectionsRetrievedIncremental(List<Akonadi.Collection> changedCollections, List<Akonadi.Collection> removedCollections) {
            interceptor.Invoke("collectionsRetrievedIncremental??", "collectionsRetrievedIncremental(const QList<Akonadi::Collection>&, const QList<Akonadi::Collection>&)", typeof(void), typeof(List<Akonadi.Collection>), changedCollections, typeof(List<Akonadi.Collection>), removedCollections);
        }
        /// <remarks>
        ///  Call this method to supply the full collection listing from the remote server.
        ///  If the remote server supports incremental listing, it's strongly
        ///  recommended to use itemsRetrievedIncremental() instead.
        /// <param> name="items" A list of items.
        /// </param></remarks>        <short>    Call this method to supply the full collection listing from the remote server.</short>
        ///         <see> itemsRetrievedIncremental.</see>
        protected void ItemsRetrieved(List<Akonadi.Item> items) {
            interceptor.Invoke("itemsRetrieved?", "itemsRetrieved(const QList<Akonadi::Item>&)", typeof(void), typeof(List<Akonadi.Item>), items);
        }
        /// <remarks>
        ///  Enable item streaming.
        ///  Item streaming is disabled by default.
        /// <param> name="enable" <code>true</code> if items are delivered in chunks rather in one big block.
        ///      </param></remarks>        <short>    Enable item streaming.</short>
        protected void SetItemStreamingEnabled(bool enable) {
            interceptor.Invoke("setItemStreamingEnabled$", "setItemStreamingEnabled(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///  Call this method to supply incrementally retrieved items from the remote server.
        /// <param> name="changedItems" Items changed in the backend.
        /// </param><param> name="removedItems" Items removed from the backend.
        ///      </param></remarks>        <short>    Call this method to supply incrementally retrieved items from the remote server.</short>
        protected void ItemsRetrievedIncremental(List<Akonadi.Item> changedItems, List<Akonadi.Item> removedItems) {
            interceptor.Invoke("itemsRetrievedIncremental??", "itemsRetrievedIncremental(const QList<Akonadi::Item>&, const QList<Akonadi::Item>&)", typeof(void), typeof(List<Akonadi.Item>), changedItems, typeof(List<Akonadi.Item>), removedItems);
        }
        /// <remarks>
        ///  Call this method to indicate you finished synchronizing the current collection.
        ///  This is not needed if you use the built in syncing without item streaming
        ///  and call itemsRetrieved() or itemsRetrievedIncremental() instead.
        ///  If item streaming is enabled, call this method once all items have been delivered
        ///  using itemsRetrieved() or itemsRetrievedIncremental().
        /// </remarks>        <short>    Call this method to indicate you finished synchronizing the current collection.</short>
        ///         <see> retrieveItems</see>
        protected void ItemsRetrievalDone() {
            interceptor.Invoke("itemsRetrievalDone", "itemsRetrievalDone()", typeof(void));
        }
        /// <remarks>
        ///  Returns the collection that is currently synchronized.
        ///      </remarks>        <short>    Returns the collection that is currently synchronized.</short>
        protected Akonadi.Collection CurrentCollection() {
            return (Akonadi.Collection) interceptor.Invoke("currentCollection", "currentCollection() const", typeof(Akonadi.Collection));
        }
        /// <remarks>
        ///  Returns the item that is currently retrieved.
        ///      </remarks>        <short>    Returns the item that is currently retrieved.</short>
        protected Akonadi.Item CurrentItem() {
            return (Akonadi.Item) interceptor.Invoke("currentItem", "currentItem() const", typeof(Akonadi.Item));
        }
        /// <remarks>
        ///  This method is called whenever the resource should start synchronize all data.
        ///      </remarks>        <short>    This method is called whenever the resource should start synchronize all data.</short>
        protected void Synchronize() {
            interceptor.Invoke("synchronize", "synchronize()", typeof(void));
        }
        /// <remarks>
        ///  This method is called whenever the collection with the given <code>id</code>
        ///  shall be synchronized.
        ///      </remarks>        <short>    This method is called whenever the collection with the given <code>id</code>  shall be synchronized.</short>
        protected void SynchronizeCollection(long id) {
            interceptor.Invoke("synchronizeCollection$", "synchronizeCollection(qint64)", typeof(void), typeof(long), id);
        }
        /// <remarks>
        ///  Refetches the Collections.
        ///      </remarks>        <short>    Refetches the Collections.</short>
        protected void SynchronizeCollectionTree() {
            interceptor.Invoke("synchronizeCollectionTree", "synchronizeCollectionTree()", typeof(void));
        }
        /// <remarks>
        ///  Stops the execution of the current task and continues with the next one.
        ///      </remarks>        <short>    Stops the execution of the current task and continues with the next one.</short>
        protected void CancelTask() {
            interceptor.Invoke("cancelTask", "cancelTask()", typeof(void));
        }
        /// <remarks>
        ///  Stops the execution of the current task and continues with the next one.
        ///  Additionally an error message is emitted.
        ///      </remarks>        <short>    Stops the execution of the current task and continues with the next one.</short>
        protected void CancelTask(string error) {
            interceptor.Invoke("cancelTask$", "cancelTask(const QString&)", typeof(void), typeof(string), error);
        }
        /// <remarks>
        ///  Inherited from AgentBase.
        ///      </remarks>        <short>    Inherited from AgentBase.</short>
        [SmokeMethod("doSetOnline(bool)")]
        protected override void DoSetOnline(bool online) {
            interceptor.Invoke("doSetOnline$", "doSetOnline(bool)", typeof(void), typeof(bool), online);
        }
        /// <remarks>
        ///  Retrieve the collection tree from the remote server and supply it via
        ///  collectionsRetrieved() or collectionsRetrievedIncremental().
        /// </remarks>        <short>    Retrieve the collection tree from the remote server and supply it via  collectionsRetrieved() or collectionsRetrievedIncremental().</short>
        ///         <see> collectionsRetrieved</see>
        ///         <see> collectionsRetrievedIncremental</see>
        [SmokeMethod("retrieveCollections()")]
        protected abstract void RetrieveCollections();
        /// <remarks>
        ///  Retrieve all (new/changed) items in collection <code>collection.</code>
        ///  It is recommended to use incremental retrieval if the backend supports that
        ///  and provide the result by calling itemsRetrievedIncremental().
        ///  If incremental retrieval is not possible, provide the full listing by calling
        ///  itemsRetrieved( const Item.List& ).
        ///  In any case, ensure that all items have a correctly set remote identifier
        ///  to allow synchronizing with already locally existing items.
        ///  In case you don't want to use the built-in item syncing code, store the retrived
        ///  items manually and call itemsRetrieved() once you are done.
        /// <param> name="collection" The collection to sync.
        /// </param></remarks>        <short>    Retrieve all (new/changed) items in collection <code>collection.</code></short>
        ///         <see> itemsRetrieved(</see>
        ///         <see> const</see>
        ///         <see> Item.List</see>
        ///         <see> itemsRetrievedIncremental</see>
        ///         <see> itemsRetrieved</see>
        ///         <see> currentCollection</see>
        [SmokeMethod("retrieveItems(const Akonadi::Collection&)")]
        protected abstract void RetrieveItems(Akonadi.Collection collection);
        /// <remarks>
        ///  Retrieve a single item from the backend. The item to retrieve is provided as <code>item.</code>
        ///  Add the requested payload parts and call itemRetrieved() when done.
        /// <param> name="item" The empty item which payload should be retrieved. Use this object when delivering
        ///  the result instead of creating a new item to ensure conflict detection to work.
        /// </param><param> name="parts" The item parts that should be retrieved.
        /// </param></remarks>        <return> false if there is an immediate error when retrieving the item.
        /// </return>
        ///         <short>    Retrieve a single item from the backend.</short>
        ///         <see> itemRetrieved</see>
        protected new IResourceBaseSignals Emit {
            get { return (IResourceBaseSignals) Q_EMIT; }
        }
    }

    public interface IResourceBaseSignals : Akonadi.IAgentBaseSignals {
        /// <remarks>
        ///  This signal is emitted whenever the name of the resource has changed.
        /// <param> name="name" The new name of the resource.
        ///      </param></remarks>        <short>    This signal is emitted whenever the name of the resource has changed.</short>
        [Q_SIGNAL("void nameChanged(QString)")]
        void NameChanged(string name);
    }
}
