/*
 *
 *  KBluetooth4 - KDE Bluetooth Framework
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kbluetooth4.
 *
 *  kbluetooth4 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kbluetooth4 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth4; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#include "devicesel.h"

DeviceSel::DeviceSel(QObject* parent,QStringList filter) : Ui_deviceSelector()
{
	item = 0;
	filterList = filter;

	setupUi(this);
	setWindowIcon(KIcon("preferences-system-bluetooth"));
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(slotCancel()));
	connect(sendButton,SIGNAL(clicked()),this,SLOT(slotSend()));
	connect(searchButton,SIGNAL(clicked()),this,SLOT(slotSearch()));
	connect(extraCheckBox,SIGNAL(toggled(bool)),this,SLOT(slotUnlockChecker(bool)));

	Solid::Control::BluetoothManager &man = Solid::Control::BluetoothManager::self();
	adapter = new Solid::Control::BluetoothInterface(man.defaultInterface());

	show();

	slotSearch();

}

DeviceSel::~DeviceSel()
{
	if (adapter)
		delete adapter;
	if (item)
		delete item;

	qDeleteAll(deviceMap.begin(),deviceMap.end());
}


void DeviceSel::slotCancel()
{
	emit selectorCancelled();
	close();
}

void DeviceSel::slotRemoteDeviceFound(QString ubi,int dclass,int rssi)
{
	dev = adapter->createBluetoothRemoteDevice(ubi);
	if (deviceMap.contains(ubi) && (deviceListWidget->findItems(dev->name() + " - " + dev->address(),Qt::MatchExactly ).count() > 0 )) 
		return;


	if (!deviceMap.contains(ubi)) {
		deviceMap.insert(ubi,dev);
		macMap.insert(dev->address(),ubi);
	}

	if (deviceListWidget->findItems(dev->name() + " - " + dev->address(),Qt::MatchExactly ).count() <=0) {
		kDebug() << "dev major class: " << dev->majorClass();
		if (dev->majorClass() == "peripheral") {
			//we do not send files to peripheral devices
			return;
		}
		foreach(QString filt, filterList) {
			if ( dev->majorClass() == filt ) 
				item = new QListWidgetItem(KIcon(filt),dev->name() + " - " + dev->address(),deviceListWidget);
		}
	}

}

void DeviceSel::slotDiscoveryCompleted()
{
	searchButton->setText(i18n("Search"));
	searchButton->setEnabled(true);
	sendButton->setEnabled(true);
	disconnect(adapter,SIGNAL(remoteDeviceFound(QString,int,int)),this,SLOT(slotRemoteDeviceFound(QString,int,int)));
	disconnect(adapter,SIGNAL(discoveryCompleted()),this,SLOT(slotDiscoveryCompleted()));
	disconnect(adapter,SIGNAL(discoveryStarted()),this,SLOT(slotDiscoveryStarted()));
	disconnect(adapter,SIGNAL(remoteNameUpdated(const QString&, const QString&)),this,SLOT(slotNewNameFound(const QString&, const QString&)));

}

void DeviceSel::slotDiscoveryStarted()
{
	searchButton->setText(i18n("Searching..."));
	searchButton->setEnabled(false);
	sendButton->setEnabled(false);
}

void DeviceSel::slotSearch()
{
	searchButton->setEnabled(false);
	sendButton->setEnabled(false);
	adapter->discoverDevices();
	connect(adapter,SIGNAL(remoteDeviceFound(QString,int,int)),this,SLOT(slotRemoteDeviceFound(QString,int,int)));
	connect(adapter,SIGNAL(discoveryCompleted()),this,SLOT(slotDiscoveryCompleted()));
	connect(adapter,SIGNAL(discoveryStarted()),this,SLOT(slotDiscoveryStarted()));
	connect(adapter,SIGNAL(remoteNameUpdated(const QString&, const QString&)),this,SLOT(slotNewNameFound(const QString&, const QString&)));
	

}


void DeviceSel::slotSend()
{
	QString mac = deviceListWidget->currentItem()->text().split(" - ").at(1);
	emit deviceSelected(mac,macMap.value(mac));
	close();


}

void DeviceSel::setOkButtonText(const QString& txt)
{
	sendButton->setText(txt);
}

void DeviceSel::slotNewNameFound(const QString& address, const QString& name)
{
	if ( deviceListWidget->findItems(address,Qt::MatchContains ).count() > 0) {
		QListWidgetItem* it = deviceListWidget->findItems(address,Qt::MatchContains).at(0);
		it->setText(name + " - " + address);
	}
}

void DeviceSel::setInfoLabel(const QString& txt)
{
	infoLabel->setText(txt);
}

void DeviceSel::hideExtraCheckBox()
{
	extraCheckBox->hide();
}

void DeviceSel::slotUnlockChecker(bool check)
{
	emit unlockChanged(check);
}

