/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef SERIALDEVICEWIDGET_H
#define SERIALDEVICEWIDGET_H

class QString;
class QWidget;
class WFlags;
class QGridLayout;
class QLabel;
class QComboBox;

class SerialDeviceWidget
  : public QWidget {
  Q_OBJECT
public:
  enum {
    Speed9600 = 1 << 0,
    Speed19200 = 1 << 1,
    Speed38400 = 1 << 2,
    Speed57600 = 1 << 3,
    Speed115200 = 1 << 4,
    Speed230400 = 1 << 5,
    AllSpeeds = Speed9600 | Speed19200 | Speed38400 | Speed57600 | Speed115200 | Speed230400,
    BFBSpeeds = Speed57600 | Speed115200
  };

  SerialDeviceWidget( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~SerialDeviceWidget();

  QString device() const;
  int speed() const;

public slots:
  void setDevice( const QString& );
  void setSpeed( int );
  void setAvailableSpeeds( int );
  void checkConfiguration();

signals:
  void configurationReady( bool );
  
private:
  QGridLayout* mLayout;
  QLabel* mDeviceText;
  QComboBox* mDeviceSelector;
  QLabel* mSpeedText;
  QComboBox* mSpeedSelector;

  int mSpeeds;
};

#endif
