//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen <kdebluetooth@schaettgen.de>*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef KBLUETOOTHDEVICEINPUTWIDGET_H
#define KBLUETOOTHDEVICEINPUTWIDGET_H

#include "deviceinputwidgetbase.h"
#include "deviceaddress.h"
#include <map>

namespace KBluetooth {

class Inquiry;

/**
@author Fred Schaettgen
*/
class DeviceInputWidget : public DeviceInputWidgetBase
{
Q_OBJECT
public:
    DeviceInputWidget(QWidget *parent);
    ~DeviceInputWidget();
    void init(bool useDiscoveryService = false);
    void startSearch();
    void stopSearch();
    static bool showSelectionDialog(QWidget* parent,
        KBluetooth::DeviceAddress &address, 
        bool bInitFromDiscoveryService);
    KBluetooth::DeviceAddress currentAddress();
public slots:
    void neighbourFound(const KBluetooth::DeviceAddress& bdaddr, int deviceClass);
    void searchFinished();
    void selectionChanged();
signals:
    void addressValid(bool);    
private:
    std::map<KBluetooth::DeviceAddress, QString> addrToNameMap;
    std::map<QString, KBluetooth::DeviceAddress> nameToAddrMap;
    KBluetooth::Inquiry *inquiry;
private slots:
    void inquiryStart();
    void checkAddress();
};

};

#endif
