/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <qstring.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlayout.h>

#include <klocale.h>

#include "serialdevicewidget.h"

SerialDeviceWidget::SerialDeviceWidget( QWidget* parent, const char* name, WFlags fl )
  : QWidget( parent, name, fl )
{
  int margin = 11;
  int space = 6;

  mLayout = new QGridLayout( this, 2, 2, margin, space, "SerialDeviceWidgetLayout"); 
  
  mDeviceText = new QLabel( this, "SerialDeviceWidgetDeviceText" );
  mDeviceText->setText( i18n( "Serial device" ) );
  mLayout->addWidget( mDeviceText, 0, 0 );

  mDeviceSelector = new QComboBox( FALSE, this, "SerialDeviceWidgetDeviceSelector" );
  mDeviceSelector->setEditable( TRUE );
  mDeviceSelector->insertItem( "/dev/ttyS0" );
  mDeviceSelector->insertItem( "/dev/ttyS1" );
  mLayout->addWidget( mDeviceSelector, 0, 1 );

  mSpeedText = new QLabel( this, "SerialDeviceWidgetDeviceSpeedText" );
  mSpeedText->setText( i18n( "Choose a device speed" ) );
  mLayout->addWidget( mSpeedText, 1, 0 );
  
  mSpeedSelector = new QComboBox( FALSE, this, "SerialDeviceWidgetDeviceSpeedSelector" );
  mLayout->addWidget( mSpeedSelector, 1, 1 );

  connect( mDeviceSelector, SIGNAL(textChanged(const QString&)), SLOT(checkConfiguration()) );
  connect( mSpeedSelector, SIGNAL(textChanged(const QString&)), SLOT(checkConfiguration()) );
}

SerialDeviceWidget::~SerialDeviceWidget()
{
}

QString SerialDeviceWidget::device() const
{
  return mDeviceSelector->currentText();
}

int SerialDeviceWidget::speed() const
{
  int idx = 0;
  int ci = mSpeedSelector->currentItem();

  if ( mSpeeds & Speed9600 ) {
    if ( ci == idx )
      return 9600;
    ++idx;
  }
  if ( mSpeeds & Speed19200 ) {
    if ( ci == idx )
      return 19200;
    ++idx;
  }
  if ( mSpeeds & Speed38400 ) {
    if ( ci == idx )
      return 38400;
    ++idx;
  }
  if ( mSpeeds & Speed57600 ) {
    if ( ci == idx )
      return 57600;
    ++idx;
  }
  if ( mSpeeds & Speed115200 ) {
    if ( ci == idx )
      return 115200;
    ++idx;
  }
  if ( mSpeeds & Speed230400 ) {
    if ( ci == idx )
      return 230400;
  }
  return 0;
}

void SerialDeviceWidget::setDevice( const QString& dev )
{
  mSpeedSelector->setEditText( dev );
}

void SerialDeviceWidget::setSpeed( int sp )
{
  int idx = 0;
  if ( mSpeeds & Speed9600 ) {
    if ( sp == 9600 )
      mSpeedSelector->setCurrentItem( idx );
    ++idx;
  }
  if ( mSpeeds & Speed19200 ) {
    if ( sp == 19200 )
      mSpeedSelector->setCurrentItem( idx );
    ++idx;
  }
  if ( mSpeeds & Speed38400 ) {
    if ( sp == 38400 )
      mSpeedSelector->setCurrentItem( idx );
    ++idx;
  }
  if ( mSpeeds & Speed57600 ) {
    if ( sp == 57600 )
      mSpeedSelector->setCurrentItem( idx );
    ++idx;
  }
  if ( mSpeeds & Speed115200 ) {
    if ( sp == 115200 )
      mSpeedSelector->setCurrentItem( idx );
    ++idx;
  }
  if ( mSpeeds & Speed230400 ) {
    if ( sp == 230400 )
      mSpeedSelector->setCurrentItem( idx );
  }
}

void SerialDeviceWidget::setAvailableSpeeds( int speeds )
{
  int idx = 0;
  mSpeeds = speeds;
  mSpeedSelector->clear();
  if ( mSpeeds & Speed9600 ) {
    mSpeedSelector->insertItem( i18n( "9600 Baud" ) );
    ++idx;
  }
  if ( mSpeeds & Speed19200 ) {
    mSpeedSelector->insertItem( i18n( "19200 Baud" ) );
    ++idx;
  }
  if ( mSpeeds & Speed38400 ) {
    mSpeedSelector->insertItem( i18n( "38400 Baud" ) );
    ++idx;
  }
  if ( mSpeeds & Speed57600 ) {
    mSpeedSelector->insertItem( i18n( "57600 Baud" ) );
    mSpeedSelector->setCurrentItem( idx );
  }
  if ( mSpeeds & Speed115200 )
    mSpeedSelector->insertItem( i18n( "115200 Baud" ) );
  if ( mSpeeds & Speed230400 )
    mSpeedSelector->insertItem( i18n( "230400 Baud" ) );
}

void SerialDeviceWidget::checkConfiguration()
{
  bool ok = !device().isEmpty() && speed() != 0;
  emit configurationReady( ok );
}

#include "serialdevicewidget.moc"
