/***************************************************************************
                          kdesudo.cpp  -  description
                             -------------------
    begin                : Sam Feb 15 15:42:12 CET 2003
    copyright            : (C) 2003 by Robert Gruber <rgruber@users.sourceforge.net>
                           (C) 2007 by Martin Böhm <martin.bohm@kubuntu.org>
                                       Anthony Mercatante <tonio@kubuntu.org>
                                       Canonical Ltd (Jonathan Riddell <jriddell@ubuntu.com>)

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kdesudo.h"
#include <kmessagebox.h>
#include <kdesktopfile.h>
#include <kiconloader.h>
#include <kicontheme.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprocess.h>
#include <kdebug.h>

static const char *description =
	I18N_NOOP("KdeSudo");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
	{ "u <runas>", I18N_NOOP("sets a runas user"), 0 },
	{ "c <command>", I18N_NOOP("The command to execute"), 0 },
	{ "s", I18N_NOOP("Forget passwords"), 0 },
	{ "+command", I18N_NOOP("The command to execute"), 0 },
	/* not yet implemented */
	/* { "nonewdcop", I18N_NOOP("Let command use existing dcopserver"), 0 }, */
	{ "noignorebutton", I18N_NOOP("Do not display ignore button"), 0 },
	{ "i <icon name>", I18N_NOOP("Specify icon to use in the password dialog"), 0},
	{ "d", I18N_NOOP("Do not show the command to be run in the dialog"), 0},
	{ "n", I18N_NOOP("No function, for compatibility with kdesu"), 0},
	{ "nonewdcop", I18N_NOOP("Use existing DCOP server"), 0},
	{ "comment <dialog text>", I18N_NOOP("The comment that should be displayed in the dialog"),  0},
	KCmdLineLastOption
};

int main(int argc, char **argv)
{

	KAboutData aboutData( "kdesudo", I18N_NOOP("KdeSudo"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2003, Robert Gruber", 0, 0, "rgruber@users.sourceforge.net");
	aboutData.addAuthor("Robert Gruber",0, "rgruber@users.sourceforge.net");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	/* Get the comment out of cli args */
	QByteArray commentBytes = args->getOption("comment");
	QTextCodec* tCodecConv = QTextCodec::codecForLocale();
	QString commentArg = tCodecConv->toUnicode(commentBytes, commentBytes.size());

	KApplication a;

	/* forget passwords */
	if (args->isSet("s")) 
	{
		KShellProcess *s = new KShellProcess;
		s->clearArguments();
		*s << "sudo -k";
		s->start( KProcess::NotifyOnExit, KProcess::All );
		return 0;
	}
	/* -i icon parameter */
	QString icon;
	if ( args->isSet("i"))
		icon = args->getOption("i");

	/* command prompt handling */
	bool showCommand = true;
	if ( args->isSet("d"))
		showCommand = false;

	bool withIgnoreButton = args->isSet("ignorebutton");
	QString strRunas = args->getOption("u");

	QString strCmd = args->getOption("c");
	QString executable = strCmd;
	if (args->count())
	{
		if (strCmd!=QString())
		{
			strCmd += ' ';
			strCmd += args->arg(0);
		}
		else
		{
			strCmd = args->arg(0);
			executable = strCmd;
		}

		if (args->count()>0)
		{
			for (int i = 1; i < args->count(); i++)
			{
				strCmd += ' ';
				strCmd +=  args->arg(i);
			}
		}
	}

	if (strCmd.isEmpty())
	{
		KMessageBox::information(NULL, i18n("No command arguments supplied!\nUsage: kdesudo [-u <runas>] <command>\nKdeSudo will now exit..."));
		return 0;
	}


	/* Kubuntu has a bug in it - this is a workaround for it */  
	KGlobal::dirs()->addResourceDir("apps","/usr/share/applications/kde");
	KGlobal::dirs()->addResourceDir("apps","/usr/share/applications");
	/* icon parsing */
	QString deskFilePath = KGlobal::dirs()->findResource("apps",executable + ".desktop");
	KDesktopFile desktopFile(deskFilePath,true);
	if (icon.isEmpty())
	{
		QString iconName = desktopFile.readIcon();
		//qDebug(deskFilePath);
		icon = KGlobal::iconLoader()->iconPath(iconName, -1* KIcon::StdSizes(KIcon::SizeHuge), true);
	}
	/* generic name parsing */
	QString name = desktopFile.readName();
	QString genericName = desktopFile.readGenericName();

	if (!name.isEmpty())
	{
		if (!genericName.isEmpty())
		name += " - " + genericName;
	}
	else if (!genericName.isEmpty())
		name = genericName;

	bool newDcop = args->isSet("newdcop");

	KdeSudo *kdesudo = new KdeSudo(0,0,strCmd,strRunas,commentArg,icon,name,withIgnoreButton,newDcop);

	if(showCommand == true)
		(*kdesudo).addLine(i18n("Command:"), strCmd);

	a.setMainWidget(kdesudo);
	args->clear();

	return a.exec();
}
