/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "backupconfig.h"

#include <kdebug.h>

BackupConfig::BackupConfig()
{
	m_config = new KConfig( "keepbackuplist.rc", false );
}

BackupConfig::~BackupConfig()
{
	delete m_config;
}
	
void BackupConfig::addBackup(Backup backup)
{
	int id = generateId();

	m_config->setGroup( ("Backup_" + QString::number(id)) );
	m_config->writeEntry( "Source", backup.source());
	m_config->writeEntry( "Dest", backup.dest());
	m_config->writeEntry( "Interval", backup.interval());
	m_config->writeEntry( "DeleteAfter", backup.deleteAfter());
	m_config->writeEntry( "NeverDelete", backup.neverDelete());
	m_config->writeEntry( "UseCompression", backup.useCompression());
	m_config->writeEntry( "ExcludeSpecialFiles", backup.excludeSpecialFiles());
	m_config->writeEntry( "UseAdvancedConfig", backup.useAdvancedConfig());
	m_config->writeEntry( "OptionList", backup.optionList());
	m_config->sync();
}

QValueList<Backup> BackupConfig::backupList()
{
	QValueList<Backup> backupList;
	QStringList groupList = m_config->groupList();
	QStringList backupNameList = groupList.grep("Backup_");
	for ( QStringList::Iterator it = backupNameList.begin(); it != backupNameList.end(); ++it ) {
		m_config->setGroup(*it);
		QString source = m_config->readEntry("Source");
		QString dest = m_config->readEntry("Dest");
		int interval = m_config->readNumEntry("Interval");
		int deleteAfter = m_config->readNumEntry("DeleteAfter");
		bool neverDelete = m_config->readBoolEntry("NeverDelete");
		bool useCompression = m_config->readBoolEntry("UseCompression");
		bool excludeSpecialFiles = m_config->readBoolEntry("ExcludeSpecialFiles");
		bool useAdvancedConfig = m_config->readBoolEntry("UseAdvancedConfig");
		QStringList optionList = m_config->readListEntry( "OptionList");

		backupList.append(Backup(source,dest,interval,deleteAfter,neverDelete,useCompression,excludeSpecialFiles,useAdvancedConfig,optionList));
	}
	return backupList;
}

void BackupConfig::setBackupList(QValueList<Backup> backups)
{
	QStringList groupList = m_config->groupList();
	QStringList backupNameList = groupList.grep("Backup_");
	for ( QStringList::Iterator it = backupNameList.begin(); it != backupNameList.end(); ++it ) {
		m_config->deleteGroup(*it);
	}
	m_config->sync();
	QValueList<Backup>::iterator it;
	for ( it = backups.begin(); it != backups.end(); ++it )
	{
		addBackup(*it);
	}
}

int BackupConfig::generateId()
{
	m_config->setGroup("General");
	int id = m_config->readNumEntry("LastId",0);
	int newid = id + 1;
	m_config->writeEntry( "LastId", newid);
	m_config->sync();
	return newid;
}

