#!/bin/sh

project_file="$1"
project_id="$2"
project_title="$3"

if [ -f /etc/kino-scripts ]; then 
	. /etc/kino-scripts
fi

if [ -f "$HOME"/.kino-scripts ]; then
	. "$HOME"/.kino-scripts
fi

if [ -f "$HOME"/kino/scripts/project.sh ]; then
	. "$HOME"/kino/scripts/project.sh "$project_file" "$project_id" "$project_title"
else
	if [ -n "$KINO_PUBLISH_PROJECT" ]; then
		"$KINO_PUBLISH_PROJECT" "$project_file" "$project_id" "$project_title"
	else
		echo "\$datadir/kino/scripts/publish/project.sh project_file=\"$project_file\" project_id=\"$project_id\" project_title=\"$project_title\"" 
	fi
fi
