#!/bin/sh

# Modified by Tobi Vollebregt for use with kio-locate.

# Inspired by Makefile.common from coolo
# this script is used to update the .po files

# To update the translations, you will need a specific gettext
# patched for kde and a lot of patience, tenacity, luck, time ..


# I guess one should only update the .po files when all .cpp files
# are generated (after a make or scons)

# If you have a better way to do this, do not keep that info
# for yourself and help me to improve this script, thanks
# (tnagyemail-mail tat yahoo d0tt fr)
#

SRCDIR=../src
TIPSDIR=$SRCDIR/appdata

KDEDIR=`kde-config --prefix`
EXTRACTRC=extractrc
KDEPOT=`kde-config --prefix`/include/kde/kde.pot
XGETTEXT="xgettext -C -ki18n -ktr2i18n -kI18N_NOOP -ktranslate -kaliasLocale -x $KDEPOT "

## check that kde.pot is available
if ! test -e $KDEPOT; then
	echo "$KDEPOT does not exist, there may be something wrong with your installation!"
	XGETTEXT="xgettext -C -ki18n -ktr2i18n -kI18N_NOOP -ktranslate -kaliasLocale "
fi

## extract the strings
echo "extracting the strings"

echo -e 'i18n("_: NAME OF TRANSLATORS\\n"\n"Your names")\ni18n("_: EMAIL OF TRANSLATORS\\n"\n"Your emails")' > $SRCDIR/_translatorinfo.cpp

$XGETTEXT `find $SRCDIR -name "*.cpp"` -o kio_locate.pot

# remove the intermediate files
rm -f $SRCDIR/_translatorinfo.cpp

## now merge the .po files ..
echo "merging the .po files"

for i in `ls *.po`; do
	msgmerge $i kio_locate.pot -o $i || exit 1
done

## finished
echo "Done"