/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-01
 * Description : a plugin to export to a remote Gallery server.
 *
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006 by Colin Guthrie <kde@colin.guthr.ie>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2008 by Andrea Diamantini <adjam7 at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef GALLERYCONFIG_H
#define GALLERYCONFIG_H

// Qt includes.

#include <QLabel>
#include <QCheckBox>

// KDE includes.

#include <kdialog.h>
#include <klineedit.h>

namespace KIPIGalleryExportPlugin
{

class Gallery;

class GalleryEdit : public KDialog
{
    Q_OBJECT

public:

    GalleryEdit(QWidget* pParent,
                Gallery* pGallery,
                QString title);
    ~GalleryEdit();

private:

    Gallery*         mpGallery;
    QLabel*          mpHeaderLabel;
    KLineEdit*       mpNameEdit;
    KLineEdit*       mpUrlEdit;
    KLineEdit*       mpUsernameEdit;
    KLineEdit*       mpPasswordEdit;
    QCheckBox*       mpGalleryVersion;

private slots:
    void slotOk(void);
};

}

#endif /* GALLERYCONFIG_H */
