/***************************************************************************
 *
 * knetworkmanager-synchronizer.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2006 Valentine Sinitsyn.
 *
 * Author: Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/
 
#include <kdebug.h>
#include <kstaticdeleter.h>

#include "knetworkmanager-device.h"
#include "knetworkmanager-network.h"
#include "knetworkmanager-storage.h"
#include "knetworkmanager-synchronizer.h"

Synchronizer::Synchronizer(Device * dev)
{
	device = dev;
	sources = Any;
}

Synchronizer::~Synchronizer()
{
}

void
Synchronizer::setSources(int sources)
{
	if (sources & (Pending | Storage | New)) {
		this->sources = sources;
	} else {
		kdWarning() << k_funcinfo << "should specify at least one usable source" << endl;
	}
}

Network *
Synchronizer::synchronize(const QString &essid, const QString &net_path)
{
	Network *net = device->getNetwork(net_path);

	if (!net) {
		if (sources & Pending) {
			net = device->getPendingNetwork(essid);
			if (net) device->clearPendingNetwork();
		}

		if ( !net && (sources & Storage) ) {
			net = KNetworkManagerStorage::getInstance()->networkProperties(essid);
		}

		if ( !net && (sources & New) ) {
			net = new Network(net_path);
			net->setEssid(essid);
		}

		if (net) {
			net->setObjectPath(net_path);
			device->addNetwork(net);
		}
	}

	return net;
}
