/***************************************************************************
 *
 * knetworkmanager-connection_setting_gsm_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <qwidget.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qiconset.h>
#include <kiconloader.h>
#include <qwidgetstack.h>
#include <kuser.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_gsm.h"
#include "knetworkmanager-connection_setting_gsm_widget.h"
#include "knetworkmanager-device.h"

#include "connection_setting_gsm.h"

using namespace ConnectionSettings;

GSMWidgetImpl::GSMWidgetImpl(Connection* conn, QWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_gsmsetting = dynamic_cast<ConnectionSettings::GSM*> (conn->getSetting(NM_SETTING_GSM_SETTING_NAME));

	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingGsmWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
GSMWidgetImpl::Init()
{
    _mainWid->mUsername->setText( _gsmsetting->getUsername() );
    _mainWid->mPassword->setText( _gsmsetting->getPassword( ) );
    _mainWid->mPin->setText( _gsmsetting->getPin() );
    _mainWid->mPuk->setText( _gsmsetting->getPuk() );
    _mainWid->mNumber->setText( _gsmsetting->getNumber() );
    _mainWid->mApn->setText( _gsmsetting->getAPN() );
    _mainWid->mNetworkId->setText( _gsmsetting->getNetworkID( ));
    _mainWid->mNetworkType->setCurrentItem( _gsmsetting->getNetworkType( ) +1);
    _mainWid->mBand->setValue( _gsmsetting->getBand() );

    connect( _mainWid->mUsername, SIGNAL(textChanged(const QString&)), SLOT(dirty()));
    connect( _mainWid->mPassword, SIGNAL(textChanged(const QString&)), SLOT(dirty()));
    connect( _mainWid->mPin, SIGNAL(textChanged(const QString&)), SLOT(dirty()));
    connect( _mainWid->mPuk, SIGNAL(textChanged(const QString&)), SLOT(dirty()));
    connect( _mainWid->mNumber, SIGNAL(textChanged(const QString&)), SLOT(dirty()));
    connect( _mainWid->mApn, SIGNAL(textChanged(const QString&)), SLOT(dirty()));
    connect( _mainWid->mNetworkId, SIGNAL(textChanged(const QString&)), SLOT(dirty()));
    connect( _mainWid->mNetworkType, SIGNAL(activated(int)), SLOT(dirty()));
    connect( _mainWid->mBand, SIGNAL(valueChanged(int)), SLOT(dirty()));
}

void
GSMWidgetImpl::Deactivate()
{
}

void
GSMWidgetImpl::Activate()
{

}

void
GSMWidgetImpl::dirty()
{
    _gsmsetting->setUsername( _mainWid->mUsername->text() );
    _gsmsetting->setPassword( _mainWid->mPassword->text() );
    _gsmsetting->setPin( _mainWid->mPin->text() );
    _gsmsetting->setPuk( _mainWid->mPuk->text() );
    _gsmsetting->setNumber( _mainWid->mNumber->text() );
    _gsmsetting->setAPN( _mainWid->mApn->text() );
    _gsmsetting->setNetworkID( _mainWid->mNetworkId->text() );
    _gsmsetting->setNetworkType( _mainWid->mNetworkType->currentItem() - 1 );
    _gsmsetting->setBand( _mainWid->mBand->value() );
}

#include "knetworkmanager-connection_setting_gsm_widget.moc"
