/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_H
#define KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_H

#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>

#include <dbus/qdbusdata.h>
#include "knetworkmanager-connection_setting.h"
#include "qbidirectionalmap.h"
/* NM headers */
#include <nm-setting-wireless.h>


class AccessPoint;

namespace ConnectionSettings
{


class WirelessSecurity;
class Connection;


// setting for wireless interfaces
class Wireless : public ConnectionSetting
{
	public:

		enum MODES
		{
		  MODE_INFRASTRUCTURE = 0
		, MODE_ADHOC
		};

		Wireless(Connection* conn, ::AccessPoint* ap = NULL, WirelessSecurity* security = NULL);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		void              setEssid(const QByteArray&);
		QByteArray        getEssid(void) const;

		void              setMode(MODES);
		MODES             getMode(void) const;

		void              setSecurity(const QString&);
		QString           getSecurity(void) const;

		bool              isValid() const;

		void              addSeenBssid(const QString&);

	private:
		QByteArray              _essid;
		MODES                   _mode;
		QString                 _band;
		uint32_t                _channel;
		QByteArray              _bssid;
		uint32_t                _rate;
		uint32_t                _txPower;
		QByteArray              _macAddress;
		uint32_t                _mtu;
		QValueList<QString>     _seenBssids;
		QString                 _security;

		QBiDirectionalMap<MODES, QString> _modeMap;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_H */
