/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_SECURITY_H
#define KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_SECURITY_H

#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>

#include <dbus/qdbusdata.h>

#include "knetworkmanager-connection_setting.h"
#include "qbidirectionalmap.h"
/* NM */
#include <nm-setting-wireless-security.h>
#include <nm-setting-wireless.h>


class AccessPoint;

namespace ConnectionSettings
{

class WirelessSecurity;


// setting for wireless security parameters
class WirelessSecurity : public ConnectionSetting
{
	public:
		// bitwise or-able ciphers
		enum CIPHERS
		{
		  CIPHER_NONE   = 0
		, CIPHER_TKIP   = 1
		, CIPHER_CCMP   = 2
		, CIPHER_WEP40  = 4
		, CIPHER_WEP104 = 8
		, CIPHER_AUTO   = CIPHER_TKIP | CIPHER_CCMP
		};

		enum KEY_MGMT
		{
		  KEY_MGMT_NONE = 0
		, KEY_MGMT_IEEE8021X
		, KEY_MGMT_WPA_NONE
		, KEY_MGMT_WPA_PSK
		, KEY_MGMT_WPA_EAP
		};

		enum AUTH_ALG
		{
		  AUTH_ALG_NONE = 0
		, AUTH_ALG_OPEN
		, AUTH_ALG_SHARED
		, AUTH_ALG_LEAP
		};

		// bitwise or-able protos
		enum PROTO
		{
		  PROTO_NONE = 0
    , PROTO_AUTO = PROTO_NONE
		, PROTO_WPA
		, PROTO_RSN
		};

		WirelessSecurity(Connection* conn);
		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		SettingsMap toSecretsMap(bool with_settings = true) const;
		bool        fromSecretsMap(const SettingsMap&);

		uint32_t getGroupCiphers(void) const;
		void     setGroupCiphers(uint32_t);

		uint32_t getPairwiseCiphers(void) const;
		void     setPairwiseCiphers(uint32_t);

		KEY_MGMT getKeyMgmt(void) const;
		void     setKeyMgmt(KEY_MGMT);

		AUTH_ALG getAuthAlg(void) const;
		void     setAuthAlg(AUTH_ALG);

		uint32_t getProto(void) const;
		void     setProto(uint32_t);
		void     addProto(uint32_t);
		void     delProto(uint32_t);

		QString  getPSK(void) const;
		void     setPSK(const QString&);

		QString  getLeapUsername(void) const;
		void     setLeapUsername(const QString&);

		QString  getLeapPassword(void) const;
		void     setLeapPassword(const QString&);

		QString  getWepKey(int) const;
		void     setWepKey(int, QString);

		int      getWepTxidx() const;
		void     setWepTxidx(int);

		bool     isValid() const;
		bool     getEnabled() const;

	private:
		// settigs
		KEY_MGMT _keyMgmt;
		int     _wepTxKeyidx;
		AUTH_ALG _authAlg;
		uint32_t _proto;
		uint32_t _pairwise;
		uint32_t _group;
		QString  _leapUsername;

		// secrets
		QString _wepKey[4];
		QString _psk;
		QString _leapPassword;

		QBiDirectionalMap<KEY_MGMT, QString> _keyMgmtMap;
		QBiDirectionalMap<AUTH_ALG, QString> _authAlgMap;
		QBiDirectionalMap<PROTO, QString> _protoMap;
		QBiDirectionalMap<CIPHERS, QString> _cipherMap;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_SECURITY_H */
