/***************************************************************************
 *
 * knetworkmanager-storage.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_STORAGE_H
#define KNETWORKMANAGER_STORAGE_H

#include <qvaluelist.h>
#include <qobject.h>

namespace ConnectionSettings
{
	class Connection;
	class ConnectionSetting;
}

using namespace ConnectionSettings;

class StoragePrivate;

// This class abstracts the storage of settings and connections to the disk
class Storage : public QObject
{
	Q_OBJECT

	public:
		// Singleton
		static Storage* getInstance();

		// restore all available connections
		void restoreConnections();

		// save all connections to the config file
		void saveConnections();

		// restore all settings secrets as they are not restored automatically
		bool restoreAllSecrets(Connection*);

		// restore a settings secrets as they are not restored automatically
		bool restoreSecrets(Connection*, ConnectionSetting*);

		// check whether we have the secrets stored, either in KWallet or in the configfile
		bool hasSecretsStored(Connection*, ConnectionSetting*);
		bool hasSecretsStored(Connection*);

		~Storage();
	public slots:
		void slotInit();

		// save everything to the config file
		void slotSave();

		// restore everything from the config file
		void slotRestore();

		// called for every newly created connection
		void slotConnectionAdded(ConnectionSettings::Connection*);

		// called for every removed connection
		void slotConnectionRemoved(ConnectionSettings::Connection*);

	signals:

	private:
		Storage();

		Connection* createConnectionByType(const QString&);

		Connection* restoreConnection(const QString&);
		bool restoreSecrets(Connection*, const QString&);
		bool restoreSetting(Connection*, const QString&);

		bool saveConnection(Connection* conn);
		bool saveConnectionSettings(Connection* conn, QStringList&, QStringList&);
		bool saveConnectionSetting(Connection* conn, ConnectionSetting* setting, QString& grp);
		bool saveConnectionSecrets(Connection* conn, ConnectionSetting* setting, QString& grp);

		bool deleteConnection(Connection* conn);

		StoragePrivate* d;
};

#endif /* KNETWORKMANAGER_STORAGE_H */
