#!/bin/sh

ACTION=$1
PKGNAME=$2

TMPDIR=`mktemp -d` || exit 1
echo "program output" >> $TMPDIR
TMPFILE=`mktemp` || exit 1
echo "program output" >> $TMPFILE

function get_file () {
	ch=`dpkg-deb -c $PKGNAME | grep $1 | sed s/'^.* \.\/\(.*\)$'/'\1'/`
	if [ $ch ]; then
		dpkg-deb -x $PKGNAME $TMPDIR
		cat $TMPDIR/$ch | gunzip > $TMPFILE
		kdialog --textbox $TMPFILE 800 600
		rm $TMPFILE
		rm -rf $TMPDIR
		return 0
	else 
		return 1
	fi
}

case $ACTION in
  info)
	dpkg-deb -I $PKGNAME > $TMPFILE
	echo " " >> $TMPFILE
	echo "Status: " >> $TMPFILE
	name=`basename $PKGNAME | cut -d_ -f1`
	dpkg-query -W --showformat='${Status}' $name >> $TMPFILE
	echo -e '\n----\nPackage contents:\n \n' >> $TMPFILE
	dpkg-deb -c $2 >> $TMPFILE
	kdialog --textbox $TMPFILE 800 600
	rm $TMPFILE
	exit 0
	;;

  *)
	exit 1
	;;
esac