#!/bin/sh
################################################################################
# Copyright (C) 2009 Richard A. Johnson <nixternal@ubuntu.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################

# Execute this script within the root of the docs directory (../docs)

# TODO: create the script to convert .po files to translated xml files

# for every .po file in $$doc/po mkdir $$doc/$$lang
# convert $$doc/po/$$lang.po to $$doc/$$lang/$$doc.xml
# example:  po2xml $$doc/C/$$doc.xml $$doc/po/$$lang.po > $$doc/$$lang/$$doc.xml

#same .po name in two places in the package confuses it
mv data/about/po/*po docs/about/po/

#dunno why but some get put into kubuntu/
cd kubuntu/; for asdf in *; do echo ${asdf}; mv ${asdf}/po/kubuntu-docs-${asdf}* ../docs/${asdf}/po/; done; cd ..

LANGS=`ls docs/*/po/kubuntu-docs-*.po | sed s,docs/.*/po/kubuntu-docs-.*-,, | sed s,.po,, | sort | uniq`

echo $LANGS

cd docs;

for doc in *; \
  do echo $doc; \
  for lang in $LANGS;\
    do echo $doc $lang; \
    if [ -e $doc/po/kubuntu-docs-${doc}-${lang}.po ]; then \
      mkdir -p $doc/$lang; \
      #echo "po2xml $doc/C/$doc.xml $doc/po/kubuntu-docs-${doc}-${lang}.po > $doc/$lang/$doc.xml" `pwd`; \
      po2xml $doc/C/$doc.xml $doc/po/kubuntu-docs-${doc}-$lang.po > $doc/$lang/$doc.xml; \
    fi; \
  done; \
done;

for doc in about; \
  do echo $doc; \
  for lang in $LANGS;\
    do echo $doc $lang; \
    if [ -e $doc/po/${doc}-${lang}.po ]; then \
      mkdir -p $doc/$lang; \
      #echo "po2xml $doc/C/$doc.xml $doc/po/kubuntu-docs-${doc}-${lang}.po > $doc/$lang/$doc.xml" `pwd`; \
      po2xml $doc/C/$doc.xml $doc/po/${doc}-$lang.po > $doc/$lang/$doc.xml; \
    fi; \
  done; \
done;

cd ..
