#!/bin/sh

################################################################################
# Copyright (c) 2009 Richard A. Johnson <nixternal@ubuntu.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# remarks: Use this script to fix up the build output for help.kubuntu.org
# usage:   cd path/to/build/ && ../scripts/hko.sh
# example: cd ../build && ../scripts/hko.sh
################################################################################

for x in `ls kubuntu/`; do
	if [ "$x" != "images" ]; then
		for y in `ls kubuntu/${x}/C/`; do
			sed -i 's/help\:\/kubuntu/\.\./' kubuntu/${x}/C/${y}
			sed -i 's/\.\.\/\.\.\/common/\.\.\/common/' kubuntu/${x}/C/${y}
			sed -i 's/\.\.\/\.\.\/images/\.\.\/images/' kubuntu/${x}/C/${y}
			if [ "$x" != "index" ]; then
				mv kubuntu/${x}/C/${y} kubuntu/${x}/${y}
			else
				mv kubuntu/index/C/index.html kubuntu/index.html
				rm -rf kubuntu/index
				sed -i 's/\.\.\///' kubuntu/index.html
			fi
		done
		rm -rf kubuntu/${x}/C
	fi
done

################################################################################
# After using this script, copy the kubuntu/ directory somewhere, and create a
# bzr repo out of it and push it into the lp:kubuntu-website branches.
#
# example:
# cp path/to/build/kubuntu ~/
# cd ~/
# mv kubuntu help-<release_name>
# cd help-<release_name>
# bzr init
# bzr ci -m 'foo bar is baz'
# bzr push lp:~<lp_username>/kubuntu-website/help-<release_name>
################################################################################
