#ifndef _IMAGEHOLDER_INCLUDED_
#define _IMAGEHOLDER_INCLUDED_


#include <kwinmodule.h>
#include "myrootpixmap.h"

struct WND_CONFIG;

class QImageHolder:public QObject
{
	Q_OBJECT
public:
	QImageHolder(QImage act,QImage inact);
	virtual ~QImageHolder();
	
	void Init();
	QPixmap *image(bool active) { Init(); return active?img_active:img_inactive; }
	void repaint(bool force);

	void setUserdefinedPictures(QImage act,QImage inact);

private:
	bool initialized;
	KMyRootPixmap *rootpixmap;
	QPixmap *img_active,*img_inactive;
	bool userdefinedActive,userdefinedInactive;

	QPixmap* ApplyEffect(QImage &src,WND_CONFIG* cfg,QColorGroup colorgroup);
	
public slots:
	void BackgroundUpdated(const QImage *);
	void handleDesktopChanged(int desk);
	void CheckSanity();
	
signals:
	void repaintNeeded();
};


#endif
