dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_rpi_crtcp_setup.m4,v 1.2 2002/10/09 21:00:16 brbarret Exp $
dnl

AC_DEFUN([LAM_RPI_CRTCP_SETUP],[
#
# Arguments: none
#
# Dependencies: None
#

#
# The CRTCP RPI needs to be built only if checkpoint/restart support was
# requested. So, check the LAM_BUILD_CRTCP environment variable 
#

if test "$LAM_BUILD_CRTCP" = "0"; then
  AC_MSG_ERROR([checkpoint/restart support not requested. Aborting.])
fi

# Tunable parameters

CRTCPSHORT=65536
AC_ARG_WITH(crtcpshort, 
  [  --with-crtcp-short=BYTES  use BYTES as the size of the longest CRTCP short 
                          message],
  [CRTCPSHORT=$withval])

AC_MSG_CHECKING([for CRTCP short message length])
AC_MSG_RESULT([$CRTCPSHORT bytes])

# Set the tunable params so that the RPI compiles with them

AC_SUBST(CRTCPSHORT)])dnl
