dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_ptmalloc_setup.m4,v 1.4.2.2 2003/09/05 21:02:11 jsquyres Exp $
dnl

AC_DEFUN([LAM_PTMALLOC_SETUP],[
#
# Arguments: none
#
# Dependencies: None
#
# Setup the ptmalloc
#
# Sets:
#

#
# The supplemental malloc package is only necessary if we're not on
# Solaris.  Also offer the option to turn it off manually.
#

AC_MSG_CHECKING(whether to enable ptmalloc)
if test "$enable_rpi_gm_ptmalloc" = "no" -o "$CAN_REGISTER_MEM" = 0; then
    WANT_PTMALLOC=no
    PTMALLOC_DIR=
    CAN_REGISTER_MEM=0
    AC_MSG_RESULT([disabled (will not register memory)])
else
    WANT_PTMALLOC=yes
    PTMALLOC_DIR=ptmalloc
    CAN_REGISTER_MEM=1
    AC_MSG_RESULT([enabled])
fi
AM_CONDITIONAL(WANT_PTMALLOC, test "$WANT_PTMALLOC" = "yes")
AC_SUBST(PTMALLOC_DIR)


if test "$WANT_PTMALLOC" = "yes"; then
    #
    # Call the top-level LAM threads setup stuff
    #

    LAM_CONFIG_THREADS
    CPPFLAGS="$CPPFLAGS $THREADCPPFLAGS"
    LDFLAGS="$LDFLAGS $THREADLDFLAGS"
    LIBS="$LIBS $THREADLIBS"


    #
    # See if we can use syscall interface
    #

    use_syscall=0
    AC_CHECK_HEADER([syscall.h], [have_syscall_h=yes], [have_syscall_h=no])
    if test "$have_syscall_h" = "yes"; then
	AC_CHECK_FUNCS([syscall])
    fi
    AC_DEFINE_UNQUOTED([LAM_USE_SYSCALL], $use_syscall,
	[Whether we can get munmap through syscall() or not])


    #
    # See if we have sbrk prototyped
    #

    AC_CHECK_DECL([sbrk], [have_decl_sbrk=1], [have_decl_sbrk=0])
    AC_DEFINE_UNQUOTED(LAM_HAVE_DECL_SBRK, $have_decl_sbrk,
	[Whether we have a declaration for sbrk() or not])
fi

])dnl
