/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: hook_functions.c,v 1.1.2.1 2003/06/20 03:39:02 jsquyres Exp $
 *
 *	Function:	- Hook functions for ptmalloc module used 
 *                        in gm RPI module
 */

#include <unistd.h>
#include <unistd.h>
#include <sys/mman.h>

#include <lam-ssi-rpi-gm-config.h>
#include <lam-ssi-rpi-gm.h>
#include <rpi_gm_interval.h>


/*
 * Not all systems have sbrk() declared, since it's technically not a
 * POSIX function.
 */
#if !LAM_HAVE_DECL_SBRK
void *sbrk();
#endif


/*
 * If we have the syscall() interface, use it to snarf munmap() calls.
 */
#if LAM_USE_SYSCALL
#include <syscall.h>

int 
munmap(void *start, size_t length)
{
  lam_ssi_rpi_gm_interval_free(start, length);
  return syscall(__NR_munmap, start, length);
}


int
__munmap(void *start, size_t length)
{
  return munmap(start, length);
}
#endif


/*
 * Hook function that is invoked by ptmalloc for sbrk.  When we sbrk()
 * a negative number, need to go unregister any memory that may be in
 * the region that we're letting go.
 */
void *
lam_ssi_rpi_gm_sbrk(int inc)
{
#if LAM_SSI_RPI_GM_CAN_REGISTER_MEM
  if (inc < 0) {
    long oldp = (long) sbrk(0);
    lam_ssi_rpi_gm_interval_free((void*) (oldp + inc), -inc);
  }

  return sbrk(inc);
#else
  return (-1);
#endif
}


/*
 * Same rationale as for sbrk(), above.
 */
int 
lam_ssi_rpi_gm_munmap(void *start, size_t length)
{
  lam_ssi_rpi_gm_interval_free(start, length);
  return munmap(start, length);
}
