/* Editor Settings: expandtabs and use 4 spaces for indentation
 * ex: set softtabstop=4 tabstop=8 expandtab shiftwidth=4: *
 */

/*
 * Copyright Likewise Software    2004-2008
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

/*
 * Copyright (C) Likewise Software. All rights reserved.
 *
 * Module Name:
 *
 *        samr_getaliasmembership.c
 *
 * Abstract:
 *
 *        Remote Procedure Call (RPC) Client Interface
 *
 *        SamrGetAliasMembership function
 *
 * Authors: Rafal Szczesniak (rafal@likewise.com)
 */

#include "includes.h"


NTSTATUS
SamrGetAliasMembership(
    IN  handle_t       hSamrBinding,
    IN  DOMAIN_HANDLE  hDomain,
    IN  PSID          *ppSids,
    IN  UINT32         NumSids,
    OUT UINT32       **ppRids,
    OUT UINT32        *pCount
    )
{
    NTSTATUS ntStatus = STATUS_SUCCESS;
    UINT32 iSid = 0;
    SidArray Sids = {0};
    Ids Rids = {0};
    UINT32 *pRids = NULL;

    BAIL_ON_INVALID_PTR(hSamrBinding, ntStatus);
    BAIL_ON_INVALID_PTR(hDomain, ntStatus);
    BAIL_ON_INVALID_PTR(ppSids, ntStatus);
    BAIL_ON_INVALID_PTR(ppRids, ntStatus);
    BAIL_ON_INVALID_PTR(pCount, ntStatus);

    Sids.num_sids = NumSids;
    ntStatus = SamrAllocateMemory((void**)&Sids.sids,
                                  sizeof(SidPtr) * NumSids,
                                  NULL);
    BAIL_ON_NT_STATUS(ntStatus);

    for (iSid = 0; iSid < NumSids; iSid++) {
        Sids.sids[iSid].sid = ppSids[iSid];
    }

    DCERPC_CALL(ntStatus, _SamrGetAliasMembership(hSamrBinding,
                                                  hDomain,
                                                  &Sids,
                                                  &Rids));
    BAIL_ON_NT_STATUS(ntStatus);

    ntStatus = SamrAllocateIds(&pRids, &Rids);
    BAIL_ON_NT_STATUS(ntStatus);

    *ppRids  = pRids;
    *pCount  = Rids.count;

cleanup:
    SamrCleanStubIds(&Rids);

    return ntStatus;

error:
    *ppRids  = NULL;
    *pCount  = 0;

    goto cleanup;
}


/*
local variables:
mode: c
c-basic-offset: 4
indent-tabs-mode: nil
tab-width: 4
end:
*/
