/*Copyright (c) Likewise Software.  All rights Reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

/*
 * Module Name:
 *
 *        winerror.h
 *
 * Abstract:
 *
 *        Winerror codes
 *
 * Authors: Wei Fu (wfu@likewise.com)
 *
 */

#ifndef __LWBASE_WINERROR_H__
#define __LWBASE_WINERROR_H__

#include <lw/types.h>


#if !defined(__COMPAT_WINERROR_H__)
#define __COMPAT_WINERROR_H__

#define ERROR_SUCCESS 0
#define ERROR_INVALID_FUNCTION 1
#define ERROR_FILE_NOT_FOUND 2
#define ERROR_PATH_NOT_FOUND 3
#define ERROR_TOO_MANY_OPEN_FILES 4
#define ERROR_ACCESS_DENIED 5
#define ERROR_INVALID_HANDLE 6
#define ERROR_ARENA_TRASHED 7
#define ERROR_NOT_ENOUGH_MEMORY 8
#define ERROR_INVALID_BLOCK 9
#define ERROR_BAD_ENVIRONMENT 10
#define ERROR_BAD_FORMAT 11
#define ERROR_INVALID_ACCESS 12
#define ERROR_INVALID_DATA 13
#define ERROR_OUTOFMEMORY 14
#define ERROR_INVALID_DRIVE 15
#define ERROR_CURRENT_DIRECTORY 16
#define ERROR_NOT_SAME_DEVICE 17
#define ERROR_NO_MORE_FILES 18
#define ERROR_WRITE_PROTECT 19
#define ERROR_BAD_UNIT 20
#define ERROR_NOT_READY 21
#define ERROR_BAD_COMMAND 22
#define ERROR_CRC 23
#define ERROR_BAD_LENGTH 24
#define ERROR_SEEK 25
#define ERROR_NOT_DOS_DISK 26
#define ERROR_SECTOR_NOT_FOUND 27
#define ERROR_OUT_OF_PAPER 28
#define ERROR_WRITE_FAULT 29
#define ERROR_READ_FAULT 30
#define ERROR_GEN_FAILURE 31
#define ERROR_SHARING_VIOLATION 32
#define ERROR_LOCK_VIOLATION 33
#define ERROR_WRONG_DISK 34
#define ERROR_SHARING_BUFFER_EXCEEDED 36
#define ERROR_HANDLE_EOF 38
#define ERROR_HANDLE_DISK_FULL 39
#define ERROR_NOT_SUPPORTED 50
#define ERROR_REM_NOT_LIST 51
#define ERROR_DUP_NAME 52
#define ERROR_BAD_NETPATH 53
#define ERROR_NETWORK_BUSY 54
#define ERROR_DEV_NOT_EXIST 55
#define ERROR_TOO_MANY_CMDS 56
#define ERROR_ADAP_HDW_ERR 57
#define ERROR_BAD_NET_RESP 58
#define ERROR_UNEXP_NET_ERR 59
#define ERROR_BAD_REM_ADAP 60
#define ERROR_PRINTQ_FULL 61
#define ERROR_NO_SPOOL_SPACE 62
#define ERROR_PRINT_CANCELLED 63
#define ERROR_NETNAME_DELETED 64
#define ERROR_NETWORK_ACCESS_DENIED 65
#define ERROR_BAD_DEV_TYPE 66
#define ERROR_BAD_NET_NAME 67
#define ERROR_TOO_MANY_NAMES 68
#define ERROR_TOO_MANY_SESS 69
#define ERROR_SHARING_PAUSED 70
#define ERROR_REQ_NOT_ACCEP 71
#define ERROR_REDIR_PAUSED 72
#define ERROR_FILE_EXISTS 80
#define ERROR_CANNOT_MAKE 82
#define ERROR_FAIL_I24 83
#define ERROR_OUT_OF_STRUCTURES 84
#define ERROR_ALREADY_ASSIGNED 85
#define ERROR_INVALID_PASSWORD 86
#define ERROR_INVALID_PARAMETER 87
#define ERROR_NET_WRITE_FAULT 88
#define ERROR_NO_PROC_SLOTS 89
#define ERROR_TOO_MANY_SEMAPHORES 100
#define ERROR_EXCL_SEM_ALREADY_OWNED 101
#define ERROR_SEM_IS_SET 102
#define ERROR_TOO_MANY_SEM_REQUESTS 103
#define ERROR_INVALID_AT_INTERRUPT_TIME 104
#define ERROR_SEM_OWNER_DIED 105
#define ERROR_SEM_USER_LIMIT 106
#define ERROR_DISK_CHANGE 107
#define ERROR_DRIVE_LOCKED 108
#define ERROR_BROKEN_PIPE 109
#define ERROR_OPEN_FAILED 110
#define ERROR_BUFFER_OVERFLOW 111
#define ERROR_DISK_FULL 112
#define ERROR_NO_MORE_SEARCH_HANDLES 113
#define ERROR_INVALID_TARGET_HANDLE 114
#define ERROR_INVALID_CATEGORY 117
#define ERROR_INVALID_VERIFY_SWITCH 118
#define ERROR_BAD_DRIVER_LEVEL 119
#define ERROR_CALL_NOT_IMPLEMENTED 120
#define ERROR_SEM_TIMEOUT 121
#define ERROR_INSUFFICIENT_BUFFER 122
#define ERROR_INVALID_NAME 123
#define ERROR_INVALID_LEVEL 124
#define ERROR_NO_VOLUME_LABEL 125
#define ERROR_MOD_NOT_FOUND 126
#define ERROR_PROC_NOT_FOUND 127
#define ERROR_WAIT_NO_CHILDREN 128
#define ERROR_CHILD_NOT_COMPLETE 129
#define ERROR_DIRECT_ACCESS_HANDLE 130
#define ERROR_NEGATIVE_SEEK 131
#define ERROR_SEEK_ON_DEVICE 132
#define ERROR_IS_JOIN_TARGET 133
#define ERROR_IS_JOINED 134
#define ERROR_IS_SUBSTED 135
#define ERROR_NOT_JOINED 136
#define ERROR_NOT_SUBSTED 137
#define ERROR_JOIN_TO_JOIN 138
#define ERROR_SUBST_TO_SUBST 139
#define ERROR_JOIN_TO_SUBST 140
#define ERROR_SUBST_TO_JOIN 141
#define ERROR_BUSY_DRIVE 142
#define ERROR_SAME_DRIVE 143
#define ERROR_DIR_NOT_ROOT 144
#define ERROR_DIR_NOT_EMPTY 145
#define ERROR_IS_SUBST_PATH 146
#define ERROR_IS_JOIN_PATH 147
#define ERROR_PATH_BUSY 148
#define ERROR_IS_SUBST_TARGET 149
#define ERROR_SYSTEM_TRACE 150
#define ERROR_INVALID_EVENT_COUNT 151
#define ERROR_TOO_MANY_MUXWAITERS 152
#define ERROR_INVALID_LIST_FORMAT 153
#define ERROR_LABEL_TOO_LONG 154
#define ERROR_TOO_MANY_TCBS 155
#define ERROR_SIGNAL_REFUSED 156
#define ERROR_DISCARDED 157
#define ERROR_NOT_LOCKED 158
#define ERROR_BAD_THREADID_ADDR 159
#define ERROR_BAD_ARGUMENTS 160
#define ERROR_BAD_PATHNAME 161
#define ERROR_SIGNAL_PENDING 162
#define ERROR_MAX_THRDS_REACHED 164
#define ERROR_LOCK_FAILED 167
#define ERROR_BUSY 170
#define ERROR_CANCEL_VIOLATION 173
#define ERROR_ATOMIC_LOCKS_NOT_SUPPORTED 174
#define ERROR_INVALID_SEGMENT_NUMBER 180
#define ERROR_INVALID_ORDINAL 182
#define ERROR_ALREADY_EXISTS 183
#define ERROR_INVALID_FLAG_NUMBER 186
#define ERROR_SEM_NOT_FOUND 187
#define ERROR_INVALID_STARTING_CODESEG 188
#define ERROR_INVALID_STACKSEG 189
#define ERROR_INVALID_MODULETYPE 190
#define ERROR_INVALID_EXE_SIGNATURE 191
#define ERROR_EXE_MARKED_INVALID 192
#define ERROR_BAD_EXE_FORMAT 193
#define ERROR_ITERATED_DATA_EXCEEDS_64k 194
#define ERROR_INVALID_MINALLOCSIZE 195
#define ERROR_DYNLINK_FROM_INVALID_RING 196
#define ERROR_IOPL_NOT_ENABLED 197
#define ERROR_INVALID_SEGDPL 198
#define ERROR_AUTODATASEG_EXCEEDS_64k 199
#define ERROR_RING2SEG_MUST_BE_MOVABLE 200
#define ERROR_RELOC_CHAIN_XEEDS_SEGLIM 201
#define ERROR_INFLOOP_IN_RELOC_CHAIN 202
#define ERROR_ENVVAR_NOT_FOUND 203
#define ERROR_NO_SIGNAL_SENT 205
#define ERROR_FILENAME_EXCED_RANGE 206
#define ERROR_RING2_STACK_IN_USE 207
#define ERROR_META_EXPANSION_TOO_LONG 208
#define ERROR_INVALID_SIGNAL_NUMBER 209
#define ERROR_THREAD_1_INACTIVE 210
#define ERROR_LOCKED 212
#define ERROR_TOO_MANY_MODULES 214
#define ERROR_NESTING_NOT_ALLOWED 215
#define ERROR_EXE_MACHINE_TYPE_MISMATCH 216
#define ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY 217
#define ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY 218
#define ERROR_FILE_CHECKED_OUT 220
#define ERROR_CHECKOUT_REQUIRED 221
#define ERROR_BAD_FILE_TYPE 222
#define ERROR_FILE_TOO_LARGE 223
#define ERROR_FORMS_AUTH_REQUIRED 224
#define ERROR_VIRUS_INFECTED 225
#define ERROR_VIRUS_DELETED 226
#define ERROR_PIPE_LOCAL 229
#define ERROR_BAD_PIPE 230
#define ERROR_PIPE_BUSY 231
#define ERROR_NO_DATA 232
#define ERROR_PIPE_NOT_CONNECTED 233
#define ERROR_MORE_DATA 234
#define ERROR_VC_DISCONNECTED 240
#define ERROR_INVALID_EA_NAME 254
#define ERROR_EA_LIST_INCONSISTENT 255
#define WAIT_TIMEOUT 258
#define ERROR_NO_MORE_ITEMS 259
#define ERROR_CANNOT_COPY 266
#define ERROR_DIRECTORY 267
#define ERROR_EAS_DIDNT_FIT 275
#define ERROR_EA_FILE_CORRUPT 276
#define ERROR_EA_TABLE_FULL 277
#define ERROR_INVALID_EA_HANDLE 278
#define ERROR_EAS_NOT_SUPPORTED 282
#define ERROR_NOT_OWNER 288
#define ERROR_TOO_MANY_POSTS 298
#define ERROR_PARTIAL_COPY 299
#define ERROR_OPLOCK_NOT_GRANTED 300
#define ERROR_INVALID_OPLOCK_PROTOCOL 301
#define ERROR_DISK_TOO_FRAGMENTED 302
#define ERROR_DELETE_PENDING 303
#define ERROR_MR_MID_NOT_FOUND 317
#define ERROR_SCOPE_NOT_FOUND 318
#define ERROR_FAIL_NOACTION_REBOOT 350
#define ERROR_FAIL_SHUTDOWN 351
#define ERROR_FAIL_RESTART 352
#define ERROR_MAX_SESSIONS_REACHED 353
#define ERROR_THREAD_MODE_ALREADY_BACKGROUND 400
#define ERROR_THREAD_MODE_NOT_BACKGROUND 401
#define ERROR_PROCESS_MODE_ALREADY_BACKGROUND 402
#define ERROR_PROCESS_MODE_NOT_BACKGROUND 403
#define ERROR_INVALID_ADDRESS 487
#define ERROR_USER_PROFILE_LOAD 500
#define ERROR_ARITHMETIC_OVERFLOW 534
#define ERROR_PIPE_CONNECTED 535
#define ERROR_PIPE_LISTENING 536
#define ERROR_VERIFIER_STOP 537
#define ERROR_ABIOS_ERROR 538
#define ERROR_WX86_WARNING 539
#define ERROR_WX86_ERROR 540
#define ERROR_TIMER_NOT_CANCELED 541
#define ERROR_UNWIND 542
#define ERROR_BAD_STACK 543
#define ERROR_INVALID_UNWIND_TARGET 544
#define ERROR_INVALID_PORT_ATTRIBUTES 545
#define ERROR_PORT_MESSAGE_TOO_LONG 546
#define ERROR_INVALID_QUOTA_LOWER 547
#define ERROR_DEVICE_ALREADY_ATTACHED 548
#define ERROR_INSTRUCTION_MISALIGNMENT 549
#define ERROR_PROFILING_NOT_STARTED 550
#define ERROR_PROFILING_NOT_STOPPED 551
#define ERROR_COULD_NOT_INTERPRET 552
#define ERROR_PROFILING_AT_LIMIT 553
#define ERROR_CANT_WAIT 554
#define ERROR_CANT_TERMINATE_SELF 555
#define ERROR_UNEXPECTED_MM_CREATE_ERR 556
#define ERROR_UNEXPECTED_MM_MAP_ERROR 557
#define ERROR_UNEXPECTED_MM_EXTEND_ERR 558
#define ERROR_BAD_FUNCTION_TABLE 559
#define ERROR_NO_GUID_TRANSLATION 560
#define ERROR_INVALID_LDT_SIZE 561
#define ERROR_INVALID_LDT_OFFSET 563
#define ERROR_INVALID_LDT_DESCRIPTOR 564
#define ERROR_TOO_MANY_THREADS 565
#define ERROR_THREAD_NOT_IN_PROCESS 566
#define ERROR_PAGEFILE_QUOTA_EXCEEDED 567
#define ERROR_LOGON_SERVER_CONFLICT 568
#define ERROR_SYNCHRONIZATION_REQUIRED 569
#define ERROR_NET_OPEN_FAILED 570
#define ERROR_IO_PRIVILEGE_FAILED 571
#define ERROR_CONTROL_C_EXIT 572
#define ERROR_MISSING_SYSTEMFILE 573
#define ERROR_UNHANDLED_EXCEPTION 574
#define ERROR_APP_INIT_FAILURE 575
#define ERROR_PAGEFILE_CREATE_FAILED 576
#define ERROR_INVALID_IMAGE_HASH 577
#define ERROR_NO_PAGEFILE 578
#define ERROR_ILLEGAL_FLOAT_CONTEXT 579
#define ERROR_NO_EVENT_PAIR 580
#define ERROR_DOMAIN_CTRLR_CONFIG_ERROR 581
#define ERROR_ILLEGAL_CHARACTER 582
#define ERROR_UNDEFINED_CHARACTER 583
#define ERROR_FLOPPY_VOLUME 584
#define ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT 585
#define ERROR_BACKUP_CONTROLLER 586
#define ERROR_MUTANT_LIMIT_EXCEEDED 587
#define ERROR_FS_DRIVER_REQUIRED 588
#define ERROR_CANNOT_LOAD_REGISTRY_FILE 589
#define ERROR_DEBUG_ATTACH_FAILED 590
#define ERROR_SYSTEM_PROCESS_TERMINATED 591
#define ERROR_DATA_NOT_ACCEPTED 592
#define ERROR_VDM_HARD_ERROR 593
#define ERROR_DRIVER_CANCEL_TIMEOUT 594
#define ERROR_REPLY_MESSAGE_MISMATCH 595
#define ERROR_LOST_WRITEBEHIND_DATA 596
#define ERROR_CLIENT_SERVER_PARAMETERS_INVALID 597
#define ERROR_NOT_TINY_STREAM 598
#define ERROR_STACK_OVERFLOW_READ 599
#define ERROR_CONVERT_TO_LARGE 600
#define ERROR_FOUND_OUT_OF_SCOPE 601
#define ERROR_ALLOCATE_BUCKET 602
#define ERROR_MARSHALL_OVERFLOW 603
#define ERROR_INVALID_VARIANT 604
#define ERROR_BAD_COMPRESSION_BUFFER 605
#define ERROR_AUDIT_FAILED 606
#define ERROR_TIMER_RESOLUTION_NOT_SET 607
#define ERROR_INSUFFICIENT_LOGON_INFO 608
#define ERROR_BAD_DLL_ENTRYPOINT 609
#define ERROR_BAD_SERVICE_ENTRYPOINT 610
#define ERROR_IP_ADDRESS_CONFLICT1 611
#define ERROR_IP_ADDRESS_CONFLICT2 612
#define ERROR_REGISTRY_QUOTA_LIMIT 613
#define ERROR_NO_CALLBACK_ACTIVE 614
#define ERROR_PWD_TOO_SHORT 615
#define ERROR_PWD_TOO_RECENT 616
#define ERROR_PWD_HISTORY_CONFLICT 617
#define ERROR_UNSUPPORTED_COMPRESSION 618
#define ERROR_INVALID_HW_PROFILE 619
#define ERROR_INVALID_PLUGPLAY_DEVICE_PATH 620
#define ERROR_QUOTA_LIST_INCONSISTENT 621
#define ERROR_EVALUATION_EXPIRATION 622
#define ERROR_ILLEGAL_DLL_RELOCATION 623
#define ERROR_DLL_INIT_FAILED_LOGOFF 624
#define ERROR_VALIDATE_CONTINUE 625
#define ERROR_NO_MORE_MATCHES 626
#define ERROR_RANGE_LIST_CONFLICT 627
#define ERROR_SERVER_SID_MISMATCH 628
#define ERROR_CANT_ENABLE_DENY_ONLY 629
#define ERROR_FLOAT_MULTIPLE_FAULTS 630
#define ERROR_FLOAT_MULTIPLE_TRAPS 631
#define ERROR_NOINTERFACE 632
#define ERROR_DRIVER_FAILED_SLEEP 633
#define ERROR_CORRUPT_SYSTEM_FILE 634
#define ERROR_COMMITMENT_MINIMUM 635
#define ERROR_PNP_RESTART_ENUMERATION 636
#define ERROR_SYSTEM_IMAGE_BAD_SIGNATURE 637
#define ERROR_PNP_REBOOT_REQUIRED 638
#define ERROR_INSUFFICIENT_POWER 639
#define ERROR_MULTIPLE_FAULT_VIOLATION 640
#define ERROR_SYSTEM_SHUTDOWN 641
#define ERROR_PORT_NOT_SET 642
#define ERROR_DS_VERSION_CHECK_FAILURE 643
#define ERROR_RANGE_NOT_FOUND 644
#define ERROR_NOT_SAFE_MODE_DRIVER 646
#define ERROR_FAILED_DRIVER_ENTRY 647
#define ERROR_DEVICE_ENUMERATION_ERROR 648
#define ERROR_MOUNT_POINT_NOT_RESOLVED 649
#define ERROR_INVALID_DEVICE_OBJECT_PARAMETER 650
#define ERROR_MCA_OCCURED 651
#define ERROR_DRIVER_DATABASE_ERROR 652
#define ERROR_SYSTEM_HIVE_TOO_LARGE 653
#define ERROR_DRIVER_FAILED_PRIOR_UNLOAD 654
#define ERROR_VOLSNAP_PREPARE_HIBERNATE 655
#define ERROR_HIBERNATION_FAILURE 656
#define ERROR_FILE_SYSTEM_LIMITATION 665
#define ERROR_ASSERTION_FAILURE 668
#define ERROR_ACPI_ERROR 669
#define ERROR_WOW_ASSERTION 670
#define ERROR_PNP_BAD_MPS_TABLE 671
#define ERROR_PNP_TRANSLATION_FAILED 672
#define ERROR_PNP_IRQ_TRANSLATION_FAILED 673
#define ERROR_PNP_INVALID_ID 674
#define ERROR_WAKE_SYSTEM_DEBUGGER 675
#define ERROR_HANDLES_CLOSED 676
#define ERROR_EXTRANEOUS_INFORMATION 677
#define ERROR_RXACT_COMMIT_NECESSARY 678
#define ERROR_MEDIA_CHECK 679
#define ERROR_GUID_SUBSTITUTION_MADE 680
#define ERROR_STOPPED_ON_SYMLINK 681
#define ERROR_LONGJUMP 682
#define ERROR_PLUGPLAY_QUERY_VETOED 683
#define ERROR_UNWIND_CONSOLIDATE 684
#define ERROR_REGISTRY_HIVE_RECOVERED 685
#define ERROR_DLL_MIGHT_BE_INSECURE 686
#define ERROR_DLL_MIGHT_BE_INCOMPATIBLE 687
#define ERROR_DBG_EXCEPTION_NOT_HANDLED 688
#define ERROR_DBG_REPLY_LATER 689
#define ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE 690
#define ERROR_DBG_TERMINATE_THREAD 691
#define ERROR_DBG_TERMINATE_PROCESS 692
#define ERROR_DBG_CONTROL_C 693
#define ERROR_DBG_PRINTEXCEPTION_C 694
#define ERROR_DBG_RIPEXCEPTION 695
#define ERROR_DBG_CONTROL_BREAK 696
#define ERROR_DBG_COMMAND_EXCEPTION 697
#define ERROR_OBJECT_NAME_EXISTS 698
#define ERROR_THREAD_WAS_SUSPENDED 699
#define ERROR_IMAGE_NOT_AT_BASE 700
#define ERROR_RXACT_STATE_CREATED 701
#define ERROR_SEGMENT_NOTIFICATION 702
#define ERROR_BAD_CURRENT_DIRECTORY 703
#define ERROR_FT_READ_RECOVERY_FROM_BACKUP 704
#define ERROR_FT_WRITE_RECOVERY 705
#define ERROR_IMAGE_MACHINE_TYPE_MISMATCH 706
#define ERROR_RECEIVE_PARTIAL 707
#define ERROR_RECEIVE_EXPEDITED 708
#define ERROR_RECEIVE_PARTIAL_EXPEDITED 709
#define ERROR_EVENT_DONE 710
#define ERROR_EVENT_PENDING 711
#define ERROR_CHECKING_FILE_SYSTEM 712
#define ERROR_FATAL_APP_EXIT 713
#define ERROR_PREDEFINED_HANDLE 714
#define ERROR_WAS_UNLOCKED 715
#define ERROR_SERVICE_NOTIFICATION 716
#define ERROR_WAS_LOCKED 717
#define ERROR_LOG_HARD_ERROR 718
#define ERROR_ALREADY_WIN32 719
#define ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE 720
#define ERROR_NO_YIELD_PERFORMED 721
#define ERROR_TIMER_RESUME_IGNORED 722
#define ERROR_ARBITRATION_UNHANDLED 723
#define ERROR_CARDBUS_NOT_SUPPORTED 724
#define ERROR_MP_PROCESSOR_MISMATCH 725
#define ERROR_HIBERNATED 726
#define ERROR_RESUME_HIBERNATION 727
#define ERROR_FIRMWARE_UPDATED 728
#define ERROR_DRIVERS_LEAKING_LOCKED_PAGES 729
#define ERROR_WAKE_SYSTEM 730
#define ERROR_WAIT_1 731
#define ERROR_WAIT_2 732
#define ERROR_WAIT_3 733
#define ERROR_WAIT_63 734
#define ERROR_ABANDONED_WAIT_0 735
#define ERROR_ABANDONED_WAIT_63 736
#define ERROR_USER_APC 737
#define ERROR_KERNEL_APC 738
#define ERROR_ALERTED 739
#define ERROR_ELEVATION_REQUIRED 740
#define ERROR_REPARSE 741
#define ERROR_OPLOCK_BREAK_IN_PROGRESS 742
#define ERROR_VOLUME_MOUNTED 743
#define ERROR_RXACT_COMMITTED 744
#define ERROR_NOTIFY_CLEANUP 745
#define ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED 746
#define ERROR_PAGE_FAULT_TRANSITION 747
#define ERROR_PAGE_FAULT_DEMAND_ZERO 748
#define ERROR_PAGE_FAULT_COPY_ON_WRITE 749
#define ERROR_PAGE_FAULT_GUARD_PAGE 750
#define ERROR_PAGE_FAULT_PAGING_FILE 751
#define ERROR_CACHE_PAGE_LOCKED 752
#define ERROR_CRASH_DUMP 753
#define ERROR_BUFFER_ALL_ZEROS 754
#define ERROR_REPARSE_OBJECT 755
#define ERROR_RESOURCE_REQUIREMENTS_CHANGED 756
#define ERROR_TRANSLATION_COMPLETE 757
#define ERROR_NOTHING_TO_TERMINATE 758
#define ERROR_PROCESS_NOT_IN_JOB 759
#define ERROR_PROCESS_IN_JOB 760
#define ERROR_VOLSNAP_HIBERNATE_READY 761
#define ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY 762
#define ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED 763
#define ERROR_INTERRUPT_STILL_CONNECTED 764
#define ERROR_WAIT_FOR_OPLOCK 765
#define ERROR_DBG_EXCEPTION_HANDLED 766
#define ERROR_DBG_CONTINUE 767
#define ERROR_CALLBACK_POP_STACK 768
#define ERROR_COMPRESSION_DISABLED 769
#define ERROR_CANTFETCHBACKWARDS 770
#define ERROR_CANTSCROLLBACKWARDS 771
#define ERROR_ROWSNOTRELEASED 772
#define ERROR_BAD_ACCESSOR_FLAGS 773
#define ERROR_ERRORS_ENCOUNTERED 774
#define ERROR_NOT_CAPABLE 775
#define ERROR_REQUEST_OUT_OF_SEQUENCE 776
#define ERROR_VERSION_PARSE_ERROR 777
#define ERROR_BADSTARTPOSITION 778
#define ERROR_MEMORY_HARDWARE 779
#define ERROR_DISK_REPAIR_DISABLED 780
#define ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE 781
#define ERROR_SYSTEM_POWERSTATE_TRANSITION 782
#define ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION 783
#define ERROR_MCA_EXCEPTION 784
#define ERROR_ACCESS_AUDIT_BY_POLICY 785
#define ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY 786
#define ERROR_ABANDON_HIBERFILE 787
#define ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED 788
#define ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR 789
#define ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR 790
#define ERROR_EA_ACCESS_DENIED 994
#define ERROR_OPERATION_ABORTED 995
#define ERROR_IO_INCOMPLETE 996
#define ERROR_IO_PENDING 997
#define ERROR_NOACCESS 998
#define ERROR_SWAPERROR 999
#define ERROR_STACK_OVERFLOW 1001
#define ERROR_INVALID_MESSAGE 1002
#define ERROR_CAN_NOT_COMPLETE 1003
#define ERROR_INVALID_FLAGS 1004
#define ERROR_UNRECOGNIZED_VOLUME 1005
#define ERROR_FILE_INVALID 1006
#define ERROR_FULLSCREEN_MODE 1007
#define ERROR_NO_TOKEN 1008
#define ERROR_BADDB 1009
#define ERROR_BADKEY 1010
#define ERROR_CANTOPEN 1011
#define ERROR_CANTREAD 1012
#define ERROR_CANTWRITE 1013
#define ERROR_REGISTRY_RECOVERED 1014
#define ERROR_REGISTRY_CORRUPT 1015
#define ERROR_REGISTRY_IO_FAILED 1016
#define ERROR_NOT_REGISTRY_FILE 1017
#define ERROR_KEY_DELETED 1018
#define ERROR_NO_LOG_SPACE 1019
#define ERROR_KEY_HAS_CHILDREN 1020
#define ERROR_CHILD_MUST_BE_VOLATILE 1021
#define ERROR_NOTIFY_ENUM_DIR 1022
#define ERROR_DEPENDENT_SERVICES_RUNNING 1051
#define ERROR_INVALID_SERVICE_CONTROL 1052
#define ERROR_SERVICE_REQUEST_TIMEOUT 1053
#define ERROR_SERVICE_NO_THREAD 1054
#define ERROR_SERVICE_DATABASE_LOCKED 1055
#define ERROR_SERVICE_ALREADY_RUNNING 1056
#define ERROR_INVALID_SERVICE_ACCOUNT 1057
#define ERROR_SERVICE_DISABLED 1058
#define ERROR_CIRCULAR_DEPENDENCY 1059
#define ERROR_SERVICE_DOES_NOT_EXIST 1060
#define ERROR_SERVICE_CANNOT_ACCEPT_CTRL 1061
#define ERROR_SERVICE_NOT_ACTIVE 1062
#define ERROR_FAILED_SERVICE_CONTROLLER_CONNECT 1063
#define ERROR_EXCEPTION_IN_SERVICE 1064
#define ERROR_DATABASE_DOES_NOT_EXIST 1065
#define ERROR_SERVICE_SPECIFIC_ERROR 1066
#define ERROR_PROCESS_ABORTED 1067
#define ERROR_SERVICE_DEPENDENCY_FAIL 1068
#define ERROR_SERVICE_LOGON_FAILED 1069
#define ERROR_SERVICE_START_HANG 1070
#define ERROR_INVALID_SERVICE_LOCK 1071
#define ERROR_SERVICE_MARKED_FOR_DELETE 1072
#define ERROR_SERVICE_EXISTS 1073
#define ERROR_ALREADY_RUNNING_LKG 1074
#define ERROR_SERVICE_DEPENDENCY_DELETED 1075
#define ERROR_BOOT_ALREADY_ACCEPTED 1076
#define ERROR_SERVICE_NEVER_STARTED 1077
#define ERROR_DUPLICATE_SERVICE_NAME 1078
#define ERROR_DIFFERENT_SERVICE_ACCOUNT 1079
#define ERROR_CANNOT_DETECT_DRIVER_FAILURE 1080
#define ERROR_CANNOT_DETECT_PROCESS_ABORT 1081
#define ERROR_NO_RECOVERY_PROGRAM 1082
#define ERROR_SERVICE_NOT_IN_EXE 1083
#define ERROR_NOT_SAFEBOOT_SERVICE 1084
#define ERROR_END_OF_MEDIA 1100
#define ERROR_FILEMARK_DETECTED 1101
#define ERROR_BEGINNING_OF_MEDIA 1102
#define ERROR_SETMARK_DETECTED 1103
#define ERROR_NO_DATA_DETECTED 1104
#define ERROR_PARTITION_FAILURE 1105
#define ERROR_INVALID_BLOCK_LENGTH 1106
#define ERROR_DEVICE_NOT_PARTITIONED 1107
#define ERROR_UNABLE_TO_LOCK_MEDIA 1108
#define ERROR_UNABLE_TO_UNLOAD_MEDIA 1109
#define ERROR_MEDIA_CHANGED 1110
#define ERROR_BUS_RESET 1111
#define ERROR_NO_MEDIA_IN_DRIVE 1112
#define ERROR_NO_UNICODE_TRANSLATION 1113
#define ERROR_DLL_INIT_FAILED 1114
#define ERROR_SHUTDOWN_IN_PROGRESS 1115
#define ERROR_NO_SHUTDOWN_IN_PROGRESS 1116
#define ERROR_IO_DEVICE 1117
#define ERROR_SERIAL_NO_DEVICE 1118
#define ERROR_IRQ_BUSY 1119
#define ERROR_MORE_WRITES 1120
#define ERROR_COUNTER_TIMEOUT 1121
#define ERROR_FLOPPY_ID_MARK_NOT_FOUND 1122
#define ERROR_FLOPPY_WRONG_CYLINDER 1123
#define ERROR_FLOPPY_UNKNOWN_ERROR 1124
#define ERROR_FLOPPY_BAD_REGISTERS 1125
#define ERROR_DISK_RECALIBRATE_FAILED 1126
#define ERROR_DISK_OPERATION_FAILED 1127
#define ERROR_DISK_RESET_FAILED 1128
#define ERROR_EOM_OVERFLOW 1129
#define ERROR_NOT_ENOUGH_SERVER_MEMORY 1130
#define ERROR_POSSIBLE_DEADLOCK 1131
#define ERROR_MAPPED_ALIGNMENT 1132
#define ERROR_SET_POWER_STATE_VETOED 1140
#define ERROR_SET_POWER_STATE_FAILED 1141
#define ERROR_TOO_MANY_LINKS 1142
#define ERROR_OLD_WIN_VERSION 1150
#define ERROR_APP_WRONG_OS 1151
#define ERROR_SINGLE_INSTANCE_APP 1152
#define ERROR_RMODE_APP 1153
#define ERROR_INVALID_DLL 1154
#define ERROR_NO_ASSOCIATION 1155
#define ERROR_DDE_FAIL 1156
#define ERROR_DLL_NOT_FOUND 1157
#define ERROR_NO_MORE_USER_HANDLES 1158
#define ERROR_MESSAGE_SYNC_ONLY 1159
#define ERROR_SOURCE_ELEMENT_EMPTY 1160
#define ERROR_DESTINATION_ELEMENT_FULL 1161
#define ERROR_ILLEGAL_ELEMENT_ADDRESS 1162
#define ERROR_MAGAZINE_NOT_PRESENT 1163
#define ERROR_DEVICE_REINITIALIZATION_NEEDED 1164
#define ERROR_DEVICE_REQUIRES_CLEANING 1165
#define ERROR_DEVICE_DOOR_OPEN 1166
#define ERROR_DEVICE_NOT_CONNECTED 1167
#define ERROR_NOT_FOUND 1168
#define ERROR_NO_MATCH 1169
#define ERROR_SET_NOT_FOUND 1170
#define ERROR_POINT_NOT_FOUND 1171
#define ERROR_NO_TRACKING_SERVICE 1172
#define ERROR_NO_VOLUME_ID 1173
#define ERROR_UNABLE_TO_REMOVE_REPLACED 1175
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT 1176
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 1177
#define ERROR_JOURNAL_DELETE_IN_PROGRESS 1178
#define ERROR_JOURNAL_NOT_ACTIVE 1179
#define ERROR_POTENTIAL_FILE_FOUND 1180
#define ERROR_JOURNAL_ENTRY_DELETED 1181
#define ERROR_SHUTDOWN_IS_SCHEDULED 1190
#define ERROR_SHUTDOWN_USERS_LOGGED_ON 1191
#define ERROR_BAD_DEVICE 1200
#define ERROR_CONNECTION_UNAVAIL 1201
#define ERROR_DEVICE_ALREADY_REMEMBERED 1202
#define ERROR_NO_NET_OR_BAD_PATH 1203
#define ERROR_BAD_PROVIDER 1204
#define ERROR_CANNOT_OPEN_PROFILE 1205
#define ERROR_BAD_PROFILE 1206
#define ERROR_NOT_CONTAINER 1207
#define ERROR_EXTENDED_ERROR 1208
#define ERROR_INVALID_GROUPNAME 1209
#define ERROR_INVALID_COMPUTERNAME 1210
#define ERROR_INVALID_EVENTNAME 1211
#define ERROR_INVALID_DOMAINNAME 1212
#define ERROR_INVALID_SERVICENAME 1213
#define ERROR_INVALID_NETNAME 1214
#define ERROR_INVALID_SHARENAME 1215
#define ERROR_INVALID_PASSWORDNAME 1216
#define ERROR_INVALID_MESSAGENAME 1217
#define ERROR_INVALID_MESSAGEDEST 1218
#define ERROR_SESSION_CREDENTIAL_CONFLICT 1219
#define ERROR_REMOTE_SESSION_LIMIT_EXCEEDED 1220
#define ERROR_DUP_DOMAINNAME 1221
#define ERROR_NO_NETWORK 1222
#define ERROR_CANCELLED 1223
#define ERROR_USER_MAPPED_FILE 1224
#define ERROR_CONNECTION_REFUSED 1225
#define ERROR_GRACEFUL_DISCONNECT 1226
#define ERROR_ADDRESS_ALREADY_ASSOCIATED 1227
#define ERROR_ADDRESS_NOT_ASSOCIATED 1228
#define ERROR_CONNECTION_INVALID 1229
#define ERROR_CONNECTION_ACTIVE 1230
#define ERROR_NETWORK_UNREACHABLE 1231
#define ERROR_HOST_UNREACHABLE 1232
#define ERROR_PROTOCOL_UNREACHABLE 1233
#define ERROR_PORT_UNREACHABLE 1234
#define ERROR_REQUEST_ABORTED 1235
#define ERROR_CONNECTION_ABORTED 1236
#define ERROR_RETRY 1237
#define ERROR_CONNECTION_COUNT_LIMIT 1238
#define ERROR_LOGIN_TIME_RESTRICTION 1239
#define ERROR_LOGIN_WKSTA_RESTRICTION 1240
#define ERROR_INCORRECT_ADDRESS 1241
#define ERROR_ALREADY_REGISTERED 1242
#define ERROR_SERVICE_NOT_FOUND 1243
#define ERROR_NOT_AUTHENTICATED 1244
#define ERROR_NOT_LOGGED_ON 1245
#define ERROR_CONTINUE 1246
#define ERROR_ALREADY_INITIALIZED 1247
#define ERROR_NO_MORE_DEVICES 1248
#define ERROR_NO_SUCH_SITE 1249
#define ERROR_DOMAIN_CONTROLLER_EXISTS 1250
#define ERROR_ONLY_IF_CONNECTED 1251
#define ERROR_OVERRIDE_NOCHANGES 1252
#define ERROR_BAD_USER_PROFILE 1253
#define ERROR_NOT_SUPPORTED_ON_SBS 1254
#define ERROR_SERVER_SHUTDOWN_IN_PROGRESS 1255
#define ERROR_HOST_DOWN 1256
#define ERROR_NON_ACCOUNT_SID 1257
#define ERROR_NON_DOMAIN_SID 1258
#define ERROR_APPHELP_BLOCK 1259
#define ERROR_ACCESS_DISABLED_BY_POLICY 1260
#define ERROR_REG_NAT_CONSUMPTION 1261
#define ERROR_CSCSHARE_OFFLINE 1262
#define ERROR_PKINIT_FAILURE 1263
#define ERROR_SMARTCARD_SUBSYSTEM_FAILURE 1264
#define ERROR_DOWNGRADE_DETECTED 1265
#define ERROR_MACHINE_LOCKED 1271
#define ERROR_CALLBACK_SUPPLIED_INVALID_DATA 1273
#define ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED 1274
#define ERROR_DRIVER_BLOCKED 1275
#define ERROR_INVALID_IMPORT_OF_NON_DLL 1276
#define ERROR_ACCESS_DISABLED_WEBBLADE 1277
#define ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER 1278
#define ERROR_RECOVERY_FAILURE 1279
#define ERROR_ALREADY_FIBER 1280
#define ERROR_ALREADY_THREAD 1281
#define ERROR_STACK_BUFFER_OVERRUN 1282
#define ERROR_PARAMETER_QUOTA_EXCEEDED 1283
#define ERROR_DEBUGGER_INACTIVE 1284
#define ERROR_DELAY_LOAD_FAILED 1285
#define ERROR_VDM_DISALLOWED 1286
#define ERROR_UNIDENTIFIED_ERROR 1287
#define ERROR_INVALID_CRUNTIME_PARAMETER 1288
#define ERROR_BEYOND_VDL 1289
#define ERROR_INCOMPATIBLE_SERVICE_SID_TYPE 1290
#define ERROR_DRIVER_PROCESS_TERMINATED 1291
#define ERROR_IMPLEMENTATION_LIMIT 1292
#define ERROR_PROCESS_IS_PROTECTED 1293
#define ERROR_SERVICE_NOTIFY_CLIENT_LAGGING 1294
#define ERROR_DISK_QUOTA_EXCEEDED 1295
#define ERROR_CONTENT_BLOCKED 1296
#define ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE 1297
#define ERROR_INVALID_LABEL 1299
#define ERROR_NOT_ALL_ASSIGNED 1300
#define ERROR_SOME_NOT_MAPPED 1301
#define ERROR_NO_QUOTAS_FOR_ACCOUNT 1302
#define ERROR_LOCAL_USER_SESSION_KEY 1303
#define ERROR_NULL_LM_PASSWORD 1304
#define ERROR_UNKNOWN_REVISION 1305
#define ERROR_REVISION_MISMATCH 1306
#define ERROR_INVALID_OWNER 1307
#define ERROR_INVALID_PRIMARY_GROUP 1308
#define ERROR_NO_IMPERSONATION_TOKEN 1309
#define ERROR_CANT_DISABLE_MANDATORY 1310
#define ERROR_NO_LOGON_SERVERS 1311
#define ERROR_NO_SUCH_LOGON_SESSION 1312
#define ERROR_NO_SUCH_PRIVILEGE 1313
#define ERROR_PRIVILEGE_NOT_HELD 1314
#define ERROR_INVALID_ACCOUNT_NAME 1315
#define ERROR_USER_EXISTS 1316
#define ERROR_NO_SUCH_USER 1317
#define ERROR_GROUP_EXISTS 1318
#define ERROR_NO_SUCH_GROUP 1319
#define ERROR_MEMBER_IN_GROUP 1320
#define ERROR_MEMBER_NOT_IN_GROUP 1321
#define ERROR_LAST_ADMIN 1322
#define ERROR_WRONG_PASSWORD 1323
#define ERROR_ILL_FORMED_PASSWORD 1324
#define ERROR_PASSWORD_RESTRICTION 1325
#define ERROR_LOGON_FAILURE 1326
#define ERROR_ACCOUNT_RESTRICTION 1327
#define ERROR_INVALID_LOGON_HOURS 1328
#define ERROR_INVALID_WORKSTATION 1329
#define ERROR_PASSWORD_EXPIRED 1330
#define ERROR_ACCOUNT_DISABLED 1331
#define ERROR_NONE_MAPPED 1332
#define ERROR_TOO_MANY_LUIDS_REQUESTED 1333
#define ERROR_LUIDS_EXHAUSTED 1334
#define ERROR_INVALID_SUB_AUTHORITY 1335
#define ERROR_INVALID_ACL 1336
#define ERROR_INVALID_SID 1337
#define ERROR_INVALID_SECURITY_DESCR 1338
#define ERROR_BAD_INHERITANCE_ACL 1340
#define ERROR_SERVER_DISABLED 1341
#define ERROR_SERVER_NOT_DISABLED 1342
#define ERROR_INVALID_ID_AUTHORITY 1343
#define ERROR_ALLOTTED_SPACE_EXCEEDED 1344
#define ERROR_INVALID_GROUP_ATTRIBUTES 1345
#define ERROR_BAD_IMPERSONATION_LEVEL 1346
#define ERROR_CANT_OPEN_ANONYMOUS 1347
#define ERROR_BAD_VALIDATION_CLASS 1348
#define ERROR_BAD_TOKEN_TYPE 1349
#define ERROR_NO_SECURITY_ON_OBJECT 1350
#define ERROR_CANT_ACCESS_DOMAIN_INFO 1351
#define ERROR_INVALID_SERVER_STATE 1352
#define ERROR_INVALID_DOMAIN_STATE 1353
#define ERROR_INVALID_DOMAIN_ROLE 1354
#define ERROR_NO_SUCH_DOMAIN 1355
#define ERROR_DOMAIN_EXISTS 1356
#define ERROR_DOMAIN_LIMIT_EXCEEDED 1357
#define ERROR_INTERNAL_DB_CORRUPTION 1358
#define ERROR_INTERNAL_ERROR 1359
#define ERROR_GENERIC_NOT_MAPPED 1360
#define ERROR_BAD_DESCRIPTOR_FORMAT 1361
#define ERROR_NOT_LOGON_PROCESS 1362
#define ERROR_LOGON_SESSION_EXISTS 1363
#define ERROR_NO_SUCH_PACKAGE 1364
#define ERROR_BAD_LOGON_SESSION_STATE 1365
#define ERROR_LOGON_SESSION_COLLISION 1366
#define ERROR_INVALID_LOGON_TYPE 1367
#define ERROR_CANNOT_IMPERSONATE 1368
#define ERROR_RXACT_INVALID_STATE 1369
#define ERROR_RXACT_COMMIT_FAILURE 1370
#define ERROR_SPECIAL_ACCOUNT 1371
#define ERROR_SPECIAL_GROUP 1372
#define ERROR_SPECIAL_USER 1373
#define ERROR_MEMBERS_PRIMARY_GROUP 1374
#define ERROR_TOKEN_ALREADY_IN_USE 1375
#define ERROR_NO_SUCH_ALIAS 1376
#define ERROR_MEMBER_NOT_IN_ALIAS 1377
#define ERROR_MEMBER_IN_ALIAS 1378
#define ERROR_ALIAS_EXISTS 1379
#define ERROR_LOGON_NOT_GRANTED 1380
#define ERROR_TOO_MANY_SECRETS 1381
#define ERROR_SECRET_TOO_LONG 1382
#define ERROR_INTERNAL_DB_ERROR 1383
#define ERROR_TOO_MANY_CONTEXT_IDS 1384
#define ERROR_LOGON_TYPE_NOT_GRANTED 1385
#define ERROR_NT_CROSS_ENCRYPTION_REQUIRED 1386
#define ERROR_NO_SUCH_MEMBER 1387
#define ERROR_INVALID_MEMBER 1388
#define ERROR_TOO_MANY_SIDS 1389
#define ERROR_LM_CROSS_ENCRYPTION_REQUIRED 1390
#define ERROR_NO_INHERITANCE 1391
#define ERROR_FILE_CORRUPT 1392
#define ERROR_DISK_CORRUPT 1393
#define ERROR_NO_USER_SESSION_KEY 1394
#define ERROR_LICENSE_QUOTA_EXCEEDED 1395
#define ERROR_WRONG_TARGET_NAME 1396
#define ERROR_MUTUAL_AUTH_FAILED 1397
#define ERROR_TIME_SKEW 1398
#define ERROR_CURRENT_DOMAIN_NOT_ALLOWED 1399
#define ERROR_INVALID_WINDOW_HANDLE 1400
#define ERROR_INVALID_MENU_HANDLE 1401
#define ERROR_INVALID_CURSOR_HANDLE 1402
#define ERROR_INVALID_ACCEL_HANDLE 1403
#define ERROR_INVALID_HOOK_HANDLE 1404
#define ERROR_INVALID_DWP_HANDLE 1405
#define ERROR_TLW_WITH_WSCHILD 1406
#define ERROR_CANNOT_FIND_WND_CLASS 1407
#define ERROR_WINDOW_OF_OTHER_THREAD 1408
#define ERROR_HOTKEY_ALREADY_REGISTERED 1409
#define ERROR_CLASS_ALREADY_EXISTS 1410
#define ERROR_CLASS_DOES_NOT_EXIST 1411
#define ERROR_CLASS_HAS_WINDOWS 1412
#define ERROR_INVALID_INDEX 1413
#define ERROR_INVALID_ICON_HANDLE 1414
#define ERROR_PRIVATE_DIALOG_INDEX 1415
#define ERROR_LISTBOX_ID_NOT_FOUND 1416
#define ERROR_NO_WILDCARD_CHARACTERS 1417
#define ERROR_CLIPBOARD_NOT_OPEN 1418
#define ERROR_HOTKEY_NOT_REGISTERED 1419
#define ERROR_WINDOW_NOT_DIALOG 1420
#define ERROR_CONTROL_ID_NOT_FOUND 1421
#define ERROR_INVALID_COMBOBOX_MESSAGE 1422
#define ERROR_WINDOW_NOT_COMBOBOX 1423
#define ERROR_INVALID_EDIT_HEIGHT 1424
#define ERROR_DC_NOT_FOUND 1425
#define ERROR_INVALID_HOOK_FILTER 1426
#define ERROR_INVALID_FILTER_PROC 1427
#define ERROR_HOOK_NEEDS_HMOD 1428
#define ERROR_GLOBAL_ONLY_HOOK 1429
#define ERROR_JOURNAL_HOOK_SET 1430
#define ERROR_HOOK_NOT_INSTALLED 1431
#define ERROR_INVALID_LB_MESSAGE 1432
#define ERROR_SETCOUNT_ON_BAD_LB 1433
#define ERROR_LB_WITHOUT_TABSTOPS 1434
#define ERROR_DESTROY_OBJECT_OF_OTHER_THREAD 1435
#define ERROR_CHILD_WINDOW_MENU 1436
#define ERROR_NO_SYSTEM_MENU 1437
#define ERROR_INVALID_MSGBOX_STYLE 1438
#define ERROR_INVALID_SPI_VALUE 1439
#define ERROR_SCREEN_ALREADY_LOCKED 1440
#define ERROR_HWNDS_HAVE_DIFF_PARENT 1441
#define ERROR_NOT_CHILD_WINDOW 1442
#define ERROR_INVALID_GW_COMMAND 1443
#define ERROR_INVALID_THREAD_ID 1444
#define ERROR_NON_MDICHILD_WINDOW 1445
#define ERROR_POPUP_ALREADY_ACTIVE 1446
#define ERROR_NO_SCROLLBARS 1447
#define ERROR_INVALID_SCROLLBAR_RANGE 1448
#define ERROR_INVALID_SHOWWIN_COMMAND 1449
#define ERROR_NO_SYSTEM_RESOURCES 1450
#define ERROR_NONPAGED_SYSTEM_RESOURCES 1451
#define ERROR_PAGED_SYSTEM_RESOURCES 1452
#define ERROR_WORKING_SET_QUOTA 1453
#define ERROR_PAGEFILE_QUOTA 1454
#define ERROR_COMMITMENT_LIMIT 1455
#define ERROR_MENU_ITEM_NOT_FOUND 1456
#define ERROR_INVALID_KEYBOARD_HANDLE 1457
#define ERROR_HOOK_TYPE_NOT_ALLOWED 1458
#define ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION 1459
#define ERROR_TIMEOUT 1460
#define ERROR_INVALID_MONITOR_HANDLE 1461
#define ERROR_INCORRECT_SIZE 1462
#define ERROR_SYMLINK_CLASS_DISABLED 1463
#define ERROR_SYMLINK_NOT_SUPPORTED 1464
#define ERROR_EVENTLOG_FILE_CORRUPT 1500
#define ERROR_EVENTLOG_CANT_START 1501
#define ERROR_LOG_FILE_FULL 1502
#define ERROR_EVENTLOG_FILE_CHANGED 1503
#define ERROR_INVALID_TASK_NAME 1550
#define ERROR_INVALID_TASK_INDEX 1551
#define ERROR_THREAD_ALREADY_IN_TASK 1552
#define ERROR_INSTALL_SERVICE_FAILURE 1601
#define ERROR_INSTALL_USEREXIT 1602
#define ERROR_INSTALL_FAILURE 1603
#define ERROR_INSTALL_SUSPEND 1604
#define ERROR_UNKNOWN_PRODUCT 1605
#define ERROR_UNKNOWN_FEATURE 1606
#define ERROR_UNKNOWN_COMPONENT 1607
#define ERROR_UNKNOWN_PROPERTY 1608
#define ERROR_INVALID_HANDLE_STATE 1609
#define ERROR_BAD_CONFIGURATION 1610
#define ERROR_INDEX_ABSENT 1611
#define ERROR_INSTALL_SOURCE_ABSENT 1612
#define ERROR_INSTALL_PACKAGE_VERSION 1613
#define ERROR_PRODUCT_UNINSTALLED 1614
#define ERROR_BAD_QUERY_SYNTAX 1615
#define ERROR_INVALID_FIELD 1616
#define ERROR_DEVICE_REMOVED 1617
#define ERROR_INSTALL_ALREADY_RUNNING 1618
#define ERROR_INSTALL_PACKAGE_OPEN_FAILED 1619
#define ERROR_INSTALL_PACKAGE_INVALID 1620
#define ERROR_INSTALL_UI_FAILURE 1621
#define ERROR_INSTALL_LOG_FAILURE 1622
#define ERROR_INSTALL_LANGUAGE_UNSUPPORTED 1623
#define ERROR_INSTALL_TRANSFORM_FAILURE 1624
#define ERROR_INSTALL_PACKAGE_REJECTED 1625
#define ERROR_FUNCTION_NOT_CALLED 1626
#define ERROR_FUNCTION_FAILED 1627
#define ERROR_INVALID_TABLE 1628
#define ERROR_DATATYPE_MISMATCH 1629
#define ERROR_UNSUPPORTED_TYPE 1630
#define ERROR_CREATE_FAILED 1631
#define ERROR_INSTALL_TEMP_UNWRITABLE 1632
#define ERROR_INSTALL_PLATFORM_UNSUPPORTED 1633
#define ERROR_INSTALL_NOTUSED 1634
#define ERROR_PATCH_PACKAGE_OPEN_FAILED 1635
#define ERROR_PATCH_PACKAGE_INVALID 1636
#define ERROR_PATCH_PACKAGE_UNSUPPORTED 1637
#define ERROR_PRODUCT_VERSION 1638
#define ERROR_INVALID_COMMAND_LINE 1639
#define ERROR_INSTALL_REMOTE_DISALLOWED 1640
#define ERROR_SUCCESS_REBOOT_INITIATED 1641
#define ERROR_PATCH_TARGET_NOT_FOUND 1642
#define ERROR_PATCH_PACKAGE_REJECTED 1643
#define ERROR_INSTALL_TRANSFORM_REJECTED 1644
#define ERROR_INSTALL_REMOTE_PROHIBITED 1645
#define ERROR_PATCH_REMOVAL_UNSUPPORTED 1646
#define ERROR_UNKNOWN_PATCH 1647
#define ERROR_PATCH_NO_SEQUENCE 1648
#define ERROR_PATCH_REMOVAL_DISALLOWED 1649
#define ERROR_INVALID_PATCH_XML 1650
#define ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT 1651
#define ERROR_INSTALL_SERVICE_SAFEBOOT 1652
#define RPC_S_INVALID_STRING_BINDING 1700
#define RPC_S_WRONG_KIND_OF_BINDING 1701
#define RPC_S_INVALID_BINDING 1702
#define RPC_S_PROTSEQ_NOT_SUPPORTED 1703
#define RPC_S_INVALID_RPC_PROTSEQ 1704
#define RPC_S_INVALID_STRING_UUID 1705
#define RPC_S_INVALID_ENDPOINT_FORMAT 1706
#define RPC_S_INVALID_NET_ADDR 1707
#define RPC_S_NO_ENDPOINT_FOUND 1708
#define RPC_S_INVALID_TIMEOUT 1709
#define RPC_S_OBJECT_NOT_FOUND 1710
#define RPC_S_ALREADY_REGISTERED 1711
#define RPC_S_TYPE_ALREADY_REGISTERED 1712
#define RPC_S_ALREADY_LISTENING 1713
#define RPC_S_NO_PROTSEQS_REGISTERED 1714
#define RPC_S_NOT_LISTENING 1715
#define RPC_S_UNKNOWN_MGR_TYPE 1716
#define RPC_S_UNKNOWN_IF 1717
#define RPC_S_NO_BINDINGS 1718
#define RPC_S_NO_PROTSEQS 1719
#define RPC_S_CANT_CREATE_ENDPOINT 1720
#define RPC_S_OUT_OF_RESOURCES 1721
#define RPC_S_SERVER_UNAVAILABLE 1722
#define RPC_S_SERVER_TOO_BUSY 1723
#define RPC_S_INVALID_NETWORK_OPTIONS 1724
#define RPC_S_NO_CALL_ACTIVE 1725
#define RPC_S_CALL_FAILED 1726
#define RPC_S_CALL_FAILED_DNE 1727
#define RPC_S_PROTOCOL_ERROR 1728
#define RPC_S_PROXY_ACCESS_DENIED 1729
#define RPC_S_UNSUPPORTED_TRANS_SYN 1730
#define RPC_S_UNSUPPORTED_TYPE 1732
#define RPC_S_INVALID_TAG 1733
#define RPC_S_INVALID_BOUND 1734
#define RPC_S_NO_ENTRY_NAME 1735
#define RPC_S_INVALID_NAME_SYNTAX 1736
#define RPC_S_UNSUPPORTED_NAME_SYNTAX 1737
#define RPC_S_UUID_NO_ADDRESS 1739
#define RPC_S_DUPLICATE_ENDPOINT 1740
#define RPC_S_UNKNOWN_AUTHN_TYPE 1741
#define RPC_S_MAX_CALLS_TOO_SMALL 1742
#define RPC_S_STRING_TOO_LONG 1743
#define RPC_S_PROTSEQ_NOT_FOUND 1744
#define RPC_S_PROCNUM_OUT_OF_RANGE 1745
#define RPC_S_BINDING_HAS_NO_AUTH 1746
#define RPC_S_UNKNOWN_AUTHN_SERVICE 1747
#define RPC_S_UNKNOWN_AUTHN_LEVEL 1748
#define RPC_S_INVALID_AUTH_IDENTITY 1749
#define RPC_S_UNKNOWN_AUTHZ_SERVICE 1750
#define EPT_S_INVALID_ENTRY 1751
#define EPT_S_CANT_PERFORM_OP 1752
#define EPT_S_NOT_REGISTERED 1753
#define RPC_S_NOTHING_TO_EXPORT 1754
#define RPC_S_INCOMPLETE_NAME 1755
#define RPC_S_INVALID_VERS_OPTION 1756
#define RPC_S_NO_MORE_MEMBERS 1757
#define RPC_S_NOT_ALL_OBJS_UNEXPORTED 1758
#define RPC_S_INTERFACE_NOT_FOUND 1759
#define RPC_S_ENTRY_ALREADY_EXISTS 1760
#define RPC_S_ENTRY_NOT_FOUND 1761
#define RPC_S_NAME_SERVICE_UNAVAILABLE 1762
#define RPC_S_INVALID_NAF_ID 1763
#define RPC_S_CANNOT_SUPPORT 1764
#define RPC_S_NO_CONTEXT_AVAILABLE 1765
#define RPC_S_INTERNAL_ERROR 1766
#define RPC_S_ZERO_DIVIDE 1767
#define RPC_S_ADDRESS_ERROR 1768
#define RPC_S_FP_DIV_ZERO 1769
#define RPC_S_FP_UNDERFLOW 1770
#define RPC_S_FP_OVERFLOW 1771
#define RPC_X_NO_MORE_ENTRIES 1772
#define RPC_X_SS_CHAR_TRANS_OPEN_FAIL 1773
#define RPC_X_SS_CHAR_TRANS_SHORT_FILE 1774
#define RPC_X_SS_IN_NULL_CONTEXT 1775
#define RPC_X_SS_CONTEXT_DAMAGED 1777
#define RPC_X_SS_HANDLES_MISMATCH 1778
#define RPC_X_SS_CANNOT_GET_CALL_HANDLE 1779
#define RPC_X_NULL_REF_POINTER 1780
#define RPC_X_ENUM_VALUE_OUT_OF_RANGE 1781
#define RPC_X_BYTE_COUNT_TOO_SMALL 1782
#define RPC_X_BAD_STUB_DATA 1783
#define ERROR_INVALID_USER_BUFFER 1784
#define ERROR_UNRECOGNIZED_MEDIA 1785
#define ERROR_NO_TRUST_LSA_SECRET 1786
#define ERROR_NO_TRUST_SAM_ACCOUNT 1787
#define ERROR_TRUSTED_DOMAIN_FAILURE 1788
#define ERROR_TRUSTED_RELATIONSHIP_FAILURE 1789
#define ERROR_TRUST_FAILURE 1790
#define RPC_S_CALL_IN_PROGRESS 1791
#define ERROR_NETLOGON_NOT_STARTED 1792
#define ERROR_ACCOUNT_EXPIRED 1793
#define ERROR_REDIRECTOR_HAS_OPEN_HANDLES 1794
#define ERROR_PRINTER_DRIVER_ALREADY_INSTALLED 1795
#define ERROR_UNKNOWN_PORT 1796
#define ERROR_UNKNOWN_PRINTER_DRIVER 1797
#define ERROR_UNKNOWN_PRINTPROCESSOR 1798
#define ERROR_INVALID_SEPARATOR_FILE 1799
#define ERROR_INVALID_PRIORITY 1800
#define ERROR_INVALID_PRINTER_NAME 1801
#define ERROR_PRINTER_ALREADY_EXISTS 1802
#define ERROR_INVALID_PRINTER_COMMAND 1803
#define ERROR_INVALID_DATATYPE 1804
#define ERROR_INVALID_ENVIRONMENT 1805
#define RPC_S_NO_MORE_BINDINGS 1806
#define ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT 1807
#define ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT 1808
#define ERROR_NOLOGON_SERVER_TRUST_ACCOUNT 1809
#define ERROR_DOMAIN_TRUST_INCONSISTENT 1810
#define ERROR_SERVER_HAS_OPEN_HANDLES 1811
#define ERROR_RESOURCE_DATA_NOT_FOUND 1812
#define ERROR_RESOURCE_TYPE_NOT_FOUND 1813
#define ERROR_RESOURCE_NAME_NOT_FOUND 1814
#define ERROR_RESOURCE_LANG_NOT_FOUND 1815
#define ERROR_NOT_ENOUGH_QUOTA 1816
#define RPC_S_NO_INTERFACES 1817
#define RPC_S_CALL_CANCELLED 1818
#define RPC_S_BINDING_INCOMPLETE 1819
#define RPC_S_COMM_FAILURE 1820
#define RPC_S_UNSUPPORTED_AUTHN_LEVEL 1821
#define RPC_S_NO_PRINC_NAME 1822
#define RPC_S_NOT_RPC_ERROR 1823
#define RPC_S_UUID_LOCAL_ONLY 1824
#define RPC_S_SEC_PKG_ERROR 1825
#define RPC_S_NOT_CANCELLED 1826
#define RPC_X_INVALID_ES_ACTION 1827
#define RPC_X_WRONG_ES_VERSION 1828
#define RPC_X_WRONG_STUB_VERSION 1829
#define RPC_X_INVALID_PIPE_OBJECT 1830
#define RPC_X_WRONG_PIPE_ORDER 1831
#define RPC_X_WRONG_PIPE_VERSION 1832
#define RPC_S_GROUP_MEMBER_NOT_FOUND 1898
#define EPT_S_CANT_CREATE 1899
#define RPC_S_INVALID_OBJECT 1900
#define ERROR_INVALID_TIME 1901
#define ERROR_INVALID_FORM_NAME 1902
#define ERROR_INVALID_FORM_SIZE 1903
#define ERROR_ALREADY_WAITING 1904
#define ERROR_PRINTER_DELETED 1905
#define ERROR_INVALID_PRINTER_STATE 1906
#define ERROR_PASSWORD_MUST_CHANGE 1907
#define ERROR_DOMAIN_CONTROLLER_NOT_FOUND 1908
#define ERROR_ACCOUNT_LOCKED_OUT 1909
#define OR_INVALID_OXID 1910
#define OR_INVALID_OID 1911
#define OR_INVALID_SET 1912
#define RPC_S_SEND_INCOMPLETE 1913
#define RPC_S_INVALID_ASYNC_HANDLE 1914
#define RPC_S_INVALID_ASYNC_CALL 1915
#define RPC_X_PIPE_CLOSED 1916
#define RPC_X_PIPE_DISCIPLINE_ERROR 1917
#define RPC_X_PIPE_EMPTY 1918
#define ERROR_NO_SITENAME 1919
#define ERROR_CANT_ACCESS_FILE 1920
#define ERROR_CANT_RESOLVE_FILENAME 1921
#define RPC_S_ENTRY_TYPE_MISMATCH 1922
#define RPC_S_NOT_ALL_OBJS_EXPORTED 1923
#define RPC_S_INTERFACE_NOT_EXPORTED 1924
#define RPC_S_PROFILE_NOT_ADDED 1925
#define RPC_S_PRF_ELT_NOT_ADDED 1926
#define RPC_S_PRF_ELT_NOT_REMOVED 1927
#define RPC_S_GRP_ELT_NOT_ADDED 1928
#define RPC_S_GRP_ELT_NOT_REMOVED 1929
#define ERROR_KM_DRIVER_BLOCKED 1930
#define ERROR_CONTEXT_EXPIRED 1931
#define ERROR_PER_USER_TRUST_QUOTA_EXCEEDED 1932
#define ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED 1933
#define ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED 1934
#define ERROR_AUTHENTICATION_FIREWALL_FAILED 1935
#define ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED 1936
#define ERROR_INVALID_PIXEL_FORMAT 2000
#define ERROR_BAD_DRIVER 2001
#define ERROR_INVALID_WINDOW_STYLE 2002
#define ERROR_METAFILE_NOT_SUPPORTED 2003
#define ERROR_TRANSFORM_NOT_SUPPORTED 2004
#define ERROR_CLIPPING_NOT_SUPPORTED 2005
#define ERROR_INVALID_CMM 2010
#define ERROR_INVALID_PROFILE 2011
#define ERROR_TAG_NOT_FOUND 2012
#define ERROR_TAG_NOT_PRESENT 2013
#define ERROR_DUPLICATE_TAG 2014
#define ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE 2015
#define ERROR_PROFILE_NOT_FOUND 2016
#define ERROR_INVALID_COLORSPACE 2017
#define ERROR_ICM_NOT_ENABLED 2018
#define ERROR_DELETING_ICM_XFORM 2019
#define ERROR_INVALID_TRANSFORM 2020
#define ERROR_COLORSPACE_MISMATCH 2021
#define ERROR_INVALID_COLORINDEX 2022
#define ERROR_PROFILE_DOES_NOT_MATCH_DEVICE 2023
#define NERR_NetNotStarted 2102
#define NERR_ShareMem 2104
#define NERR_NoNetworkResource 2105
#define NERR_RemoteOnly 2106
#define NERR_DevNotRedirected 2107
#define ERROR_CONNECTED_OTHER_PASSWORD 2108
#define ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT 2109
#define NERR_ServerNotStarted 2114
#define NERR_ItemNotFound 2115
#define NERR_RedirectedPath 2117
#define NERR_DuplicateShare 2118
#define NERR_NoRoom 2119
#define NERR_TooManyItems 2121
#define NERR_InvalidMaxUsers 2122
#define NERR_BufTooSmall 2123
#define NERR_RemoteErr 2127
#define NERR_LanmanIniError 2131
#define NERR_NetworkError 2136
#define NERR_WkstaInconsistentState 2137
#define NERR_WkstaNotStarted 2138
#define NERR_BrowserNotStarted 2139
#define NERR_InternalError 2140
#define NERR_BadTransactConfig 2141
#define NERR_InvalidAPI 2142
#define NERR_BadEventName 2143
#define NERR_DupNameReboot 2144
#define NERR_CfgCompNotFound 2146
#define NERR_CfgParamNotFound 2147
#define NERR_LineTooLong 2149
#define NERR_QNotFound 2150
#define NERR_JobNotFound 2151
#define NERR_DestNotFound 2152
#define NERR_DestExists 2153
#define NERR_QExists 2154
#define NERR_QNoRoom 2155
#define NERR_JobNoRoom 2156
#define NERR_DestNoRoom 2157
#define NERR_DestIdle 2158
#define NERR_DestInvalidOp 2159
#define NERR_ProcNoRespond 2160
#define NERR_SpoolerNotLoaded 2161
#define NERR_DestInvalidState 2162
#define NERR_QinvalidState 2163
#define NERR_JobInvalidState 2164
#define NERR_SpoolNoMemory 2165
#define NERR_DriverNotFound 2166
#define NERR_DataTypeInvalid 2167
#define NERR_ProcNotFound 2168
#define NERR_ServiceTableLocked 2180
#define NERR_ServiceTableFull 2181
#define NERR_ServiceInstalled 2182
#define NERR_ServiceEntryLocked 2183
#define NERR_ServiceNotInstalled 2184
#define NERR_BadServiceName 2185
#define NERR_ServiceCtlTimeout 2186
#define NERR_ServiceCtlBusy 2187
#define NERR_BadServiceProgName 2188
#define NERR_ServiceNotCtrl 2189
#define NERR_ServiceKillProc 2190
#define NERR_ServiceCtlNotValid 2191
#define NERR_NotInDispatchTbl 2192
#define NERR_BadControlRecv 2193
#define NERR_ServiceNotStarting 2194
#define NERR_AlreadyLoggedOn 2200
#define NERR_NotLoggedOn 2201
#define NERR_BAD_USERNAME 2202
#define NERR_BadPassword 2203
#define NERR_UnableToAddName_W 2204
#define NERR_UnableToAddName_F 2205
#define NERR_UnableToDelName_W 2206
#define NERR_UnableToDelName_F 2207
#define NERR_LogonsPaused 2209
#define NERR_LogonServerConflict 2210
#define NERR_LogonNoUserPath 2211
#define NERR_LogonScriptError 2212
#define NERR_StandaloneLogon 2214
#define NERR_LogonServerNotFound 2215
#define NERR_LogonDomainExists 2216
#define NERR_NonValidatedLogon 2217
#define NERR_ACFNotFound 2219
#define NERR_GroupNotFound 2220
#define NERR_UserNotFound 2221
#define NERR_ResourceNotFound 2222
#define NERR_GroupExists 2223
#define NERR_UserExists 2224
#define NERR_ResourceExists 2225
#define NERR_NotPrimary 2226
#define NERR_ACFNotLoaded 2227
#define NERR_ACFNoRoom 2228
#define NERR_ACFFileIOFail 2229
#define NERR_ACFTooManyLists 2230
#define NERR_UserLogon 2231
#define NERR_ACFNoParent 2232
#define NERR_CanNotGrowSegment 2233
#define NERR_SpeGroupOp 2234
#define NERR_NotInCache 2235
#define NERR_UserInGroup 2236
#define NERR_UserNotInGroup 2237
#define NERR_AccountUndefined 2238
#define NERR_AccountExpired 2239
#define NERR_InvalidWorkstation 2240
#define NERR_InvalidLogonHours 2241
#define NERR_PasswordExpired 2242
#define NERR_PasswordCantChange 2243
#define NERR_PasswordHistConflict 2244
#define NERR_PasswordTooShort 2245
#define NERR_PasswordTooRecent 2246
#define NERR_InvalidDatabase 2247
#define NERR_DatabaseUpToDate 2248
#define NERR_SyncRequired 2249
#define NERR_UseNotFound 2250
#define NERR_BadAsgType 2251
#define NERR_DeviceIsShared 2252
#define NERR_NoComputerName 2270
#define NERR_MsgAlreadyStarted 2271
#define NERR_MsgInitFailed 2272
#define NERR_NameNotFound 2273
#define NERR_AlreadyForwarded 2274
#define NERR_AddForwarded 2275
#define NERR_AlreadyExists 2276
#define NERR_TooManyNames 2277
#define NERR_DelComputerName 2278
#define NERR_LocalForward 2279
#define NERR_GrpMsgProcessor 2280
#define NERR_PausedRemote 2281
#define NERR_BadReceive 2282
#define NERR_NameInUse 2283
#define NERR_MsgNotStarted 2284
#define NERR_NotLocalName 2285
#define NERR_NoForwardName 2286
#define NERR_RemoteFull 2287
#define NERR_NameNotForwarded 2288
#define NERR_TruncatedBroadcast 2289
#define NERR_InvalidDevice 2294
#define NERR_WriteFault 2295
#define NERR_DuplicateName 2297
#define NERR_DeleteLater 2298
#define NERR_IncompleteDel 2299
#define NERR_MultipleNets 2300
#define NERR_NetNameNotFound 2310
#define NERR_DeviceNotShared 2311
#define NERR_ClientNameNotFound 2312
#define NERR_FileIdNotFound 2314
#define NERR_ExecFailure 2315
#define NERR_TmpFile 2316
#define NERR_TooMuchData 2317
#define NERR_DeviceShareConflict 2318
#define NERR_BrowserTableIncomplete 2319
#define NERR_NotLocalDomain 2320
#define NERR_IsDfsShare 2321
#define NERR_DevInvalidOpCode 2331
#define NERR_DevNotFound 2332
#define NERR_DevNotOpen 2333
#define NERR_BadQueueDevString 2334
#define NERR_BadQueuePriority 2335
#define NERR_NoCommDevs 2337
#define NERR_QueueNotFound 2338
#define NERR_BadDevString 2340
#define NERR_BadDev 2341
#define NERR_InUseBySpooler 2342
#define NERR_CommDevInUse 2343
#define NERR_InvalidComputer 2351
#define NERR_MaxLenExceeded 2354
#define NERR_BadComponent 2356
#define NERR_CantType 2357
#define NERR_TooManyEntries 2362
#define NERR_ProfileFileTooBig 2370
#define NERR_ProfileOffset 2371
#define NERR_ProfileCleanup 2372
#define NERR_ProfileLoadErr 2374
#define NERR_ProfileSaveErr 2375
#define NERR_LogOverflow 2377
#define NERR_LogFileChanged 2378
#define NERR_LogFileCorrupt 2379
#define NERR_SourceIsDir 2380
#define NERR_BadSource 2381
#define NERR_BadDest 2382
#define NERR_DifferentServers 2383
#define NERR_RunSrvPaused 2385
#define NERR_ErrCommRunSrv 2389
#define NERR_ErrorExecingGhost 2391
#define NERR_ShareNotFound 2392
#define NERR_InvalidLana 2400
#define NERR_OpenFiles 2401
#define NERR_ActiveConns 2402
#define NERR_BadPasswordCore 2403
#define NERR_DevInUse 2404
#define NERR_LocalDrive 2405
#define NERR_AlertExists 2430
#define NERR_TooManyAlerts 2431
#define NERR_NoSuchAlert 2432
#define NERR_BadRecipient 2433
#define NERR_AcctLimitExceeded 2434
#define NERR_InvalidLogSeek 2440
#define NERR_BadUasConfig 2450
#define NERR_InvalidUASOp 2451
#define NERR_LastAdmin 2452
#define NERR_DCNotFound 2453
#define NERR_LogonTrackingError 2454
#define NERR_NetlogonNotStarted 2455
#define NERR_CanNotGrowUASFile 2456
#define NERR_TimeDiffAtDC 2457
#define NERR_PasswordMismatch 2458
#define NERR_NoSuchServer 2460
#define NERR_NoSuchSession 2461
#define NERR_NoSuchConnection 2462
#define NERR_TooManyServers 2463
#define NERR_TooManySessions 2464
#define NERR_TooManyConnections 2465
#define NERR_TooManyFiles 2466
#define NERR_NoAlternateServers 2467
#define NERR_TryDownLevel 2470
#define NERR_UPSDriverNotStarted 2480
#define NERR_UPSInvalidConfig 2481
#define NERR_UPSInvalidCommPort 2482
#define NERR_UPSSignalAsserted 2483
#define NERR_UPSShutdownFailed 2484
#define NERR_BadDosRetCode 2500
#define NERR_ProgNeedsExtraMem 2501
#define NERR_BadDosFunction 2502
#define NERR_RemoteBootFailed 2503
#define NERR_BadFileCheckSum 2504
#define NERR_NoRplBootSystem 2505
#define NERR_RplLoadrNetBiosErr 2506
#define NERR_RplLoadrDiskErr 2507
#define NERR_ImageParamErr 2508
#define NERR_TooManyImageParams 2509
#define NERR_NonDosFloppyUsed 2510
#define NERR_RplBootRestart 2511
#define NERR_RplSrvrCallFailed 2512
#define NERR_CantConnectRplSrvr 2513
#define NERR_CantOpenImageFile 2514
#define NERR_CallingRplSrvr 2515
#define NERR_StartingRplBoot 2516
#define NERR_RplBootServiceTerm 2517
#define NERR_RplBootStartFailed 2518
#define NERR_RPL_CONNECTED 2519
#define NERR_BrowserConfiguredToNotRun 2550
#define NERR_RplNoAdaptersStarted 2610
#define NERR_RplBadRegistry 2611
#define NERR_RplBadDatabase 2612
#define NERR_RplRplfilesShare 2613
#define NERR_RplNotRplServer 2614
#define NERR_RplCannotEnum 2615
#define NERR_RplWkstaInfoCorrupted 2616
#define NERR_RplWkstaNotFound 2617
#define NERR_RplWkstaNameUnavailable 2618
#define NERR_RplProfileInfoCorrupted 2619
#define NERR_RplProfileNotFound 2620
#define NERR_RplProfileNameUnavailable 2621
#define NERR_RplProfileNotEmpty 2622
#define NERR_RplConfigInfoCorrupted 2623
#define NERR_RplConfigNotFound 2624
#define NERR_RplAdapterInfoCorrupted 2625
#define NERR_RplInternal 2626
#define NERR_RplVendorInfoCorrupted 2627
#define NERR_RplBootInfoCorrupted 2628
#define NERR_RplWkstaNeedsUserAcct 2629
#define NERR_RplNeedsRPLUSERAcct 2630
#define NERR_RplBootNotFound 2631
#define NERR_RplIncompatibleProfile 2632
#define NERR_RplAdapterNameUnavailable 2633
#define NERR_RplConfigNotEmpty 2634
#define NERR_RplBootInUse 2635
#define NERR_RplBackupDatabase 2636
#define NERR_RplAdapterNotFound 2637
#define NERR_RplVendorNotFound 2638
#define NERR_RplVendorNameUnavailable 2639
#define NERR_RplBootNameUnavailable 2640
#define NERR_RplConfigNameUnavailable 2641
#define NERR_DfsInternalCorruption 2660
#define NERR_DfsVolumeDataCorrupt 2661
#define NERR_DfsNoSuchVolume 2662
#define NERR_DfsVolumeAlreadyExists 2663
#define NERR_DfsAlreadyShared 2664
#define NERR_DfsNoSuchShare 2665
#define NERR_DfsNotALeafVolume 2666
#define NERR_DfsLeafVolume 2667
#define NERR_DfsVolumeHasMultipleServers 2668
#define NERR_DfsCantCreateJunctionPoint 2669
#define NERR_DfsServerNotDfsAware 2670
#define NERR_DfsBadRenamePath 2671
#define NERR_DfsVolumeIsOffline 2672
#define NERR_DfsNoSuchServer 2673
#define NERR_DfsCyclicalName 2674
#define NERR_DfsNotSupportedInServerDfs 2675
#define NERR_DfsDuplicateService 2676
#define NERR_DfsCantRemoveLastServerShare 2677
#define NERR_DfsVolumeIsInterDfs 2678
#define NERR_DfsInconsistent 2679
#define NERR_DfsServerUpgraded 2680
#define NERR_DfsDataIsIdentical 2681
#define NERR_DfsCantRemoveDfsRoot 2682
#define NERR_DfsChildOrParentInDfs 2683
#define NERR_DfsInternalError 2690
#define NERR_SetupAlreadyJoined 2691
#define NERR_SetupNotJoined 2692
#define NERR_SetupDomainController 2693
#define NERR_DefaultJoinRequired 2694
#define NERR_InvalidWorkgroupName 2695
#define NERR_NameUsesIncompatibleCodePage 2696
#define NERR_ComputerAccountNotFound 2697
#define NERR_PersonalSku 2698
#define NERR_PasswordMustChange 2701
#define NERR_AccountLockedOut 2702
#define NERR_PasswordTooLong 2703
#define NERR_PasswordNotComplexEnough 2704
#define NERR_PasswordFilterError 2705
#define ERROR_UNKNOWN_PRINT_MONITOR 3000
#define ERROR_PRINTER_DRIVER_IN_USE 3001
#define ERROR_SPOOL_FILE_NOT_FOUND 3002
#define ERROR_SPL_NO_STARTDOC 3003
#define ERROR_SPL_NO_ADDJOB 3004
#define ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED 3005
#define ERROR_PRINT_MONITOR_ALREADY_INSTALLED 3006
#define ERROR_INVALID_PRINT_MONITOR 3007
#define ERROR_PRINT_MONITOR_IN_USE 3008
#define ERROR_PRINTER_HAS_JOBS_QUEUED 3009
#define ERROR_SUCCESS_REBOOT_REQUIRED 3010
#define ERROR_SUCCESS_RESTART_REQUIRED 3011
#define ERROR_PRINTER_NOT_FOUND 3012
#define ERROR_PRINTER_DRIVER_WARNED 3013
#define ERROR_PRINTER_DRIVER_BLOCKED 3014
#define ERROR_PRINTER_DRIVER_PACKAGE_IN_USE 3015
#define ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND 3016
#define ERROR_FAIL_REBOOT_REQUIRED 3017
#define ERROR_FAIL_REBOOT_INITIATED 3018
#define ERROR_IO_REISSUE_AS_CACHED 3950
#define ERROR_WINS_INTERNAL 4000
#define ERROR_CAN_NOT_DEL_LOCAL_WINS 4001
#define ERROR_STATIC_INIT 4002
#define ERROR_INC_BACKUP 4003
#define ERROR_FULL_BACKUP 4004
#define ERROR_REC_NON_EXISTENT 4005
#define ERROR_RPL_NOT_ALLOWED 4006
#define PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED 4050
#define PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO 4051
#define PEERDIST_ERROR_MISSING_DATA 4052
#define PEERDIST_ERROR_NO_MORE 4053
#define PEERDIST_ERROR_NOT_INITIALIZED 4054
#define PEERDIST_ERROR_ALREADY_INITIALIZED 4055
#define PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS 4056
#define PEERDIST_ERROR_INVALIDATED 4057
#define PEERDIST_ERROR_ALREADY_EXISTS 4058
#define PEERDIST_ERROR_OPERATION_NOTFOUND 4059
#define PEERDIST_ERROR_ALREADY_COMPLETED 4060
#define PEERDIST_ERROR_OUT_OF_BOUNDS 4061
#define PEERDIST_ERROR_VERSION_UNSUPPORTED 4062
#define PEERDIST_ERROR_INVALID_CONFIGURATION 4063
#define PEERDIST_ERROR_NOT_LICENSED 4064
#define PEERDIST_ERROR_SERVICE_UNAVAILABLE 4065
#define ERROR_DHCP_ADDRESS_CONFLICT 4100
#define ERROR_WMI_GUID_NOT_FOUND 4200
#define ERROR_WMI_INSTANCE_NOT_FOUND 4201
#define ERROR_WMI_ITEMID_NOT_FOUND 4202
#define ERROR_WMI_TRY_AGAIN 4203
#define ERROR_WMI_DP_NOT_FOUND 4204
#define ERROR_WMI_UNRESOLVED_INSTANCE_REF 4205
#define ERROR_WMI_ALREADY_ENABLED 4206
#define ERROR_WMI_GUID_DISCONNECTED 4207
#define ERROR_WMI_SERVER_UNAVAILABLE 4208
#define ERROR_WMI_DP_FAILED 4209
#define ERROR_WMI_INVALID_MOF 4210
#define ERROR_WMI_INVALID_REGINFO 4211
#define ERROR_WMI_ALREADY_DISABLED 4212
#define ERROR_WMI_READ_ONLY 4213
#define ERROR_WMI_SET_FAILURE 4214
#define ERROR_INVALID_MEDIA 4300
#define ERROR_INVALID_LIBRARY 4301
#define ERROR_INVALID_MEDIA_POOL 4302
#define ERROR_DRIVE_MEDIA_MISMATCH 4303
#define ERROR_MEDIA_OFFLINE 4304
#define ERROR_LIBRARY_OFFLINE 4305
#define ERROR_EMPTY 4306
#define ERROR_NOT_EMPTY 4307
#define ERROR_MEDIA_UNAVAILABLE 4308
#define ERROR_RESOURCE_DISABLED 4309
#define ERROR_INVALID_CLEANER 4310
#define ERROR_UNABLE_TO_CLEAN 4311
#define ERROR_OBJECT_NOT_FOUND 4312
#define ERROR_DATABASE_FAILURE 4313
#define ERROR_DATABASE_FULL 4314
#define ERROR_MEDIA_INCOMPATIBLE 4315
#define ERROR_RESOURCE_NOT_PRESENT 4316
#define ERROR_INVALID_OPERATION 4317
#define ERROR_MEDIA_NOT_AVAILABLE 4318
#define ERROR_DEVICE_NOT_AVAILABLE 4319
#define ERROR_REQUEST_REFUSED 4320
#define ERROR_INVALID_DRIVE_OBJECT 4321
#define ERROR_LIBRARY_FULL 4322
#define ERROR_MEDIUM_NOT_ACCESSIBLE 4323
#define ERROR_UNABLE_TO_LOAD_MEDIUM 4324
#define ERROR_UNABLE_TO_INVENTORY_DRIVE 4325
#define ERROR_UNABLE_TO_INVENTORY_SLOT 4326
#define ERROR_UNABLE_TO_INVENTORY_TRANSPORT 4327
#define ERROR_TRANSPORT_FULL 4328
#define ERROR_CONTROLLING_IEPORT 4329
#define ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA 4330
#define ERROR_CLEANER_SLOT_SET 4331
#define ERROR_CLEANER_SLOT_NOT_SET 4332
#define ERROR_CLEANER_CARTRIDGE_SPENT 4333
#define ERROR_UNEXPECTED_OMID 4334
#define ERROR_CANT_DELETE_LAST_ITEM 4335
#define ERROR_MESSAGE_EXCEEDS_MAX_SIZE 4336
#define ERROR_VOLUME_CONTAINS_SYS_FILES 4337
#define ERROR_INDIGENOUS_TYPE 4338
#define ERROR_NO_SUPPORTING_DRIVES 4339
#define ERROR_CLEANER_CARTRIDGE_INSTALLED 4340
#define ERROR_IEPORT_FULL 4341
#define ERROR_FILE_OFFLINE 4350
#define ERROR_REMOTE_STORAGE_NOT_ACTIVE 4351
#define ERROR_REMOTE_STORAGE_MEDIA_ERROR 4352
#define ERROR_NOT_A_REPARSE_POINT 4390
#define ERROR_REPARSE_ATTRIBUTE_CONFLICT 4391
#define ERROR_INVALID_REPARSE_DATA 4392
#define ERROR_REPARSE_TAG_INVALID 4393
#define ERROR_REPARSE_TAG_MISMATCH 4394
#define ERROR_VOLUME_NOT_SIS_ENABLED 4500
#define ERROR_DEPENDENT_RESOURCE_EXISTS 5001
#define ERROR_DEPENDENCY_NOT_FOUND 5002
#define ERROR_DEPENDENCY_ALREADY_EXISTS 5003
#define ERROR_RESOURCE_NOT_ONLINE 5004
#define ERROR_HOST_NODE_NOT_AVAILABLE 5005
#define ERROR_RESOURCE_NOT_AVAILABLE 5006
#define ERROR_RESOURCE_NOT_FOUND 5007
#define ERROR_SHUTDOWN_CLUSTER 5008
#define ERROR_CANT_EVICT_ACTIVE_NODE 5009
#define ERROR_OBJECT_ALREADY_EXISTS 5010
#define ERROR_OBJECT_IN_LIST 5011
#define ERROR_GROUP_NOT_AVAILABLE 5012
#define ERROR_GROUP_NOT_FOUND 5013
#define ERROR_GROUP_NOT_ONLINE 5014
#define ERROR_HOST_NODE_NOT_RESOURCE_OWNER 5015
#define ERROR_HOST_NODE_NOT_GROUP_OWNER 5016
#define ERROR_RESMON_CREATE_FAILED 5017
#define ERROR_RESMON_ONLINE_FAILED 5018
#define ERROR_RESOURCE_ONLINE 5019
#define ERROR_QUORUM_RESOURCE 5020
#define ERROR_NOT_QUORUM_CAPABLE 5021
#define ERROR_CLUSTER_SHUTTING_DOWN 5022
#define ERROR_INVALID_STATE 5023
#define ERROR_RESOURCE_PROPERTIES_STORED 5024
#define ERROR_NOT_QUORUM_CLASS 5025
#define ERROR_CORE_RESOURCE 5026
#define ERROR_QUORUM_RESOURCE_ONLINE_FAILED 5027
#define ERROR_QUORUMLOG_OPEN_FAILED 5028
#define ERROR_CLUSTERLOG_CORRUPT 5029
#define ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE 5030
#define ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE 5031
#define ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND 5032
#define ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE 5033
#define ERROR_QUORUM_OWNER_ALIVE 5034
#define ERROR_NETWORK_NOT_AVAILABLE 5035
#define ERROR_NODE_NOT_AVAILABLE 5036
#define ERROR_ALL_NODES_NOT_AVAILABLE 5037
#define ERROR_RESOURCE_FAILED 5038
#define ERROR_CLUSTER_INVALID_NODE 5039
#define ERROR_CLUSTER_NODE_EXISTS 5040
#define ERROR_CLUSTER_JOIN_IN_PROGRESS 5041
#define ERROR_CLUSTER_NODE_NOT_FOUND 5042
#define ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND 5043
#define ERROR_CLUSTER_NETWORK_EXISTS 5044
#define ERROR_CLUSTER_NETWORK_NOT_FOUND 5045
#define ERROR_CLUSTER_NETINTERFACE_EXISTS 5046
#define ERROR_CLUSTER_NETINTERFACE_NOT_FOUND 5047
#define ERROR_CLUSTER_INVALID_REQUEST 5048
#define ERROR_CLUSTER_INVALID_NETWORK_PROVIDER 5049
#define ERROR_CLUSTER_NODE_DOWN 5050
#define ERROR_CLUSTER_NODE_UNREACHABLE 5051
#define ERROR_CLUSTER_NODE_NOT_MEMBER 5052
#define ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS 5053
#define ERROR_CLUSTER_INVALID_NETWORK 5054
#define ERROR_CLUSTER_NODE_UP 5056
#define ERROR_CLUSTER_IPADDR_IN_USE 5057
#define ERROR_CLUSTER_NODE_NOT_PAUSED 5058
#define ERROR_CLUSTER_NO_SECURITY_CONTEXT 5059
#define ERROR_CLUSTER_NETWORK_NOT_INTERNAL 5060
#define ERROR_CLUSTER_NODE_ALREADY_UP 5061
#define ERROR_CLUSTER_NODE_ALREADY_DOWN 5062
#define ERROR_CLUSTER_NETWORK_ALREADY_ONLINE 5063
#define ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE 5064
#define ERROR_CLUSTER_NODE_ALREADY_MEMBER 5065
#define ERROR_CLUSTER_LAST_INTERNAL_NETWORK 5066
#define ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS 5067
#define ERROR_INVALID_OPERATION_ON_QUORUM 5068
#define ERROR_DEPENDENCY_NOT_ALLOWED 5069
#define ERROR_CLUSTER_NODE_PAUSED 5070
#define ERROR_NODE_CANT_HOST_RESOURCE 5071
#define ERROR_CLUSTER_NODE_NOT_READY 5072
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN 5073
#define ERROR_CLUSTER_JOIN_ABORTED 5074
#define ERROR_CLUSTER_INCOMPATIBLE_VERSIONS 5075
#define ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED 5076
#define ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED 5077
#define ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND 5078
#define ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED 5079
#define ERROR_CLUSTER_RESNAME_NOT_FOUND 5080
#define ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED 5081
#define ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST 5082
#define ERROR_CLUSTER_DATABASE_SEQMISMATCH 5083
#define ERROR_RESMON_INVALID_STATE 5084
#define ERROR_CLUSTER_GUM_NOT_LOCKER 5085
#define ERROR_QUORUM_DISK_NOT_FOUND 5086
#define ERROR_DATABASE_BACKUP_CORRUPT 5087
#define ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT 5088
#define ERROR_RESOURCE_PROPERTY_UNCHANGEABLE 5089
#define ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE 5890
#define ERROR_CLUSTER_QUORUMLOG_NOT_FOUND 5891
#define ERROR_CLUSTER_MEMBERSHIP_HALT 5892
#define ERROR_CLUSTER_INSTANCE_ID_MISMATCH 5893
#define ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP 5894
#define ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH 5895
#define ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP 5896
#define ERROR_CLUSTER_PARAMETER_MISMATCH 5897
#define ERROR_NODE_CANNOT_BE_CLUSTERED 5898
#define ERROR_CLUSTER_WRONG_OS_VERSION 5899
#define ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME 5900
#define ERROR_CLUSCFG_ALREADY_COMMITTED 5901
#define ERROR_CLUSCFG_ROLLBACK_FAILED 5902
#define ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT 5903
#define ERROR_CLUSTER_OLD_VERSION 5904
#define ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME 5905
#define ERROR_CLUSTER_NO_NET_ADAPTERS 5906
#define ERROR_CLUSTER_POISONED 5907
#define ERROR_CLUSTER_GROUP_MOVING 5908
#define ERROR_CLUSTER_RESOURCE_TYPE_BUSY 5909
#define ERROR_RESOURCE_CALL_TIMED_OUT 5910
#define ERROR_INVALID_CLUSTER_IPV6_ADDRESS 5911
#define ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION 5912
#define ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS 5913
#define ERROR_CLUSTER_PARTIAL_SEND 5914
#define ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION 5915
#define ERROR_CLUSTER_INVALID_STRING_TERMINATION 5916
#define ERROR_CLUSTER_INVALID_STRING_FORMAT 5917
#define ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS 5918
#define ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS 5919
#define ERROR_CLUSTER_NULL_DATA 5920
#define ERROR_CLUSTER_PARTIAL_READ 5921
#define ERROR_CLUSTER_PARTIAL_WRITE 5922
#define ERROR_CLUSTER_CANT_DESERIALIZE_DATA 5923
#define ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT 5924
#define ERROR_CLUSTER_NO_QUORUM 5925
#define ERROR_CLUSTER_INVALID_IPV6_NETWORK 5926
#define ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK 5927
#define ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP 5928
#define ERROR_ENCRYPTION_FAILED 6000
#define ERROR_DECRYPTION_FAILED 6001
#define ERROR_FILE_ENCRYPTED 6002
#define ERROR_NO_RECOVERY_POLICY 6003
#define ERROR_NO_EFS 6004
#define ERROR_WRONG_EFS 6005
#define ERROR_NO_USER_KEYS 6006
#define ERROR_FILE_NOT_ENCRYPTED 6007
#define ERROR_NOT_EXPORT_FORMAT 6008
#define ERROR_FILE_READ_ONLY 6009
#define ERROR_DIR_EFS_DISALLOWED 6010
#define ERROR_EFS_SERVER_NOT_TRUSTED 6011
#define ERROR_BAD_RECOVERY_POLICY 6012
#define ERROR_EFS_ALG_BLOB_TOO_BIG 6013
#define ERROR_VOLUME_NOT_SUPPORT_EFS 6014
#define ERROR_EFS_DISABLED 6015
#define ERROR_EFS_VERSION_NOT_SUPPORT 6016
#define ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE 6017
#define ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER 6018
#define ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE 6019
#define ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE 6020
#define ERROR_CS_ENCRYPTION_FILE_NOT_CSE 6021
#define ERROR_NO_BROWSER_SERVERS_FOUND 6118
#define SCHED_E_SERVICE_NOT_LOCALSYSTEM 6200
#define ERROR_LOG_SECTOR_INVALID 6600
#define ERROR_LOG_SECTOR_PARITY_INVALID 6601
#define ERROR_LOG_SECTOR_REMAPPED 6602
#define ERROR_LOG_BLOCK_INCOMPLETE 6603
#define ERROR_LOG_INVALID_RANGE 6604
#define ERROR_LOG_BLOCKS_EXHAUSTED 6605
#define ERROR_LOG_READ_CONTEXT_INVALID 6606
#define ERROR_LOG_RESTART_INVALID 6607
#define ERROR_LOG_BLOCK_VERSION 6608
#define ERROR_LOG_BLOCK_INVALID 6609
#define ERROR_LOG_READ_MODE_INVALID 6610
#define ERROR_LOG_NO_RESTART 6611
#define ERROR_LOG_METADATA_CORRUPT 6612
#define ERROR_LOG_METADATA_INVALID 6613
#define ERROR_LOG_METADATA_INCONSISTENT 6614
#define ERROR_LOG_RESERVATION_INVALID 6615
#define ERROR_LOG_CANT_DELETE 6616
#define ERROR_LOG_CONTAINER_LIMIT_EXCEEDED 6617
#define ERROR_LOG_START_OF_LOG 6618
#define ERROR_LOG_POLICY_ALREADY_INSTALLED 6619
#define ERROR_LOG_POLICY_NOT_INSTALLED 6620
#define ERROR_LOG_POLICY_INVALID 6621
#define ERROR_LOG_POLICY_CONFLICT 6622
#define ERROR_LOG_PINNED_ARCHIVE_TAIL 6623
#define ERROR_LOG_RECORD_NONEXISTENT 6624
#define ERROR_LOG_RECORDS_RESERVED_INVALID 6625
#define ERROR_LOG_SPACE_RESERVED_INVALID 6626
#define ERROR_LOG_TAIL_INVALID 6627
#define ERROR_LOG_FULL 6628
#define ERROR_COULD_NOT_RESIZE_LOG 6629
#define ERROR_LOG_MULTIPLEXED 6630
#define ERROR_LOG_DEDICATED 6631
#define ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS 6632
#define ERROR_LOG_ARCHIVE_IN_PROGRESS 6633
#define ERROR_LOG_EPHEMERAL 6634
#define ERROR_LOG_NOT_ENOUGH_CONTAINERS 6635
#define ERROR_LOG_CLIENT_ALREADY_REGISTERED 6636
#define ERROR_LOG_CLIENT_NOT_REGISTERED 6637
#define ERROR_LOG_FULL_HANDLER_IN_PROGRESS 6638
#define ERROR_LOG_CONTAINER_READ_FAILED 6639
#define ERROR_LOG_CONTAINER_WRITE_FAILED 6640
#define ERROR_LOG_CONTAINER_OPEN_FAILED 6641
#define ERROR_LOG_CONTAINER_STATE_INVALID 6642
#define ERROR_LOG_STATE_INVALID 6643
#define ERROR_LOG_PINNED 6644
#define ERROR_LOG_METADATA_FLUSH_FAILED 6645
#define ERROR_LOG_INCONSISTENT_SECURITY 6646
#define ERROR_LOG_APPENDED_FLUSH_FAILED 6647
#define ERROR_LOG_PINNED_RESERVATION 6648
#define ERROR_INVALID_TRANSACTION 6700
#define ERROR_TRANSACTION_NOT_ACTIVE 6701
#define ERROR_TRANSACTION_REQUEST_NOT_VALID 6702
#define ERROR_TRANSACTION_NOT_REQUESTED 6703
#define ERROR_TRANSACTION_ALREADY_ABORTED 6704
#define ERROR_TRANSACTION_ALREADY_COMMITTED 6705
#define ERROR_TM_INITIALIZATION_FAILED 6706
#define ERROR_RESOURCEMANAGER_READ_ONLY 6707
#define ERROR_TRANSACTION_NOT_JOINED 6708
#define ERROR_TRANSACTION_SUPERIOR_EXISTS 6709
#define ERROR_CRM_PROTOCOL_ALREADY_EXISTS 6710
#define ERROR_TRANSACTION_PROPAGATION_FAILED 6711
#define ERROR_CRM_PROTOCOL_NOT_FOUND 6712
#define ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER 6713
#define ERROR_CURRENT_TRANSACTION_NOT_VALID 6714
#define ERROR_TRANSACTION_NOT_FOUND 6715
#define ERROR_RESOURCEMANAGER_NOT_FOUND 6716
#define ERROR_ENLISTMENT_NOT_FOUND 6717
#define ERROR_TRANSACTIONMANAGER_NOT_FOUND 6718
#define ERROR_TRANSACTIONMANAGER_NOT_ONLINE 6719
#define ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION 6720
#define ERROR_TRANSACTIONAL_CONFLICT 6800
#define ERROR_RM_NOT_ACTIVE 6801
#define ERROR_RM_METADATA_CORRUPT 6802
#define ERROR_DIRECTORY_NOT_RM 6803
#define ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE 6805
#define ERROR_LOG_RESIZE_INVALID_SIZE 6806
#define ERROR_OBJECT_NO_LONGER_EXISTS 6807
#define ERROR_STREAM_MINIVERSION_NOT_FOUND 6808
#define ERROR_STREAM_MINIVERSION_NOT_VALID 6809
#define ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION 6810
#define ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT 6811
#define ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS 6812
#define ERROR_REMOTE_FILE_VERSION_MISMATCH 6814
#define ERROR_HANDLE_NO_LONGER_VALID 6815
#define ERROR_NO_TXF_METADATA 6816
#define ERROR_LOG_CORRUPTION_DETECTED 6817
#define ERROR_CANT_RECOVER_WITH_HANDLE_OPEN 6818
#define ERROR_RM_DISCONNECTED 6819
#define ERROR_ENLISTMENT_NOT_SUPERIOR 6820
#define ERROR_RECOVERY_NOT_NEEDED 6821
#define ERROR_RM_ALREADY_STARTED 6822
#define ERROR_FILE_IDENTITY_NOT_PERSISTENT 6823
#define ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY 6824
#define ERROR_CANT_CROSS_RM_BOUNDARY 6825
#define ERROR_TXF_DIR_NOT_EMPTY 6826
#define ERROR_INDOUBT_TRANSACTIONS_EXIST 6827
#define ERROR_TM_VOLATILE 6828
#define ERROR_ROLLBACK_TIMER_EXPIRED 6829
#define ERROR_TXF_ATTRIBUTE_CORRUPT 6830
#define ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION 6831
#define ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED 6832
#define ERROR_LOG_GROWTH_FAILED 6833
#define ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE 6834
#define ERROR_TXF_METADATA_ALREADY_PRESENT 6835
#define ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET 6836
#define ERROR_TRANSACTION_REQUIRED_PROMOTION 6837
#define ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION 6838
#define ERROR_TRANSACTIONS_NOT_FROZEN 6839
#define ERROR_TRANSACTION_FREEZE_IN_PROGRESS 6840
#define ERROR_NOT_SNAPSHOT_VOLUME 6841
#define ERROR_NO_SAVEPOINT_WITH_OPEN_FILES 6842
#define ERROR_DATA_LOST_REPAIR 6843
#define ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION 6844
#define ERROR_TM_IDENTITY_MISMATCH 6845
#define ERROR_FLOATED_SECTION 6846
#define ERROR_CANNOT_ACCEPT_TRANSACTED_WORK 6847
#define ERROR_CANNOT_ABORT_TRANSACTIONS 6848
#define ERROR_CTX_WINSTATION_NAME_INVALID 7001
#define ERROR_CTX_INVALID_PD 7002
#define ERROR_CTX_PD_NOT_FOUND 7003
#define ERROR_CTX_WD_NOT_FOUND 7004
#define ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY 7005
#define ERROR_CTX_SERVICE_NAME_COLLISION 7006
#define ERROR_CTX_CLOSE_PENDING 7007
#define ERROR_CTX_NO_OUTBUF 7008
#define ERROR_CTX_MODEM_INF_NOT_FOUND 7009
#define ERROR_CTX_INVALID_MODEMNAME 7010
#define ERROR_CTX_MODEM_RESPONSE_ERROR 7011
#define ERROR_CTX_MODEM_RESPONSE_TIMEOUT 7012
#define ERROR_CTX_MODEM_RESPONSE_NO_CARRIER 7013
#define ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE 7014
#define ERROR_CTX_MODEM_RESPONSE_BUSY 7015
#define ERROR_CTX_MODEM_RESPONSE_VOICE 7016
#define ERROR_CTX_TD_ERROR 7017
#define ERROR_CTX_WINSTATION_NOT_FOUND 7022
#define ERROR_CTX_WINSTATION_ALREADY_EXISTS 7023
#define ERROR_CTX_WINSTATION_BUSY 7024
#define ERROR_CTX_BAD_VIDEO_MODE 7025
#define ERROR_CTX_GRAPHICS_INVALID 7035
#define ERROR_CTX_LOGON_DISABLED 7037
#define ERROR_CTX_NOT_CONSOLE 7038
#define ERROR_CTX_CLIENT_QUERY_TIMEOUT 7040
#define ERROR_CTX_CONSOLE_DISCONNECT 7041
#define ERROR_CTX_CONSOLE_CONNECT 7042
#define ERROR_CTX_SHADOW_DENIED 7044
#define ERROR_CTX_WINSTATION_ACCESS_DENIED 7045
#define ERROR_CTX_INVALID_WD 7049
#define ERROR_CTX_SHADOW_INVALID 7050
#define ERROR_CTX_SHADOW_DISABLED 7051
#define ERROR_CTX_CLIENT_LICENSE_IN_USE 7052
#define ERROR_CTX_CLIENT_LICENSE_NOT_SET 7053
#define ERROR_CTX_LICENSE_NOT_AVAILABLE 7054
#define ERROR_CTX_LICENSE_CLIENT_INVALID 7055
#define ERROR_CTX_LICENSE_EXPIRED 7056
#define ERROR_CTX_SHADOW_NOT_RUNNING 7057
#define ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE 7058
#define ERROR_ACTIVATION_COUNT_EXCEEDED 7059
#define ERROR_CTX_WINSTATIONS_DISABLED 7060
#define ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED 7061
#define ERROR_CTX_SESSION_IN_USE 7062
#define ERROR_CTX_NO_FORCE_LOGOFF 7063
#define ERROR_CTX_ACCOUNT_RESTRICTION 7064
#define ERROR_RDP_PROTOCOL_ERROR 7065
#define ERROR_CTX_CDM_CONNECT 7066
#define ERROR_CTX_CDM_DISCONNECT 7067
#define ERROR_CTX_SECURITY_LAYER_ERROR 7068
#define ERROR_TS_INCOMPATIBLE_SESSIONS 7069
#define FRS_ERR_INVALID_API_SEQUENCE 8001
#define FRS_ERR_STARTING_SERVICE 8002
#define FRS_ERR_STOPPING_SERVICE 8003
#define FRS_ERR_INTERNAL_API 8004
#define FRS_ERR_INTERNAL 8005
#define FRS_ERR_SERVICE_COMM 8006
#define FRS_ERR_INSUFFICIENT_PRIV 8007
#define FRS_ERR_AUTHENTICATION 8008
#define FRS_ERR_PARENT_INSUFFICIENT_PRIV 8009
#define FRS_ERR_PARENT_AUTHENTICATION 8010
#define FRS_ERR_CHILD_TO_PARENT_COMM 8011
#define FRS_ERR_PARENT_TO_CHILD_COMM 8012
#define FRS_ERR_SYSVOL_POPULATE 8013
#define FRS_ERR_SYSVOL_POPULATE_TIMEOUT 8014
#define FRS_ERR_SYSVOL_IS_BUSY 8015
#define FRS_ERR_SYSVOL_DEMOTE 8016
#define FRS_ERR_INVALID_SERVICE_PARAMETER 8017
#define ERROR_DS_NOT_INSTALLED 8200
#define ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY 8201
#define ERROR_DS_NO_ATTRIBUTE_OR_VALUE 8202
#define ERROR_DS_INVALID_ATTRIBUTE_SYNTAX 8203
#define ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED 8204
#define ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS 8205
#define ERROR_DS_BUSY 8206
#define ERROR_DS_UNAVAILABLE 8207
#define ERROR_DS_NO_RIDS_ALLOCATED 8208
#define ERROR_DS_NO_MORE_RIDS 8209
#define ERROR_DS_INCORRECT_ROLE_OWNER 8210
#define ERROR_DS_RIDMGR_INIT_ERROR 8211
#define ERROR_DS_OBJ_CLASS_VIOLATION 8212
#define ERROR_DS_CANT_ON_NON_LEAF 8213
#define ERROR_DS_CANT_ON_RDN 8214
#define ERROR_DS_CANT_MOD_OBJ_CLASS 8215
#define ERROR_DS_CROSS_DOM_MOVE_ERROR 8216
#define ERROR_DS_GC_NOT_AVAILABLE 8217
#define ERROR_SHARED_POLICY 8218
#define ERROR_POLICY_OBJECT_NOT_FOUND 8219
#define ERROR_POLICY_ONLY_IN_DS 8220
#define ERROR_PROMOTION_ACTIVE 8221
#define ERROR_NO_PROMOTION_ACTIVE 8222
#define ERROR_DS_OPERATIONS_ERROR 8224
#define ERROR_DS_PROTOCOL_ERROR 8225
#define ERROR_DS_TIMELIMIT_EXCEEDED 8226
#define ERROR_DS_SIZELIMIT_EXCEEDED 8227
#define ERROR_DS_ADMIN_LIMIT_EXCEEDED 8228
#define ERROR_DS_COMPARE_FALSE 8229
#define ERROR_DS_COMPARE_TRUE 8230
#define ERROR_DS_AUTH_METHOD_NOT_SUPPORTED 8231
#define ERROR_DS_STRONG_AUTH_REQUIRED 8232
#define ERROR_DS_INAPPROPRIATE_AUTH 8233
#define ERROR_DS_AUTH_UNKNOWN 8234
#define ERROR_DS_REFERRAL 8235
#define ERROR_DS_UNAVAILABLE_CRIT_EXTENSION 8236
#define ERROR_DS_CONFIDENTIALITY_REQUIRED 8237
#define ERROR_DS_INAPPROPRIATE_MATCHING 8238
#define ERROR_DS_CONSTRAINT_VIOLATION 8239
#define ERROR_DS_NO_SUCH_OBJECT 8240
#define ERROR_DS_ALIAS_PROBLEM 8241
#define ERROR_DS_INVALID_DN_SYNTAX 8242
#define ERROR_DS_IS_LEAF 8243
#define ERROR_DS_ALIAS_DEREF_PROBLEM 8244
#define ERROR_DS_UNWILLING_TO_PERFORM 8245
#define ERROR_DS_LOOP_DETECT 8246
#define ERROR_DS_NAMING_VIOLATION 8247
#define ERROR_DS_OBJECT_RESULTS_TOO_LARGE 8248
#define ERROR_DS_AFFECTS_MULTIPLE_DSAS 8249
#define ERROR_DS_SERVER_DOWN 8250
#define ERROR_DS_LOCAL_ERROR 8251
#define ERROR_DS_ENCODING_ERROR 8252
#define ERROR_DS_DECODING_ERROR 8253
#define ERROR_DS_FILTER_UNKNOWN 8254
#define ERROR_DS_PARAM_ERROR 8255
#define ERROR_DS_NOT_SUPPORTED 8256
#define ERROR_DS_NO_RESULTS_RETURNED 8257
#define ERROR_DS_CONTROL_NOT_FOUND 8258
#define ERROR_DS_CLIENT_LOOP 8259
#define ERROR_DS_REFERRAL_LIMIT_EXCEEDED 8260
#define ERROR_DS_SORT_CONTROL_MISSING 8261
#define ERROR_DS_OFFSET_RANGE_ERROR 8262
#define ERROR_DS_ROOT_MUST_BE_NC 8301
#define ERROR_DS_ADD_REPLICA_INHIBITED 8302
#define ERROR_DS_ATT_NOT_DEF_IN_SCHEMA 8303
#define ERROR_DS_MAX_OBJ_SIZE_EXCEEDED 8304
#define ERROR_DS_OBJ_STRING_NAME_EXISTS 8305
#define ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA 8306
#define ERROR_DS_RDN_DOESNT_MATCH_SCHEMA 8307
#define ERROR_DS_NO_REQUESTED_ATTS_FOUND 8308
#define ERROR_DS_USER_BUFFER_TO_SMALL 8309
#define ERROR_DS_ATT_IS_NOT_ON_OBJ 8310
#define ERROR_DS_ILLEGAL_MOD_OPERATION 8311
#define ERROR_DS_OBJ_TOO_LARGE 8312
#define ERROR_DS_BAD_INSTANCE_TYPE 8313
#define ERROR_DS_MASTERDSA_REQUIRED 8314
#define ERROR_DS_OBJECT_CLASS_REQUIRED 8315
#define ERROR_DS_MISSING_REQUIRED_ATT 8316
#define ERROR_DS_ATT_NOT_DEF_FOR_CLASS 8317
#define ERROR_DS_ATT_ALREADY_EXISTS 8318
#define ERROR_DS_CANT_ADD_ATT_VALUES 8320
#define ERROR_DS_SINGLE_VALUE_CONSTRAINT 8321
#define ERROR_DS_RANGE_CONSTRAINT 8322
#define ERROR_DS_ATT_VAL_ALREADY_EXISTS 8323
#define ERROR_DS_CANT_REM_MISSING_ATT 8324
#define ERROR_DS_CANT_REM_MISSING_ATT_VAL 8325
#define ERROR_DS_ROOT_CANT_BE_SUBREF 8326
#define ERROR_DS_NO_CHAINING 8327
#define ERROR_DS_NO_CHAINED_EVAL 8328
#define ERROR_DS_NO_PARENT_OBJECT 8329
#define ERROR_DS_PARENT_IS_AN_ALIAS 8330
#define ERROR_DS_CANT_MIX_MASTER_AND_REPS 8331
#define ERROR_DS_CHILDREN_EXIST 8332
#define ERROR_DS_OBJ_NOT_FOUND 8333
#define ERROR_DS_ALIASED_OBJ_MISSING 8334
#define ERROR_DS_BAD_NAME_SYNTAX 8335
#define ERROR_DS_ALIAS_POINTS_TO_ALIAS 8336
#define ERROR_DS_CANT_DEREF_ALIAS 8337
#define ERROR_DS_OUT_OF_SCOPE 8338
#define ERROR_DS_OBJECT_BEING_REMOVED 8339
#define ERROR_DS_CANT_DELETE_DSA_OBJ 8340
#define ERROR_DS_GENERIC_ERROR 8341
#define ERROR_DS_DSA_MUST_BE_INT_MASTER 8342
#define ERROR_DS_CLASS_NOT_DSA 8343
#define ERROR_DS_INSUFF_ACCESS_RIGHTS 8344
#define ERROR_DS_ILLEGAL_SUPERIOR 8345
#define ERROR_DS_ATTRIBUTE_OWNED_BY_SAM 8346
#define ERROR_DS_NAME_TOO_MANY_PARTS 8347
#define ERROR_DS_NAME_TOO_LONG 8348
#define ERROR_DS_NAME_VALUE_TOO_LONG 8349
#define ERROR_DS_NAME_UNPARSEABLE 8350
#define ERROR_DS_NAME_TYPE_UNKNOWN 8351
#define ERROR_DS_NOT_AN_OBJECT 8352
#define ERROR_DS_SEC_DESC_TOO_SHORT 8353
#define ERROR_DS_SEC_DESC_INVALID 8354
#define ERROR_DS_NO_DELETED_NAME 8355
#define ERROR_DS_SUBREF_MUST_HAVE_PARENT 8356
#define ERROR_DS_NCNAME_MUST_BE_NC 8357
#define ERROR_DS_CANT_ADD_SYSTEM_ONLY 8358
#define ERROR_DS_CLASS_MUST_BE_CONCRETE 8359
#define ERROR_DS_INVALID_DMD 8360
#define ERROR_DS_OBJ_GUID_EXISTS 8361
#define ERROR_DS_NOT_ON_BACKLINK 8362
#define ERROR_DS_NO_CROSSREF_FOR_NC 8363
#define ERROR_DS_SHUTTING_DOWN 8364
#define ERROR_DS_UNKNOWN_OPERATION 8365
#define ERROR_DS_INVALID_ROLE_OWNER 8366
#define ERROR_DS_COULDNT_CONTACT_FSMO 8367
#define ERROR_DS_CROSS_NC_DN_RENAME 8368
#define ERROR_DS_CANT_MOD_SYSTEM_ONLY 8369
#define ERROR_DS_REPLICATOR_ONLY 8370
#define ERROR_DS_OBJ_CLASS_NOT_DEFINED 8371
#define ERROR_DS_OBJ_CLASS_NOT_SUBCLASS 8372
#define ERROR_DS_NAME_REFERENCE_INVALID 8373
#define ERROR_DS_CROSS_REF_EXISTS 8374
#define ERROR_DS_CANT_DEL_MASTER_CROSSREF 8375
#define ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD 8376
#define ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX 8377
#define ERROR_DS_DUP_RDN 8378
#define ERROR_DS_DUP_OID 8379
#define ERROR_DS_DUP_MAPI_ID 8380
#define ERROR_DS_DUP_SCHEMA_ID_GUID 8381
#define ERROR_DS_DUP_LDAP_DISPLAY_NAME 8382
#define ERROR_DS_SEMANTIC_ATT_TEST 8383
#define ERROR_DS_SYNTAX_MISMATCH 8384
#define ERROR_DS_EXISTS_IN_MUST_HAVE 8385
#define ERROR_DS_EXISTS_IN_MAY_HAVE 8386
#define ERROR_DS_NONEXISTENT_MAY_HAVE 8387
#define ERROR_DS_NONEXISTENT_MUST_HAVE 8388
#define ERROR_DS_AUX_CLS_TEST_FAIL 8389
#define ERROR_DS_NONEXISTENT_POSS_SUP 8390
#define ERROR_DS_SUB_CLS_TEST_FAIL 8391
#define ERROR_DS_BAD_RDN_ATT_ID_SYNTAX 8392
#define ERROR_DS_EXISTS_IN_AUX_CLS 8393
#define ERROR_DS_EXISTS_IN_SUB_CLS 8394
#define ERROR_DS_EXISTS_IN_POSS_SUP 8395
#define ERROR_DS_RECALCSCHEMA_FAILED 8396
#define ERROR_DS_TREE_DELETE_NOT_FINISHED 8397
#define ERROR_DS_CANT_DELETE 8398
#define ERROR_DS_ATT_SCHEMA_REQ_ID 8399
#define ERROR_DS_BAD_ATT_SCHEMA_SYNTAX 8400
#define ERROR_DS_CANT_CACHE_ATT 8401
#define ERROR_DS_CANT_CACHE_CLASS 8402
#define ERROR_DS_CANT_REMOVE_ATT_CACHE 8403
#define ERROR_DS_CANT_REMOVE_CLASS_CACHE 8404
#define ERROR_DS_CANT_RETRIEVE_DN 8405
#define ERROR_DS_MISSING_SUPREF 8406
#define ERROR_DS_CANT_RETRIEVE_INSTANCE 8407
#define ERROR_DS_CODE_INCONSISTENCY 8408
#define ERROR_DS_DATABASE_ERROR 8409
#define ERROR_DS_GOVERNSID_MISSING 8410
#define ERROR_DS_MISSING_EXPECTED_ATT 8411
#define ERROR_DS_NCNAME_MISSING_CR_REF 8412
#define ERROR_DS_SECURITY_CHECKING_ERROR 8413
#define ERROR_DS_SCHEMA_NOT_LOADED 8414
#define ERROR_DS_SCHEMA_ALLOC_FAILED 8415
#define ERROR_DS_ATT_SCHEMA_REQ_SYNTAX 8416
#define ERROR_DS_GCVERIFY_ERROR 8417
#define ERROR_DS_DRA_SCHEMA_MISMATCH 8418
#define ERROR_DS_CANT_FIND_DSA_OBJ 8419
#define ERROR_DS_CANT_FIND_EXPECTED_NC 8420
#define ERROR_DS_CANT_FIND_NC_IN_CACHE 8421
#define ERROR_DS_CANT_RETRIEVE_CHILD 8422
#define ERROR_DS_SECURITY_ILLEGAL_MODIFY 8423
#define ERROR_DS_CANT_REPLACE_HIDDEN_REC 8424
#define ERROR_DS_BAD_HIERARCHY_FILE 8425
#define ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED 8426
#define ERROR_DS_CONFIG_PARAM_MISSING 8427
#define ERROR_DS_COUNTING_AB_INDICES_FAILED 8428
#define ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED 8429
#define ERROR_DS_INTERNAL_FAILURE 8430
#define ERROR_DS_UNKNOWN_ERROR 8431
#define ERROR_DS_ROOT_REQUIRES_CLASS_TOP 8432
#define ERROR_DS_REFUSING_FSMO_ROLES 8433
#define ERROR_DS_MISSING_FSMO_SETTINGS 8434
#define ERROR_DS_UNABLE_TO_SURRENDER_ROLES 8435
#define ERROR_DS_DRA_GENERIC 8436
#define ERROR_DS_DRA_INVALID_PARAMETER 8437
#define ERROR_DS_DRA_BUSY 8438
#define ERROR_DS_DRA_BAD_DN 8439
#define ERROR_DS_DRA_BAD_NC 8440
#define ERROR_DS_DRA_DN_EXISTS 8441
#define ERROR_DS_DRA_INTERNAL_ERROR 8442
#define ERROR_DS_DRA_INCONSISTENT_DIT 8443
#define ERROR_DS_DRA_CONNECTION_FAILED 8444
#define ERROR_DS_DRA_BAD_INSTANCE_TYPE 8445
#define ERROR_DS_DRA_OUT_OF_MEM 8446
#define ERROR_DS_DRA_MAIL_PROBLEM 8447
#define ERROR_DS_DRA_REF_ALREADY_EXISTS 8448
#define ERROR_DS_DRA_REF_NOT_FOUND 8449
#define ERROR_DS_DRA_OBJ_IS_REP_SOURCE 8450
#define ERROR_DS_DRA_DB_ERROR 8451
#define ERROR_DS_DRA_NO_REPLICA 8452
#define ERROR_DS_DRA_ACCESS_DENIED 8453
#define ERROR_DS_DRA_NOT_SUPPORTED 8454
#define ERROR_DS_DRA_RPC_CANCELLED 8455
#define ERROR_DS_DRA_SOURCE_DISABLED 8456
#define ERROR_DS_DRA_SINK_DISABLED 8457
#define ERROR_DS_DRA_NAME_COLLISION 8458
#define ERROR_DS_DRA_SOURCE_REINSTALLED 8459
#define ERROR_DS_DRA_MISSING_PARENT 8460
#define ERROR_DS_DRA_PREEMPTED 8461
#define ERROR_DS_DRA_ABANDON_SYNC 8462
#define ERROR_DS_DRA_SHUTDOWN 8463
#define ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET 8464
#define ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA 8465
#define ERROR_DS_DRA_EXTN_CONNECTION_FAILED 8466
#define ERROR_DS_INSTALL_SCHEMA_MISMATCH 8467
#define ERROR_DS_DUP_LINK_ID 8468
#define ERROR_DS_NAME_ERROR_RESOLVING 8469
#define ERROR_DS_NAME_ERROR_NOT_FOUND 8470
#define ERROR_DS_NAME_ERROR_NOT_UNIQUE 8471
#define ERROR_DS_NAME_ERROR_NO_MAPPING 8472
#define ERROR_DS_NAME_ERROR_DOMAIN_ONLY 8473
#define ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING 8474
#define ERROR_DS_CONSTRUCTED_ATT_MOD 8475
#define ERROR_DS_WRONG_OM_OBJ_CLASS 8476
#define ERROR_DS_DRA_REPL_PENDING 8477
#define ERROR_DS_DS_REQUIRED 8478
#define ERROR_DS_INVALID_LDAP_DISPLAY_NAME 8479
#define ERROR_DS_NON_BASE_SEARCH 8480
#define ERROR_DS_CANT_RETRIEVE_ATTS 8481
#define ERROR_DS_BACKLINK_WITHOUT_LINK 8482
#define ERROR_DS_EPOCH_MISMATCH 8483
#define ERROR_DS_SRC_NAME_MISMATCH 8484
#define ERROR_DS_SRC_AND_DST_NC_IDENTICAL 8485
#define ERROR_DS_DST_NC_MISMATCH 8486
#define ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC 8487
#define ERROR_DS_SRC_GUID_MISMATCH 8488
#define ERROR_DS_CANT_MOVE_DELETED_OBJECT 8489
#define ERROR_DS_PDC_OPERATION_IN_PROGRESS 8490
#define ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD 8491
#define ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION 8492
#define ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS 8493
#define ERROR_DS_NC_MUST_HAVE_NC_PARENT 8494
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE 8495
#define ERROR_DS_DST_DOMAIN_NOT_NATIVE 8496
#define ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER 8497
#define ERROR_DS_CANT_MOVE_ACCOUNT_GROUP 8498
#define ERROR_DS_CANT_MOVE_RESOURCE_GROUP 8499
#define ERROR_DS_INVALID_SEARCH_FLAG 8500
#define ERROR_DS_NO_TREE_DELETE_ABOVE_NC 8501
#define ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE 8502
#define ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE 8503
#define ERROR_DS_SAM_INIT_FAILURE 8504
#define ERROR_DS_SENSITIVE_GROUP_VIOLATION 8505
#define ERROR_DS_CANT_MOD_PRIMARYGROUPID 8506
#define ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD 8507
#define ERROR_DS_NONSAFE_SCHEMA_CHANGE 8508
#define ERROR_DS_SCHEMA_UPDATE_DISALLOWED 8509
#define ERROR_DS_CANT_CREATE_UNDER_SCHEMA 8510
#define ERROR_DS_INSTALL_NO_SRC_SCH_VERSION 8511
#define ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE 8512
#define ERROR_DS_INVALID_GROUP_TYPE 8513
#define ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN 8514
#define ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN 8515
#define ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER 8516
#define ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER 8517
#define ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER 8518
#define ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER 8519
#define ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER 8520
#define ERROR_DS_HAVE_PRIMARY_MEMBERS 8521
#define ERROR_DS_STRING_SD_CONVERSION_FAILED 8522
#define ERROR_DS_NAMING_MASTER_GC 8523
#define ERROR_DS_DNS_LOOKUP_FAILURE 8524
#define ERROR_DS_COULDNT_UPDATE_SPNS 8525
#define ERROR_DS_CANT_RETRIEVE_SD 8526
#define ERROR_DS_KEY_NOT_UNIQUE 8527
#define ERROR_DS_WRONG_LINKED_ATT_SYNTAX 8528
#define ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD 8529
#define ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY 8530
#define ERROR_DS_CANT_START 8531
#define ERROR_DS_INIT_FAILURE 8532
#define ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION 8533
#define ERROR_DS_SOURCE_DOMAIN_IN_FOREST 8534
#define ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST 8535
#define ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED 8536
#define ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN 8537
#define ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER 8538
#define ERROR_DS_SRC_SID_EXISTS_IN_FOREST 8539
#define ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH 8540
#define ERROR_SAM_INIT_FAILURE 8541
#define ERROR_DS_DRA_SCHEMA_INFO_SHIP 8542
#define ERROR_DS_DRA_SCHEMA_CONFLICT 8543
#define ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT 8544
#define ERROR_DS_DRA_OBJ_NC_MISMATCH 8545
#define ERROR_DS_NC_STILL_HAS_DSAS 8546
#define ERROR_DS_GC_REQUIRED 8547
#define ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY 8548
#define ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS 8549
#define ERROR_DS_CANT_ADD_TO_GC 8550
#define ERROR_DS_NO_CHECKPOINT_WITH_PDC 8551
#define ERROR_DS_SOURCE_AUDITING_NOT_ENABLED 8552
#define ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC 8553
#define ERROR_DS_INVALID_NAME_FOR_SPN 8554
#define ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS 8555
#define ERROR_DS_UNICODEPWD_NOT_IN_QUOTES 8556
#define ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED 8557
#define ERROR_DS_MUST_BE_RUN_ON_DST_DC 8558
#define ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER 8559
#define ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ 8560
#define ERROR_DS_INIT_FAILURE_CONSOLE 8561
#define ERROR_DS_SAM_INIT_FAILURE_CONSOLE 8562
#define ERROR_DS_FOREST_VERSION_TOO_HIGH 8563
#define ERROR_DS_DOMAIN_VERSION_TOO_HIGH 8564
#define ERROR_DS_FOREST_VERSION_TOO_LOW 8565
#define ERROR_DS_DOMAIN_VERSION_TOO_LOW 8566
#define ERROR_DS_INCOMPATIBLE_VERSION 8567
#define ERROR_DS_LOW_DSA_VERSION 8568
#define ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN 8569
#define ERROR_DS_NOT_SUPPORTED_SORT_ORDER 8570
#define ERROR_DS_NAME_NOT_UNIQUE 8571
#define ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 8572
#define ERROR_DS_OUT_OF_VERSION_STORE 8573
#define ERROR_DS_INCOMPATIBLE_CONTROLS_USED 8574
#define ERROR_DS_NO_REF_DOMAIN 8575
#define ERROR_DS_RESERVED_LINK_ID 8576
#define ERROR_DS_LINK_ID_NOT_AVAILABLE 8577
#define ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER 8578
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE 8579
#define ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC 8580
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG 8581
#define ERROR_DS_MODIFYDN_WRONG_GRANDPARENT 8582
#define ERROR_DS_NAME_ERROR_TRUST_REFERRAL 8583
#define ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER 8584
#define ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD 8585
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 8586
#define ERROR_DS_THREAD_LIMIT_EXCEEDED 8587
#define ERROR_DS_NOT_CLOSEST 8588
#define ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF 8589
#define ERROR_DS_SINGLE_USER_MODE_FAILED 8590
#define ERROR_DS_NTDSCRIPT_SYNTAX_ERROR 8591
#define ERROR_DS_NTDSCRIPT_PROCESS_ERROR 8592
#define ERROR_DS_DIFFERENT_REPL_EPOCHS 8593
#define ERROR_DS_DRS_EXTENSIONS_CHANGED 8594
#define ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR 8595
#define ERROR_DS_NO_MSDS_INTID 8596
#define ERROR_DS_DUP_MSDS_INTID 8597
#define ERROR_DS_EXISTS_IN_RDNATTID 8598
#define ERROR_DS_AUTHORIZATION_FAILED 8599
#define ERROR_DS_INVALID_SCRIPT 8600
#define ERROR_DS_REMOTE_CROSSREF_OP_FAILED 8601
#define ERROR_DS_CROSS_REF_BUSY 8602
#define ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN 8603
#define ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC 8604
#define ERROR_DS_DUPLICATE_ID_FOUND 8605
#define ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT 8606
#define ERROR_DS_GROUP_CONVERSION_ERROR 8607
#define ERROR_DS_CANT_MOVE_APP_BASIC_GROUP 8608
#define ERROR_DS_CANT_MOVE_APP_QUERY_GROUP 8609
#define ERROR_DS_ROLE_NOT_VERIFIED 8610
#define ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL 8611
#define ERROR_DS_DOMAIN_RENAME_IN_PROGRESS 8612
#define ERROR_DS_EXISTING_AD_CHILD_NC 8613
#define ERROR_DS_REPL_LIFETIME_EXCEEDED 8614
#define ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER 8615
#define ERROR_DS_LDAP_SEND_QUEUE_FULL 8616
#define ERROR_DS_DRA_OUT_SCHEDULE_WINDOW 8617
#define ERROR_DS_POLICY_NOT_KNOWN 8618
#define ERROR_NO_SITE_SETTINGS_OBJECT 8619
#define ERROR_NO_SECRETS 8620
#define ERROR_NO_WRITABLE_DC_FOUND 8621
#define ERROR_DS_NO_SERVER_OBJECT 8622
#define ERROR_DS_NO_NTDSA_OBJECT 8623
#define ERROR_DS_NON_ASQ_SEARCH 8624
#define ERROR_DS_AUDIT_FAILURE 8625
#define ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE 8626
#define ERROR_DS_INVALID_SEARCH_FLAG_TUPLE 8627
#define DNS_ERROR_RCODE_FORMAT_ERROR 9001
#define DNS_ERROR_RCODE_SERVER_FAILURE 9002
#define DNS_ERROR_RCODE_NAME_ERROR 9003
#define DNS_ERROR_RCODE_NOT_IMPLEMENTED 9004
#define DNS_ERROR_RCODE_REFUSED 9005
#define DNS_ERROR_RCODE_YXDOMAIN 9006
#define DNS_ERROR_RCODE_YXRRSET 9007
#define DNS_ERROR_RCODE_NXRRSET 9008
#define DNS_ERROR_RCODE_NOTAUTH 9009
#define DNS_ERROR_RCODE_NOTZONE 9010
#define DNS_ERROR_RCODE_BADSIG 9016
#define DNS_ERROR_RCODE_BADKEY 9017
#define DNS_ERROR_RCODE_BADTIME 9018
#define DNS_INFO_NO_RECORDS 9501
#define DNS_ERROR_BAD_PACKET 9502
#define DNS_ERROR_NO_PACKET 9503
#define DNS_ERROR_RCODE 9504
#define DNS_ERROR_UNSECURE_PACKET 9505
#define DNS_ERROR_INVALID_TYPE 9551
#define DNS_ERROR_INVALID_IP_ADDRESS 9552
#define DNS_ERROR_INVALID_PROPERTY 9553
#define DNS_ERROR_TRY_AGAIN_LATER 9554
#define DNS_ERROR_NOT_UNIQUE 9555
#define DNS_ERROR_NON_RFC_NAME 9556
#define DNS_STATUS_FQDN 9557
#define DNS_STATUS_DOTTED_NAME 9558
#define DNS_STATUS_SINGLE_PART_NAME 9559
#define DNS_ERROR_INVALID_NAME_CHAR 9560
#define DNS_ERROR_NUMERIC_NAME 9561
#define DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER 9562
#define DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION 9563
#define DNS_ERROR_CANNOT_FIND_ROOT_HINTS 9564
#define DNS_ERROR_INCONSISTENT_ROOT_HINTS 9565
#define DNS_ERROR_DWORD_VALUE_TOO_SMALL 9566
#define DNS_ERROR_DWORD_VALUE_TOO_LARGE 9567
#define DNS_ERROR_BACKGROUND_LOADING 9568
#define DNS_ERROR_NOT_ALLOWED_ON_RODC 9569
#define DNS_ERROR_ZONE_DOES_NOT_EXIST 9601
#define DNS_ERROR_NO_ZONE_INFO 9602
#define DNS_ERROR_INVALID_ZONE_OPERATION 9603
#define DNS_ERROR_ZONE_CONFIGURATION_ERROR 9604
#define DNS_ERROR_ZONE_HAS_NO_SOA_RECORD 9605
#define DNS_ERROR_ZONE_HAS_NO_NS_RECORDS 9606
#define DNS_ERROR_ZONE_LOCKED 9607
#define DNS_ERROR_ZONE_CREATION_FAILED 9608
#define DNS_ERROR_ZONE_ALREADY_EXISTS 9609
#define DNS_ERROR_AUTOZONE_ALREADY_EXISTS 9610
#define DNS_ERROR_INVALID_ZONE_TYPE 9611
#define DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP 9612
#define DNS_ERROR_ZONE_NOT_SECONDARY 9613
#define DNS_ERROR_NEED_SECONDARY_ADDRESSES 9614
#define DNS_ERROR_WINS_INIT_FAILED 9615
#define DNS_ERROR_NEED_WINS_SERVERS 9616
#define DNS_ERROR_NBSTAT_INIT_FAILED 9617
#define DNS_ERROR_SOA_DELETE_INVALID 9618
#define DNS_ERROR_FORWARDER_ALREADY_EXISTS 9619
#define DNS_ERROR_ZONE_REQUIRES_MASTER_IP 9620
#define DNS_ERROR_ZONE_IS_SHUTDOWN 9621
#define DNS_ERROR_PRIMARY_REQUIRES_DATAFILE 9651
#define DNS_ERROR_INVALID_DATAFILE_NAME 9652
#define DNS_ERROR_DATAFILE_OPEN_FAILURE 9653
#define DNS_ERROR_FILE_WRITEBACK_FAILED 9654
#define DNS_ERROR_DATAFILE_PARSING 9655
#define DNS_ERROR_RECORD_DOES_NOT_EXIST 9701
#define DNS_ERROR_RECORD_FORMAT 9702
#define DNS_ERROR_NODE_CREATION_FAILED 9703
#define DNS_ERROR_UNKNOWN_RECORD_TYPE 9704
#define DNS_ERROR_RECORD_TIMED_OUT 9705
#define DNS_ERROR_NAME_NOT_IN_ZONE 9706
#define DNS_ERROR_CNAME_LOOP 9707
#define DNS_ERROR_NODE_IS_CNAME 9708
#define DNS_ERROR_CNAME_COLLISION 9709
#define DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT 9710
#define DNS_ERROR_RECORD_ALREADY_EXISTS 9711
#define DNS_ERROR_SECONDARY_DATA 9712
#define DNS_ERROR_NO_CREATE_CACHE_DATA 9713
#define DNS_ERROR_NAME_DOES_NOT_EXIST 9714
#define DNS_WARNING_PTR_CREATE_FAILED 9715
#define DNS_WARNING_DOMAIN_UNDELETED 9716
#define DNS_ERROR_DS_UNAVAILABLE 9717
#define DNS_ERROR_DS_ZONE_ALREADY_EXISTS 9718
#define DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE 9719
#define DNS_INFO_AXFR_COMPLETE 9751
#define DNS_ERROR_AXFR 9752
#define DNS_INFO_ADDED_LOCAL_WINS 9753
#define DNS_STATUS_CONTINUE_NEEDED 9801
#define DNS_ERROR_NO_TCPIP 9851
#define DNS_ERROR_NO_DNS_SERVERS 9852
#define DNS_ERROR_DP_DOES_NOT_EXIST 9901
#define DNS_ERROR_DP_ALREADY_EXISTS 9902
#define DNS_ERROR_DP_NOT_ENLISTED 9903
#define DNS_ERROR_DP_ALREADY_ENLISTED 9904
#define DNS_ERROR_DP_NOT_AVAILABLE 9905
#define DNS_ERROR_DP_FSMO_ERROR 9906
#define WSAEINTR 10004
#define WSAEBADF 10009
#define WSAEACCES 10013
#define WSAEFAULT 10014
#define WSAEINVAL 10022
#define WSAEMFILE 10024
#define WSAEWOULDBLOCK 10035
#define WSAEINPROGRESS 10036
#define WSAEALREADY 10037
#define WSAENOTSOCK 10038
#define WSAEDESTADDRREQ 10039
#define WSAEMSGSIZE 10040
#define WSAEPROTOTYPE 10041
#define WSAENOPROTOOPT 10042
#define WSAEPROTONOSUPPORT 10043
#define WSAESOCKTNOSUPPORT 10044
#define WSAEOPNOTSUPP 10045
#define WSAEPFNOSUPPORT 10046
#define WSAEAFNOSUPPORT 10047
#define WSAEADDRINUSE 10048
#define WSAEADDRNOTAVAIL 10049
#define WSAENETDOWN 10050
#define WSAENETUNREACH 10051
#define WSAENETRESET 10052
#define WSAECONNABORTED 10053
#define WSAECONNRESET 10054
#define WSAENOBUFS 10055
#define WSAEISCONN 10056
#define WSAENOTCONN 10057
#define WSAESHUTDOWN 10058
#define WSAETOOMANYREFS 10059
#define WSAETIMEDOUT 10060
#define WSAECONNREFUSED 10061
#define WSAELOOP 10062
#define WSAENAMETOOLONG 10063
#define WSAEHOSTDOWN 10064
#define WSAEHOSTUNREACH 10065
#define WSAENOTEMPTY 10066
#define WSAEPROCLIM 10067
#define WSAEUSERS 10068
#define WSAEDQUOT 10069
#define WSAESTALE 10070
#define WSAEREMOTE 10071
#define WSASYSNOTREADY 10091
#define WSAVERNOTSUPPORTED 10092
#define WSANOTINITIALISED 10093
#define WSAEDISCON 10101
#define WSAENOMORE 10102
#define WSAECANCELLED 10103
#define WSAEINVALIDPROCTABLE 10104
#define WSAEINVALIDPROVIDER 10105
#define WSAEPROVIDERFAILEDINIT 10106
#define WSASYSCALLFAILURE 10107
#define WSASERVICE_NOT_FOUND 10108
#define WSATYPE_NOT_FOUND 10109
#define WSA_E_NO_MORE 10110
#define WSA_E_CANCELLED 10111
#define WSAEREFUSED 10112
#define WSAHOST_NOT_FOUND 11001
#define WSATRY_AGAIN 11002
#define WSANO_RECOVERY 11003
#define WSANO_DATA 11004
#define WSA_QOS_RECEIVERS 11005
#define WSA_QOS_SENDERS 11006
#define WSA_QOS_NO_SENDERS 11007
#define WSA_QOS_NO_RECEIVERS 11008
#define WSA_QOS_REQUEST_CONFIRMED 11009
#define WSA_QOS_ADMISSION_FAILURE 11010
#define WSA_QOS_POLICY_FAILURE 11011
#define WSA_QOS_BAD_STYLE 11012
#define WSA_QOS_BAD_OBJECT 11013
#define WSA_QOS_TRAFFIC_CTRL_ERROR 11014
#define WSA_QOS_GENERIC_ERROR 11015
#define WSA_QOS_ESERVICETYPE 11016
#define WSA_QOS_EFLOWSPEC 11017
#define WSA_QOS_EPROVSPECBUF 11018
#define WSA_QOS_EFILTERSTYLE 11019
#define WSA_QOS_EFILTERTYPE 11020
#define WSA_QOS_EFILTERCOUNT 11021
#define WSA_QOS_EOBJLENGTH 11022
#define WSA_QOS_EFLOWCOUNT 11023
#define WSA_QOS_EUNKOWNPSOBJ 11024
#define WSA_QOS_EPOLICYOBJ 11025
#define WSA_QOS_EFLOWDESC 11026
#define WSA_QOS_EPSFLOWSPEC 11027
#define WSA_QOS_EPSFILTERSPEC 11028
#define WSA_QOS_ESDMODEOBJ 11029
#define WSA_QOS_ESHAPERATEOBJ 11030
#define WSA_QOS_RESERVED_PETYPE 11031
#define WSA_IPSEC_NAME_POLICY_ERROR 11033
#define ERROR_IPSEC_QM_POLICY_EXISTS 13000
#define ERROR_IPSEC_QM_POLICY_NOT_FOUND 13001
#define ERROR_IPSEC_QM_POLICY_IN_USE 13002
#define ERROR_IPSEC_MM_POLICY_EXISTS 13003
#define ERROR_IPSEC_MM_POLICY_NOT_FOUND 13004
#define ERROR_IPSEC_MM_POLICY_IN_USE 13005
#define ERROR_IPSEC_MM_FILTER_EXISTS 13006
#define ERROR_IPSEC_MM_FILTER_NOT_FOUND 13007
#define ERROR_IPSEC_TRANSPORT_FILTER_EXISTS 13008
#define ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND 13009
#define ERROR_IPSEC_MM_AUTH_EXISTS 13010
#define ERROR_IPSEC_MM_AUTH_NOT_FOUND 13011
#define ERROR_IPSEC_MM_AUTH_IN_USE 13012
#define ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND 13013
#define ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND 13014
#define ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND 13015
#define ERROR_IPSEC_TUNNEL_FILTER_EXISTS 13016
#define ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND 13017
#define ERROR_IPSEC_MM_FILTER_PENDING_DELETION 13018
#define ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION 13019
#define ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION 13020
#define ERROR_IPSEC_MM_POLICY_PENDING_DELETION 13021
#define ERROR_IPSEC_MM_AUTH_PENDING_DELETION 13022
#define ERROR_IPSEC_QM_POLICY_PENDING_DELETION 13023
#define WARNING_IPSEC_MM_POLICY_PRUNED 13024
#define WARNING_IPSEC_QM_POLICY_PRUNED 13025
#define ERROR_IPSEC_IKE_NEG_STATUS_BEGIN 13800
#define ERROR_IPSEC_IKE_AUTH_FAIL 13801
#define ERROR_IPSEC_IKE_ATTRIB_FAIL 13802
#define ERROR_IPSEC_IKE_NEGOTIATION_PENDING 13803
#define ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR 13804
#define ERROR_IPSEC_IKE_TIMED_OUT 13805
#define ERROR_IPSEC_IKE_NO_CERT 13806
#define ERROR_IPSEC_IKE_SA_DELETED 13807
#define ERROR_IPSEC_IKE_SA_REAPED 13808
#define ERROR_IPSEC_IKE_MM_ACQUIRE_DROP 13809
#define ERROR_IPSEC_IKE_QM_ACQUIRE_DROP 13810
#define ERROR_IPSEC_IKE_QUEUE_DROP_MM 13811
#define ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM 13812
#define ERROR_IPSEC_IKE_DROP_NO_RESPONSE 13813
#define ERROR_IPSEC_IKE_MM_DELAY_DROP 13814
#define ERROR_IPSEC_IKE_QM_DELAY_DROP 13815
#define ERROR_IPSEC_IKE_ERROR 13816
#define ERROR_IPSEC_IKE_CRL_FAILED 13817
#define ERROR_IPSEC_IKE_INVALID_KEY_USAGE 13818
#define ERROR_IPSEC_IKE_INVALID_CERT_TYPE 13819
#define ERROR_IPSEC_IKE_NO_PRIVATE_KEY 13820
#define ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY 13821
#define ERROR_IPSEC_IKE_DH_FAIL 13822
#define ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED 13823
#define ERROR_IPSEC_IKE_INVALID_HEADER 13824
#define ERROR_IPSEC_IKE_NO_POLICY 13825
#define ERROR_IPSEC_IKE_INVALID_SIGNATURE 13826
#define ERROR_IPSEC_IKE_KERBEROS_ERROR 13827
#define ERROR_IPSEC_IKE_NO_PUBLIC_KEY 13828
#define ERROR_IPSEC_IKE_PROCESS_ERR 13829
#define ERROR_IPSEC_IKE_PROCESS_ERR_SA 13830
#define ERROR_IPSEC_IKE_PROCESS_ERR_PROP 13831
#define ERROR_IPSEC_IKE_PROCESS_ERR_TRANS 13832
#define ERROR_IPSEC_IKE_PROCESS_ERR_KE 13833
#define ERROR_IPSEC_IKE_PROCESS_ERR_ID 13834
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT 13835
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ 13836
#define ERROR_IPSEC_IKE_PROCESS_ERR_HASH 13837
#define ERROR_IPSEC_IKE_PROCESS_ERR_SIG 13838
#define ERROR_IPSEC_IKE_PROCESS_ERR_NONCE 13839
#define ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY 13840
#define ERROR_IPSEC_IKE_PROCESS_ERR_DELETE 13841
#define ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR 13842
#define ERROR_IPSEC_IKE_INVALID_PAYLOAD 13843
#define ERROR_IPSEC_IKE_LOAD_SOFT_SA 13844
#define ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN 13845
#define ERROR_IPSEC_IKE_INVALID_COOKIE 13846
#define ERROR_IPSEC_IKE_NO_PEER_CERT 13847
#define ERROR_IPSEC_IKE_PEER_CRL_FAILED 13848
#define ERROR_IPSEC_IKE_POLICY_CHANGE 13849
#define ERROR_IPSEC_IKE_NO_MM_POLICY 13850
#define ERROR_IPSEC_IKE_NOTCBPRIV 13851
#define ERROR_IPSEC_IKE_SECLOADFAIL 13852
#define ERROR_IPSEC_IKE_FAILSSPINIT 13853
#define ERROR_IPSEC_IKE_FAILQUERYSSP 13854
#define ERROR_IPSEC_IKE_SRVACQFAIL 13855
#define ERROR_IPSEC_IKE_SRVQUERYCRED 13856
#define ERROR_IPSEC_IKE_GETSPIFAIL 13857
#define ERROR_IPSEC_IKE_INVALID_FILTER 13858
#define ERROR_IPSEC_IKE_OUT_OF_MEMORY 13859
#define ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED 13860
#define ERROR_IPSEC_IKE_INVALID_POLICY 13861
#define ERROR_IPSEC_IKE_UNKNOWN_DOI 13862
#define ERROR_IPSEC_IKE_INVALID_SITUATION 13863
#define ERROR_IPSEC_IKE_DH_FAILURE 13864
#define ERROR_IPSEC_IKE_INVALID_GROUP 13865
#define ERROR_IPSEC_IKE_ENCRYPT 13866
#define ERROR_IPSEC_IKE_DECRYPT 13867
#define ERROR_IPSEC_IKE_POLICY_MATCH 13868
#define ERROR_IPSEC_IKE_UNSUPPORTED_ID 13869
#define ERROR_IPSEC_IKE_INVALID_HASH 13870
#define ERROR_IPSEC_IKE_INVALID_HASH_ALG 13871
#define ERROR_IPSEC_IKE_INVALID_HASH_SIZE 13872
#define ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG 13873
#define ERROR_IPSEC_IKE_INVALID_AUTH_ALG 13874
#define ERROR_IPSEC_IKE_INVALID_SIG 13875
#define ERROR_IPSEC_IKE_LOAD_FAILED 13876
#define ERROR_IPSEC_IKE_RPC_DELETE 13877
#define ERROR_IPSEC_IKE_BENIGN_REINIT 13878
#define ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY 13879
#define ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION 13880
#define ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN 13881
#define ERROR_IPSEC_IKE_MM_LIMIT 13882
#define ERROR_IPSEC_IKE_NEGOTIATION_DISABLED 13883
#define ERROR_IPSEC_IKE_QM_LIMIT 13884
#define ERROR_IPSEC_IKE_MM_EXPIRED 13885
#define ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID 13886
#define ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH 13887
#define ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID 13888
#define ERROR_IPSEC_IKE_INVALID_UMATTS 13889
#define ERROR_IPSEC_IKE_DOS_COOKIE_SENT 13890
#define ERROR_IPSEC_IKE_SHUTTING_DOWN 13891
#define ERROR_IPSEC_IKE_CGA_AUTH_FAILED 13892
#define ERROR_IPSEC_IKE_PROCESS_ERR_NATOA 13893
#define ERROR_IPSEC_IKE_INVALID_MM_FOR_QM 13894
#define ERROR_IPSEC_IKE_QM_EXPIRED 13895
#define ERROR_IPSEC_IKE_TOO_MANY_FILTERS 13896
#define ERROR_IPSEC_IKE_NEG_STATUS_END 13897
#define ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL 13898
#define ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE 13899
#define ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING 13900
#define ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING 13901
#define ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS 13902
#define ERROR_IPSEC_IKE_RATELIMIT_DROP 13903
#define ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE 13904
#define ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE 13905
#define ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE 13906
#define ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY 13907
#define ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE 13908
#define ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END 13909
#define ERROR_IPSEC_BAD_SPI 13910
#define ERROR_IPSEC_SA_LIFETIME_EXPIRED 13911
#define ERROR_IPSEC_WRONG_SA 13912
#define ERROR_IPSEC_REPLAY_CHECK_FAILED 13913
#define ERROR_IPSEC_INVALID_PACKET 13914
#define ERROR_IPSEC_INTEGRITY_CHECK_FAILED 13915
#define ERROR_IPSEC_CLEAR_TEXT_DROP 13916
#define ERROR_IPSEC_AUTH_FIREWALL_DROP 13917
#define ERROR_IPSEC_THROTTLE_DROP 13918
#define ERROR_IPSEC_DOSP_BLOCK 13925
#define ERROR_IPSEC_DOSP_RECEIVED_MULTICAST 13926
#define ERROR_IPSEC_DOSP_INVALID_PACKET 13927
#define ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED 13928
#define ERROR_IPSEC_DOSP_MAX_ENTRIES 13929
#define ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED 13930
#define ERROR_IPSEC_DOSP_NOT_INSTALLED 13931
#define ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES 13932
#define ERROR_SXS_SECTION_NOT_FOUND 14000
#define ERROR_SXS_CANT_GEN_ACTCTX 14001
#define ERROR_SXS_INVALID_ACTCTXDATA_FORMAT 14002
#define ERROR_SXS_ASSEMBLY_NOT_FOUND 14003
#define ERROR_SXS_MANIFEST_FORMAT_ERROR 14004
#define ERROR_SXS_MANIFEST_PARSE_ERROR 14005
#define ERROR_SXS_ACTIVATION_CONTEXT_DISABLED 14006
#define ERROR_SXS_KEY_NOT_FOUND 14007
#define ERROR_SXS_VERSION_CONFLICT 14008
#define ERROR_SXS_WRONG_SECTION_TYPE 14009
#define ERROR_SXS_THREAD_QUERIES_DISABLED 14010
#define ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET 14011
#define ERROR_SXS_UNKNOWN_ENCODING_GROUP 14012
#define ERROR_SXS_UNKNOWN_ENCODING 14013
#define ERROR_SXS_INVALID_XML_NAMESPACE_URI 14014
#define ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED 14015
#define ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED 14016
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE 14017
#define ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE 14018
#define ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE 14019
#define ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT 14020
#define ERROR_SXS_DUPLICATE_DLL_NAME 14021
#define ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME 14022
#define ERROR_SXS_DUPLICATE_CLSID 14023
#define ERROR_SXS_DUPLICATE_IID 14024
#define ERROR_SXS_DUPLICATE_TLBID 14025
#define ERROR_SXS_DUPLICATE_PROGID 14026
#define ERROR_SXS_DUPLICATE_ASSEMBLY_NAME 14027
#define ERROR_SXS_FILE_HASH_MISMATCH 14028
#define ERROR_SXS_POLICY_PARSE_ERROR 14029
#define ERROR_SXS_XML_E_MISSINGQUOTE 14030
#define ERROR_SXS_XML_E_COMMENTSYNTAX 14031
#define ERROR_SXS_XML_E_BADSTARTNAMECHAR 14032
#define ERROR_SXS_XML_E_BADNAMECHAR 14033
#define ERROR_SXS_XML_E_BADCHARINSTRING 14034
#define ERROR_SXS_XML_E_XMLDECLSYNTAX 14035
#define ERROR_SXS_XML_E_BADCHARDATA 14036
#define ERROR_SXS_XML_E_MISSINGWHITESPACE 14037
#define ERROR_SXS_XML_E_EXPECTINGTAGEND 14038
#define ERROR_SXS_XML_E_MISSINGSEMICOLON 14039
#define ERROR_SXS_XML_E_UNBALANCEDPAREN 14040
#define ERROR_SXS_XML_E_INTERNALERROR 14041
#define ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE 14042
#define ERROR_SXS_XML_E_INCOMPLETE_ENCODING 14043
#define ERROR_SXS_XML_E_MISSING_PAREN 14044
#define ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE 14045
#define ERROR_SXS_XML_E_MULTIPLE_COLONS 14046
#define ERROR_SXS_XML_E_INVALID_DECIMAL 14047
#define ERROR_SXS_XML_E_INVALID_HEXIDECIMAL 14048
#define ERROR_SXS_XML_E_INVALID_UNICODE 14049
#define ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK 14050
#define ERROR_SXS_XML_E_UNEXPECTEDENDTAG 14051
#define ERROR_SXS_XML_E_UNCLOSEDTAG 14052
#define ERROR_SXS_XML_E_DUPLICATEATTRIBUTE 14053
#define ERROR_SXS_XML_E_MULTIPLEROOTS 14054
#define ERROR_SXS_XML_E_INVALIDATROOTLEVEL 14055
#define ERROR_SXS_XML_E_BADXMLDECL 14056
#define ERROR_SXS_XML_E_MISSINGROOT 14057
#define ERROR_SXS_XML_E_UNEXPECTEDEOF 14058
#define ERROR_SXS_XML_E_BADPEREFINSUBSET 14059
#define ERROR_SXS_XML_E_UNCLOSEDSTARTTAG 14060
#define ERROR_SXS_XML_E_UNCLOSEDENDTAG 14061
#define ERROR_SXS_XML_E_UNCLOSEDSTRING 14062
#define ERROR_SXS_XML_E_UNCLOSEDCOMMENT 14063
#define ERROR_SXS_XML_E_UNCLOSEDDECL 14064
#define ERROR_SXS_XML_E_UNCLOSEDCDATA 14065
#define ERROR_SXS_XML_E_RESERVEDNAMESPACE 14066
#define ERROR_SXS_XML_E_INVALIDENCODING 14067
#define ERROR_SXS_XML_E_INVALIDSWITCH 14068
#define ERROR_SXS_XML_E_BADXMLCASE 14069
#define ERROR_SXS_XML_E_INVALID_STANDALONE 14070
#define ERROR_SXS_XML_E_UNEXPECTED_STANDALONE 14071
#define ERROR_SXS_XML_E_INVALID_VERSION 14072
#define ERROR_SXS_XML_E_MISSINGEQUALS 14073
#define ERROR_SXS_PROTECTION_RECOVERY_FAILED 14074
#define ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT 14075
#define ERROR_SXS_PROTECTION_CATALOG_NOT_VALID 14076
#define ERROR_SXS_UNTRANSLATABLE_HRESULT 14077
#define ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING 14078
#define ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE 14079
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME 14080
#define ERROR_SXS_ASSEMBLY_MISSING 14081
#define ERROR_SXS_CORRUPT_ACTIVATION_STACK 14082
#define ERROR_SXS_CORRUPTION 14083
#define ERROR_SXS_EARLY_DEACTIVATION 14084
#define ERROR_SXS_INVALID_DEACTIVATION 14085
#define ERROR_SXS_MULTIPLE_DEACTIVATION 14086
#define ERROR_SXS_PROCESS_TERMINATION_REQUESTED 14087
#define ERROR_SXS_RELEASE_ACTIVATION_CONTEXT 14088
#define ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY 14089
#define ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE 14090
#define ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME 14091
#define ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE 14092
#define ERROR_SXS_IDENTITY_PARSE_ERROR 14093
#define ERROR_MALFORMED_SUBSTITUTION_STRING 14094
#define ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN 14095
#define ERROR_UNMAPPED_SUBSTITUTION_STRING 14096
#define ERROR_SXS_ASSEMBLY_NOT_LOCKED 14097
#define ERROR_SXS_COMPONENT_STORE_CORRUPT 14098
#define ERROR_ADVANCED_INSTALLER_FAILED 14099
#define ERROR_XML_ENCODING_MISMATCH 14100
#define ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT 14101
#define ERROR_SXS_IDENTITIES_DIFFERENT 14102
#define ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT 14103
#define ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY 14104
#define ERROR_SXS_MANIFEST_TOO_BIG 14105
#define ERROR_SXS_SETTING_NOT_REGISTERED 14106
#define ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE 14107
#define ERROR_EVT_INVALID_CHANNEL_PATH 15000
#define ERROR_EVT_INVALID_QUERY 15001
#define ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND 15002
#define ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND 15003
#define ERROR_EVT_INVALID_PUBLISHER_NAME 15004
#define ERROR_EVT_INVALID_EVENT_DATA 15005
#define ERROR_EVT_CHANNEL_NOT_FOUND 15007
#define ERROR_EVT_MALFORMED_XML_TEXT 15008
#define ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL 15009
#define ERROR_EVT_CONFIGURATION_ERROR 15010
#define ERROR_EVT_QUERY_RESULT_STALE 15011
#define ERROR_EVT_QUERY_RESULT_INVALID_POSITION 15012
#define ERROR_EVT_NON_VALIDATING_MSXML 15013
#define ERROR_EVT_FILTER_ALREADYSCOPED 15014
#define ERROR_EVT_FILTER_NOTELTSET 15015
#define ERROR_EVT_FILTER_INVARG 15016
#define ERROR_EVT_FILTER_INVTEST 15017
#define ERROR_EVT_FILTER_INVTYPE 15018
#define ERROR_EVT_FILTER_PARSEERR 15019
#define ERROR_EVT_FILTER_UNSUPPORTEDOP 15020
#define ERROR_EVT_FILTER_UNEXPECTEDTOKEN 15021
#define ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL 15022
#define ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE 15023
#define ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE 15024
#define ERROR_EVT_CHANNEL_CANNOT_ACTIVATE 15025
#define ERROR_EVT_FILTER_TOO_COMPLEX 15026
#define ERROR_EVT_MESSAGE_NOT_FOUND 15027
#define ERROR_EVT_MESSAGE_ID_NOT_FOUND 15028
#define ERROR_EVT_UNRESOLVED_VALUE_INSERT 15029
#define ERROR_EVT_UNRESOLVED_PARAMETER_INSERT 15030
#define ERROR_EVT_MAX_INSERTS_REACHED 15031
#define ERROR_EVT_EVENT_DEFINITION_NOT_FOUND 15032
#define ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND 15033
#define ERROR_EVT_VERSION_TOO_OLD 15034
#define ERROR_EVT_VERSION_TOO_NEW 15035
#define ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY 15036
#define ERROR_EVT_PUBLISHER_DISABLED 15037
#define ERROR_EVT_FILTER_OUT_OF_RANGE 15038
#define ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE 15080
#define ERROR_EC_LOG_DISABLED 15081
#define ERROR_EC_CIRCULAR_FORWARDING 15082
#define ERROR_EC_CREDSTORE_FULL 15083
#define ERROR_EC_CRED_NOT_FOUND 15084
#define ERROR_EC_NO_ACTIVE_CHANNEL 15085
#define ERROR_MUI_FILE_NOT_FOUND 15100
#define ERROR_MUI_INVALID_FILE 15101
#define ERROR_MUI_INVALID_RC_CONFIG 15102
#define ERROR_MUI_INVALID_LOCALE_NAME 15103
#define ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME 15104
#define ERROR_MUI_FILE_NOT_LOADED 15105
#define ERROR_RESOURCE_ENUM_USER_STOP 15106
#define ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED 15107
#define ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME 15108
#define ERROR_MCA_INVALID_CAPABILITIES_STRING 15200
#define ERROR_MCA_INVALID_VCP_VERSION 15201
#define ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION 15202
#define ERROR_MCA_MCCS_VERSION_MISMATCH 15203
#define ERROR_MCA_UNSUPPORTED_MCCS_VERSION 15204
#define ERROR_MCA_INTERNAL_ERROR 15205
#define ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED 15206
#define ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE 15207
#define ERROR_AMBIGUOUS_SYSTEM_DEVICE 15250
#define ERROR_SYSTEM_DEVICE_NOT_FOUND 15299
#define ERROR_DHCP_SUBNET_NOT_PRESENT 20005
#define ERROR_DHCP_ELEMENT_CANT_REMOVE 20007
#define ERROR_DHCP_OPTION_EXITS 20009
#define ERROR_DHCP_OPTION_NOT_PRESENT 20010
#define ERROR_DHCP_ADDRESS_NOT_AVAILABLE 20011
#define ERROR_DHCP_JET_ERROR 20013
#define ERROR_DHCP_CLIENT_EXISTS 20014
#define ERROR_DHCP_NOT_RESERVED_CLIENT 20018
#define ERROR_DHCP_RESERVED_CLIENT 20019
#define ERROR_DHCP_IPRANGE_EXITS 20021
#define ERROR_DHCP_RESERVEDIP_EXITS 20022
#define ERROR_DHCP_INVALID_RANGE 20023
#define ERROR_DHCP_CLASS_NOT_FOUND 20044
#define ERROR_DHCP_CLASS_ALREADY_EXISTS 20045
#define ERROR_DHCP_SCOPE_NAME_TOO_LONG 20046
#define ERROR_DHCP_IPRANGE_CONV_ILLEGAL 20049
#define ERROR_DHCP_NETWORK_CHANGED 20050
#define ERROR_DHCP_CANNOT_MODIFY_BINDINGS 20051
#define ERROR_DHCP_SUBNET_EXISTS 20052
#define ERROR_DHCP_MSCOPE_EXISTS 20053
#define ERROR_MSCOPE_RANGE_TOO_SMALL 20054

#define RPC_S_OK	ERROR_SUCCESS
#define RPC_S_INVALID_ARG	ERROR_INVALID_PARAMETER
#define RPC_S_OUT_OF_MEMORY	ERROR_OUTOFMEMORY
#define RPC_S_UNKNOWN_STATUS_CODE	RPC_S_INTERNAL_ERROR

#endif /* __COMPAT_WINERROR_H__ */

#ifndef _DCE_IDL_
#include <lw/attrs.h>


int
LwWin32ErrorToErrno(
    LW_WINERROR WinError
    );

LW_NTSTATUS
LwWin32ErrorToNtStatus(
    LW_WINERROR WinError
    );

LW_PCSTR
LwWin32ErrorToName(
    LW_WINERROR WinError
    );

LW_PCSTR
LwWin32ErrorToDescription(
    LW_WINERROR WinError
    );

#ifndef LW_STRICT_NAMESPACE
#define Win32ErrorToErrno(WinError)          LwWin32ErrorToErrno(WinError)
#define Win32ErrorToNtStatus(WinError)       LwWin32ErrorToNtStatus(WinError)
#define Win32ErrorToName(WinError)           LwWin32ErrorToName(WinError)
#define Win32ErrorToDescription(WinError)    LwWin32ErrorToDescription(WinError)
#endif /* LW_STRICT_NAMESPACE */

#endif /*_DCE_IDL*/

#endif /* __LWBASE_WINERROR_H__*/

