import os, linda, gettext
from linda import clparser
from linda.debug import dprint
from linda.output import OutputException
from linda.parser.debfilename import DebFilenameParser
_ = gettext.gettext

class PrintErrors:
    def __init__(self, file):
        debfn = DebFilenameParser(file)
        self.pkg_name = debfn.package
        self.data = {}
    
    def print_error(self, errs, data_file):
        for err_dict in errs.keys():
            dprint(_("Printing data from %s.") % err_dict)
            sorted_keys = errs[err_dict].keys()
            sorted_keys.sort()
            for tag in sorted_keys:
                errs[err_dict][tag].sort()
                if data_file.has_key(err_dict) and \
                    data_file[err_dict].has_key(tag):
                    onechar = self.get_single(data_file[err_dict][tag]['Type'])
                else:
                    raise ErrorPrintingException("%s doesn't exist in %s!" % (tag, \
                        err_dict))
                if onechar not in clparser['types']:
                    dprint(_("Told to skip type %s.") % \
                        data_file[err_dict][tag]['Type'])
                    continue
                for data in errs[err_dict][tag]:
                    try:
                        linda.outputobj.print_out(tag, data, \
                            data_file[err_dict][tag], self.pkg_name)
                    except OutputException, e:
                        raise ErrorPrintingException(e)

    def get_single(self, str):
        is_up = map(lambda x: x.isupper(), str)
        if reduce(lambda x, y: x + y, is_up):
            return str[is_up.index(True)]
        return ''
    
class ErrorPrintingException(Exception):
    pass

