import sys, os, re, gettext, textwrap, traceback
from linda import clparser
from linda.debug import dprint
from linda.mygettext import translation
_ = gettext.gettext

class Output:
    def __init__(self):
        self.check_type = self.tag = self.pkg_name = self.desc = ''
        self.level = 0
        self.exit_status = 0
        if hasattr(self, 'init'):
            getattr(self, 'init')()
        
    def add_type(self, type, level):
        self.check_type = type
        self.level = level

    def type_single_char(self):
        for x in self.type:
            if x.isupper():
                self.type_char = x
                break

    def change_exit_status(self):
        if self.type_char == 'W' and self.exit_status == 0:
            self.exit_status = 1
        if self.type_char == 'E' and self.exit_status < 2:
            self.exit_status = 2

    def fetch_desc(self):
        self.description = []
        for desc in self.return_trans(self.tag):
            self.description.append(desc)
        self.description[1] = '\n'.join(map(lambda x: ' %s' % x, \
            textwrap.wrap(self.description[1])))

    def check_formatargs(self):
        formatarg = len(re.findall(r'(?<!%)%\d*[asdful]', self.description[0]))
        if formatarg != len(self.data):
            dprint(_("Description: \"%s\"; Data: \"%s\"") % \
                (self.description[0], self.data), 3)
            raise OutputException("Format args for %s don't match Description. (%d vs %d)" % (self.tag, formatarg, len(self.data)))

    def print_out(self, tag, data, output_data, pkg_name):
        self.tag = tag
        self.data = data
        self.output_data = output_data
        self.pkg_name = pkg_name
        self.type = self.output_data['Type']
        self.type_single_char()
        self.fetch_desc()
        self.change_exit_status()
        self.check_formatargs()
        self.print_short()
        if clparser['info']:
            print_desc = 0
            if self.output_data.has_key('seen'):
                if not self.output_data['seen']:
                    print_desc = 1
            else:
                print_desc = 1
            if print_desc:
                self.output_data['seen'] = 1
                self.print_long()
    
    def print_long(self):
        print self.description[1]

    def print_justification(self):
        if self.output_data.has_key('Justification'):
            print " Justification: %s" % self.output_data['Justification']

    def return_trans(self, tag):
        trans = translation('linda')
        translations = []
        for type in ('s', 'l'):
            translations.append(unicode(trans.gettext('%s_%s' % (tag, type)), \
                trans.charset(), 'replace').encode(trans.charset()))
        return translations

class OutputFormats:
    def __init__(self):
        self.registry = {}

    def register(self, klass, tag):
        self.registry[tag] = klass

    def register_all(self, dir):
        for file in map(lambda x: '%s/%s' % (dir, x), os.listdir(dir)):
            if file.endswith('.py'):
                try:
                    execfile(file, {'_': gettext.gettext})
                except StandardError:
                    print _("Failed to import %s.") % file
                    traceback.print_exc(file=sys.stdout)

    def keys(self):
        return self.registry.keys()

    def __getitem__(self, key):
        return self.registry[key]

class OutputException(Exception):
    pass

