from linda import libchecks, checks

class TruetypeFontCheck (libchecks.LindaChecker):
    'Checks packages for non-free or duplicated truetype fonts.'

    def init (self):
        # These strings commonly appear in non-free fonts but never in free
        # ones.
        self.nonfree_indicators = (
            'VeriSign Commercial Software Publishers CA', 'Ray Larabie',
            'The Monotype Corporation', 'Bigelow & Holmes Inc', 'Microsoft',
            'Pats. Pend.', 'LICENSE AGREEMENT',
            'Redistribution strictly prohibited')

        # Many packages include one of these fonts, but it would be better
        # if the maintainers just added a dependency on the canonical package.
        # Note: Bitstream Vera has many forks, be sure to list them first.
        self.common_fonts = (
            ('Danilova Bepa', 'ttf-dejavu'),
            ('DejaVu', 'ttf-dejavu'),
            ('Arabeyes.org', 'ttf-arabeyes'),
            ('Bitstream Vera', 'ttf-bitstream-vera'),
            ('FreeSans', 'ttf-freefont'),
            ('FreeSerif', 'ttf-freefont'),
            ('FreeMono', 'ttf-freefont'),
            ('Thryomanes', 'ttf-thryomanes'),
            ('Dustin Norlander', 'ttf-dustin'),
            ('SummersbyRegular', 'ttf-summersby'),
            ('B&HLuxi', 'ttf-xfree86-nonfree'))

    def check_source_2 (self):
        self.check_fonts(source=True)

    def check_binary_2 (self):
        self.check_fonts(source=False)

    def check_fonts (self, source):
        packages = []
        free = True
        for i in self.information['control']['self']:
            if 'package' in i:
                packages.append(i['package'])
            if 'section' in i:
                free &= i['section'][0] != 'non-free'
    
        collector = self.information['collector']
        for file, type in collector('output', 'file').iteritems():
            if type not in ('TrueType font data', 'OpenType font data'):
                continue
            
            dir = self.information['dir']
            if source:
                fullpath = os.path.join(dir, '..', file)
            else:
                fullpath = os.path.join(dir, 'unpacked', file[1:])
            data = open(fullpath).read()

            if free:
                for indicator in self.nonfree_indicators:
                    if data.find(indicator) != -1:
                        self.signal_error('non-free-truetype-font', [file])
                        break

            for indicator, package in self.common_fonts:
                if data.find(indicator) != -1:
                    if package not in packages:
                        self.signal_error('duplicate-truetype-font', [file, package])
                    break

checks.register(TruetypeFontCheck)

