import os, re, unittest
from sets import Set
from linda.parser.data import DataFileParser
from munge_po import POMunger

class KeysTest(unittest.TestCase):
    def setUp(self):
        po = POMunger()
        self.keys = po.keys
        
    def test_po_file(self):
        "Check the keys from the PO file match the checks"
        po_keys = {'short': Set(()), 'long': Set(())}
        f = open('po/en.po')
        for line in f:
            if line.startswith('msgid'):
                if line[:-1].endswith('_s"'):
                    po_keys['short'].add(line.split('_')[0].split('"')[1])
                elif line[:-1].endswith('_l"'):
                    po_keys['long'].add(line.split('_')[0].split('"')[1])
        self.assertEqual(self.keys.difference(po_keys['short']), Set(()))
        self.assertEqual(po_keys['short'].difference(self.keys), Set(()))
        self.assertEqual(self.keys.difference(po_keys['long']), Set(()))
        self.assertEqual(po_keys['long'].difference(self.keys), Set(()))
        f.close()
        
    def test_data_files(self):
        "Check the keys from the data files match the checks"
        data_keys = []
        for file in os.listdir('data'):
            if file.endswith('.data'):
                dfp = DataFileParser(os.path.join('data', file))
                data_keys += dfp.keys()
        data_keys = Set(data_keys)
        self.assertEqual(self.keys.difference(data_keys), Set(()))
        self.assertEqual(data_keys.difference(self.keys), Set(()))

