import re
from linda import libchecks, checks, dpkgver
from linda.parser.template import TemplateParser

class DebconfCheck(libchecks.LindaChecker):
    'Check the debconf-y things a package is doing.'
    def init(self):
        self.parsed_templ = TemplateParser('/dev/null')
        self.parsed_templ.empty_stanzas = 0
        self.maint_scripts = {'postinst': {'confmodule': 0, 'obsel-confmod': \
            0, 'isdef': 0}, 'preinst': {'confmodule': 0, 'obsel-confmod': \
            0, 'isdef': 0}, 'postrm': {'confmodule': 0, 'obsel-confmod': \
            0, 'isdef': 0, 'purge': 0}, 'prerm': {'confmodule': 0, \
            'obsel-confmod': 0, 'isdef': 0}, 'config': {'confmodule': 0, \
            'obsel-confmod': 0, 'isdef': 0}}
        
    def check_binary_1(self):
        self.templates()
        self.check_template()
        self.maint_scripts_checks()
        
    def templates(self):
        if os.path.exists('%s/control/templates' % self.information['dir']):
            self.parsed_templ = TemplateParser('%s/control/templates' % \
                self.information['dir'])
        else:
            if os.path.exists('%s/control/config' % self.information['dir']):
                self.signal_error('config-no-templates')
    def check_template(self):
        for stanza in self.parsed_templ:
            if not stanza.has_key('type'):
                self.signal_error('debconf-no-type')                
            else:
                if stanza['type'] not in ('string', 'boolean', 'select', \
                    'multiselect', 'note', 'text', 'password'):
                    self.signal_error('unknown-debconf-type', [stanza['type']])
                if re.match('[multi]?select', stanza['type']) and not \
                    stanza.has_key('choices'):
                    self.signal_error('debconf-select-without-choices')
                if stanza['type'] == 'multiselect':
                    if self.check_debconf_version('0.2.26'):
                        self.signal_error('debconf-insufficient-version', \
                            ['multiselect', '0.2.26'])
                if stanza.has_key('title'):
                    if self.check_debconf_version('1.3.22'):
                        self.signal_error('debconf-insufficient-version', \
                            ['title', '1.3.22'])
            if not stanza.has_key('template'):
                self.signal_error('debconf-no-template')
            for key in stanza.keys():
                if key not in ('template', 'type', 'title') and not \
                   (re.match(r'_?(description|choices)', key) or \
                    key.startswith('default')):
                    self.signal_error('unknown-field-templates', [key])
        if self.parsed_templ.empty_stanzas:
            self.signal_error('possible-empty-stanzas-templates', \
                [self.parsed_templ.empty_stanzas])
    def maint_scripts_checks(self):
        for script in self.maint_scripts.keys():
            try:
                f = open(os.path.join(self.information['dir'], 'control', \
                    script))
            except IOError, e:
                f = 0
            if f:
                for k in f:
                    if re.search(r'(\s+)?#', k):
                        continue
                    if k.find('/usr/share/debconf/confmodule.sh') != -1 or \
                        k.find('DebConf::Client::ConfModule') != -1:
                        self.maint_scripts[script]['obsel-confmod'] = 1
                        self.signal_error('obsolete-confmodule', [script])
                    if (k.find('db_input') != -1 or k.find('input(') != -1) \
                        and script == 'postinst':
                        self.signal_error('postinst-db-input')
                    if k.find('isdefault') != -1 and not \
                        self.maint_scripts[script]['isdef']:
                        self.maint_scripts[script]['isdef'] = 1
                        self.signal_error('debconf-isdefault-deprecated')
                    if (k.find('db_purge') != -1 or k.find('purge(') != -1) \
                        and script == 'postrm':
                        self.maint_scripts[script]['purge'] += 1
                    if (k.find('db_seen') != -1 or k.find('seen(') != -1):
                        if self.information['control']['self'][0].has_key('depends'):
                            if self.information['control']['self'][0]['depends'].has_key('debconf'):
                                ver_a = dpkgver.DpkgVersion(self.information['control']['self'][0]['depends']['debconf']['relation'][1])
                                if ver_a < '0.5':
                                    self.signal_error('seen-not-recent')
                    if k.find('/usr/share/debconf/confmodule') != -1 or \
                        k.find('Debconf::Client::ConfModule') != -1:
                        self.maint_scripts[script]['confmodule'] = 1
                    if script == 'postinst' and \
                        re.search(r"(invoke-rc\.d\s+\S+|/etc/init\.d/\S+)\s+start",\
                        k):
                        self.signal_error('init-script-suggests-versioned-depends')
                f.close()
                if self.information['control']['self'][0].has_key('depends'):
                    if script == 'postrm' and not \
                        self.maint_scripts['postrm']['purge'] and \
                        self.information['control']['self'][0]['depends'].has_key('debconf') \
                        and os.path.exists('%s/control/templates' % self.information['dir']):
                        self.signal_error('debconf-postrm-fails-purge')
                if script == 'config' and not \
                    self.maint_scripts['config']['confmodule'] and not \
                    self.maint_scripts['config']['obsel-confmod']:
                    self.signal_error('config-not-load-confmodule')
                if self.information['control']['self'][0].has_key('pre-depends'):
                    if script == 'preinst' and \
                        self.maint_scripts['preinst']['confmodule'] and not \
                        self.information['control']['self'][0]['pre-depends'].has_key('debconf'):
                        self.signal_error('missing-pre-depends-debconf')

    def check_debconf_version(self, version):
        insufficient = False
        if self.information['control']['self'][0].has_key('depends'):
            if self.information['control']['self'][0]['depends'].has_key('debconf'):
                for vers in self.information['control']['self'][0]['depends']['debconf']['relation']:
                    if vers == [None, None]:
                        insufficient = True
                        continue
                    if vers[0].startswith('>'):
                        if dpkgver.DpkgVersion(vers[1]) < version:
                            insufficient = True
        return insufficient
    
checks.register(DebconfCheck)

