# Copyright 2003 Steve Kowalik. Heavily based on gettext.py from Python 2.3.
import os, copy, linda, gettext
from gettext import _translations

def translation(domain):
    mofiles = find(domain)
    if not mofiles:
        return gettext.NullTranslations()
    result = None
    for mofile in mofiles:
        key = os.path.abspath(mofile)
        t = _translations.get(key)
        if t is None:
            t = _translations.setdefault(key, \
                gettext.GNUTranslations(open(mofile, 'rb')))
        t = copy.copy(t)
        if result is None:
            result = t
        else:
            result.add_fallback(t)
    return result

def find(domain):
    localedir = '/usr/share/locale'
    languages = []
    for envar in ('LANGUAGE', 'LC_ALL', 'LC_MESSAGES', 'LANG'):
        if os.environ.get(envar):
            languages = os.environ.get(envar).split(':')
            break
    if 'en' not in languages:
        languages.append('en')
    nelangs = []
    for lang in languages:
        for nelang in gettext._expand_lang(lang):
            if nelang not in nelangs:
                nelangs.append(nelang)
    result = []
    for lang in nelangs:
        mofile = os.path.join(linda.root, 'po', '%s.mo' % lang)
        if os.path.exists(mofile):
            result.append(mofile)
    return result

