import re
from linda.debug import dprint
from linda.parser.rfc822parser import RFC822Parser

class DebianControlParser(RFC822Parser):
    def parse(self):
        self.split()
        for stanza in range(len(self.data)):
            for key in self.data[stanza].keys():
                if key in ('depends', 'pre-depends', 'provides', 'replaces', \
                    'conflicts', 'build-depends', 'recommends', \
                    'build-depends-indep', 'suggests'):
                    self.data[stanza]['%s-x' % key] = {}
                    self.data[stanza]['%s-orig' % key] = self.data[stanza][key]
                    for data in self.data[stanza][key].split(','):
                        data = data.replace('\n', '')
                        dprint(_("Stanza %s; Key %s; Data: %s") % (stanza, \
                            key, data), 5)
                        for alt in data.split('|'):
                            alt = alt.strip()
                            if alt.startswith('('):
                                alt = alt[1:]
                            elif alt.endswith(')') and alt.find('(') == -1:
                                alt = alt[:-1]
                            dprint(_("Calling add_data: key %s, alt %s") % \
                            (key, alt), 5)
                            tmp_alt = [alt]
                            if data.find('(') == data.find('[') == -1:
                                tmp_alt = alt.split(' ')
                            for x in tmp_alt:
                                if x == '':
                                    continue
                                self.add_data(stanza, key, x)
                    self.data[stanza][key] = self.data[stanza]['%s-x' % key]
                    del self.data[stanza]['%s-x' % key]
                elif key == 'description':
                    tmp_desc = self.data[stanza][key].split('\n')
                    self.data[stanza][key] = [tmp_desc[0], \
                        '\n'.join(tmp_desc[1:])]
                elif key == 'section':
                    tmp_section = self.data[stanza][key].split('/')
                    self.data[stanza][key] = tmp_section
        dprint(_("Control file: %s") % self.data, 3)
    
    def add_data(self, stanza, key, data):
        match_obj = re.match(r'^(?P<pkg>[^ \(]+)(\s*\(\s?(?P<rel_type>[<>=]+)\s?(?P<relation>.+)\))?(\s+\[(?P<arch>.+)\])?$', data)
        if not match_obj:
            raise DCPException("Data \"%s\" doesn't match" % data)
        else:
            line = match_obj.groupdict()
        if line['arch'] == None:
            line['arch'] = [None]
        else:
            line['arch'] = line['arch'].split(' ')
        if self.data[stanza]['%s-x' % key].has_key(line['pkg']):
            self.data[stanza]['%s-x' % key][line['pkg']]['relation'].append([line['rel_type'], line['relation']])
            self.data[stanza]['%s-x' % key][line['pkg']]['arch'] = \
                self.data[stanza]['%s-x' % key][line['pkg']]['arch'] + \
                line['arch']
        else:
            self.data[stanza]['%s-x' % key][line['pkg']] = {'relation': \
                [[line['rel_type'], line['relation']]], 'arch': line['arch']}

    def stanzas(self):
        return len(self.data)

class DCPException(Exception):
    pass

