from linda.parser.arch import ArchParser

class DataValidator:
    def __init__(self, type, data):
        self.data = data
        self.value = 0
        if hasattr(self, type):
            if self.data is None:
                self.value = 1
            else:
                getattr(self, type)()

    def __nonzero__(self):
        return self.value
    
    def arch(self):
        arches = ArchParser()
        if self.data[0] == '!':
            self.data = self.data[1:]
        if arches.check(self.data):
            self.value = 1

    def priority(self):
        if self.data in ('required', 'important', 'standard', 'optional', \
            'extra'):
            self.value = 1
        
    def section(self):
        if self.data in ('admin', 'base', 'comm', 'contrib', 'devel', \
            'debian-installer', 'doc', 'editors', 'electronics', 'embedded', \
            'games', 'gnome', 'graphics', 'hamradio', 'interpreters', 'kde', \
            'libdevel', 'libs', 'mail', 'main', 'math', 'misc', 'net', \
            'news', 'non-US', 'non-free', 'oldlibs', 'otherosfs', 'perl', \
            'python', 'science', 'shells', 'sound', 'tex', 'text', 'utils', \
            'web', 'x11'):
            self.value = 1
    
    def essential(self):
        if self.data in ('ncurses-base', 'textutils', 'bsdutils', 'sed', \
            'base-passwd', 'util-linux', 'ncurses-bin', 'tar', 'gzip', \
            'dpkg', 'base-files', 'findutils', 'shellutils', 'grep', \
            'mount', 'e2fsprogs', 'sysvinit', 'perl-base', 'hostname', \
            'fileutils', 'login', 'diff', 'bash', 'debianutils'):
            self.value = 1

