import unittest
from linda.parser.debfilename import DebFilenameParser

class DebFilenameParserTest(unittest.TestCase):
    def test_fulldeb(self):
        "Test a fullname deb filename parses"
        deb = DebFilenameParser('/tmp/lala_0.1.1_i386.deb')
        self.assertEqual(deb.package, 'lala')
        self.assertEqual(deb.version, '0.1.1')

    def test_fulldsc(self):
        "Test a fullname dsc filename parses"
        deb = DebFilenameParser('/tmp/dictionary-el_1.8.5-2.dsc')
        self.assertEqual(deb.package, 'dictionary-el')
        self.assertEqual(deb.version, '1.8.5-2')

    def test_nonarchdeb(self):
        "Test a deb filename that doesn't have an arch parses"
        deb = DebFilenameParser('/tmp/libapr0_2.0.47-2.deb')
        self.assertEqual(deb.package, 'libapr0')
        self.assertEqual(deb.version, '2.0.47-2')

    def test_nothing(self):
        "Test a deb filename that doesn't have a version or arch"
        deb = DebFilenameParser('/tmp/udebpkg.udeb')
        self.assertEqual(deb.package, 'udebpkg')
        self.assertEqual(deb.version, '')

