import os, unittest, shutil, tempfile
from linda.funcs import run_external_cmd
from linda.parser.template import TemplateParser

class TemplateParserTest(unittest.TestCase):
    def setUp(self):
        self.dir = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/parser_template.tar.gz' % \
            self.dir)

    def tearDown(self):
        shutil.rmtree(self.dir)

    def test_correct(self):
        "Check that a correct template parses"
        dtp = TemplateParser(os.path.join(self.dir, 'correct.template'))
        self.assertEqual(dtp.stanzas(), 2)
        self.assertEqual(dtp[0]['template'], 'common/foo')
        self.assertEqual(dtp[0]['type'], 'string')
        self.assertEqual(dtp[0]['description'], 'Foo\n Bar')
        self.assertEqual(dtp[1]['template'], 'common/bar')
        self.assertEqual(dtp[1]['type'], 'string')
        self.assertEqual(dtp[1]['description'], 'Foo\n Bar')

    def test_missing(self):
        "Check that a badly formed template parses"
        dtp = TemplateParser(os.path.join(self.dir, 'missing.template'))
        self.assertEqual(dtp.stanzas(), 2)
        self.assertEqual(dtp[0]['template'], 'common/foo')
        self.assertEqual(dtp[0]['type'], 'string')
        self.assertEqual(dtp[0]['description'], 'Foo\n Bar')
        self.assertEqual(dtp[1]['template'], 'common/bar')
        self.assertEqual(dtp[1]['description'], 'Foo\n Bar')

