import os, unittest, tempfile, shutil
from linda.funcs import run_external_cmd, ExtCmdException, iterate_dir, explode_path
from sets import Set

class FuncsBaseTest(unittest.TestCase):
    def test_run_external_cmd(self):
        'Check funcs.run_external_cmd() works'
        output = run_external_cmd('echo "lala"')
        self.assertEqual(output, 'lala')
        self.assertRaises(ExtCmdException, run_external_cmd, 'false')

    def test_iterate_dir(self):
        'Check funcs.iterate_dir() works'
        dir = tempfile.mkdtemp()
        os.mkdir('%s/b' % dir)
        f = open('%s/a' % dir, 'w')
        f.close()
        f = open('%s/b/c' % dir, 'w')
        f.close()
        files = iterate_dir(dir)
        for x in range(len(files)):
            self.assertEqual(files[x][0:len(dir)+1], dir+'/')
            files[x] = files[x][len(dir)+1:]
        vals = Set(('a', 'b/c'))
        self.assertEqual(vals.intersection(files), vals)
        shutil.rmtree(dir)

    def test_iterate_dir_symlink(self):
        'Check funcs.iterate_dir() works with symlinks to non-existant files'
        dir = tempfile.mkdtemp()
        os.symlink('/this/path', os.path.join(dir, 'symlink'))
        files = iterate_dir(dir)
        self.assertEqual(files, ['%s/symlink' % dir])
        shutil.rmtree(dir)
        
    def test_explode_path(self):
        'Check funcs.explode_path() works'
        self.assertEqual(explode_path('/usr/bin/file'), ['usr', 'bin', 'file'])
        self.assertEqual(explode_path('./lib/modules/2.4.22/kernel/x.o'), \
            ['lib', 'modules', '2.4.22', 'kernel', 'x.o'])
        self.assertEqual(explode_path('/lib/foo/'), ['lib', 'foo', ''])

