import os, sys, re, shutil, random
from linda import clparser
from linda.debug import dprint, vprint
from linda.collector import Collector
from linda.funcs import run_external_cmd, iterate_dir, ExtCmdException
from linda.parser.control import DebianControlParser, DCPException
from linda.parser.dsc import DSCParser, DSCParserException, \
    filter_for_src_dir, file_or_sym
from linda.parser.unixperm import UnixPermParser

class Unpacker:
    def __init__(self):
        self.lab = self.set_up_lab()
        self.information = {'control': {'self': {}, 'info': {}}, 'dsc': [], \
            'dir': '', 'collector': None}
        self.files = {'tarball': '', 'patch': ''}

        
    def unpack(self, file, level=1):
        if hasattr(self, 'unpack_%s_%d' % (file[-3:], level)):
            getattr(self, 'unpack_%s_%d' % (file[-3:], level))(file)
        else:
            raise UnpackException("No idea how to unpack %s at level %d" % \
                (file, level))

    def unpack_deb_1(self, file):
        try:
            dprint(_("Unpacking binary, level 1"))
            cur_dir = os.getcwd()
            os.chdir(self.lab)
            run_external_cmd('ar x %s' % file)
            os.chdir(cur_dir)
            os.unlink(os.path.join(self.lab, 'debian-binary')) # For now
            output = run_external_cmd('tar zxvvCf %s %s' % \
                (os.path.join(self.lab, 'control'), os.path.join(self.lab, \
                'control.tar.gz')))
            os.unlink(os.path.join(self.lab, 'control.tar.gz'))
            try:
                self.information['control']['self'] = \
                    DebianControlParser('%s/control/control' % self.lab)
            except DCPException, e:
                raise UnpackException(e)
            for x in output.split('\n'):
                tmp_array = x.split(' ')
                cur_file = tmp_array[-1]
                if cur_file == './': continue
                self.information['control']['info'][cur_file[2:]] = \
                    [tmp_array[1], UnixPermParser(tmp_array[0])]
            dprint(_("Control info: %s.") % \
                self.information['control']['info'], 2)
        except EnvironmentError:
            raise UnpackException("Level 1 binary unpacking failed!")

    def unpack_deb_2(self, file):
        try:
            dprint(_("Jumping to level 2 (binary)"))
            try:
                output = run_external_cmd('LANG=C tar zvvxCf %s %s' % \
                    (os.path.join(self.lab, 'unpacked'), \
                    os.path.join(self.lab, 'data.tar.gz')))
            except ExtCmdException:
                raise UnpackException("Could not unpack data tarball")
            os.unlink(os.path.join(self.lab, 'data.tar.gz'))
            self.information['dir'] = self.lab
            if not clparser['unpack']:
                self.information['collector'] = Collector('bin', \
                    '%s/unpacked' % self.lab, output)
                for x in ('files', 'dirs', 'elf'):
                    dprint(_("Files: %s: %s") % (x, \
                        self.information['collector']('files', x)), 4)
                for x in ('file', 'ldd', 'objdump'):
                    dprint(_("Output: %s: %s") % (x, \
                        self.information['collector']('output', x)), 4)
        except EnvironmentError:
            raise UnpackException("Level 2 binary unpacking failed!")
        
    def unpack_dsc_1(self, file):
        try:
            self.information['dsc'] = DSCParser(file)
        except DSCParserException:
            raise UnpackException("Can not parse .dsc")
        dprint(_("Parsed .dsc: %s.") % self.information['dsc'])

    def unpack_dsc_2(self, file):
        dprint(_("Jumping to level 2 (source)"))
        cur_dir = os.getcwd()
        os.chdir(self.lab)
        unparsed_ver = self.information['dsc']['version']
        if unparsed_ver.find('-') != -1:
            version = unparsed_ver[:unparsed_ver.rfind('-')]
        else:
            version = unparsed_ver
        if version.find(':') != -1:
            version = version.split(':')[1]
        new_directory = '%s-%s' % (self.information['dsc']['source'], version)
        self.information['dir'] = os.path.abspath(new_directory)
        keeper, throw = os.path.split(file)
        for i in self.information['dsc']['files']:
            tmp = i.split(' ')
            if tmp[3].endswith('tar.gz'):
                self.files['tarball'] = '%s/%s' % (keeper, tmp[3])
            elif tmp[3].endswith('diff.gz'):
                self.files['patch'] = '%s/%s' % (keeper, tmp[3])
        filename = {'tar': os.path.split(self.files['tarball'])[1], 'patch': \
            os.path.split(self.files['patch'])[1]}
        dprint(_("Untaring source: %s") % filename['tar'])
        if os.access(self.files['tarball'], os.R_OK):
            run_external_cmd('tar zxf %s' % self.files['tarball'])
        else:
            raise UnpackException, "%s doesn't exist or isn't readable" % \
                self.files['tarball']
        snapshot_lab = filter(filter_for_src_dir, os.listdir(self.lab))
        if len(snapshot_lab) == 1:
            if snapshot_lab[0] != new_directory:
                if os.path.isdir(os.path.join(self.lab, snapshot_lab[0])):
                    dprint(_("Renaming source directory: %s -> %s") % \
                        (snapshot_lab[0], new_directory))
                    os.rename(snapshot_lab[0], new_directory)
                else:
                    dprint(_("Creating new directory: %s") % new_directory)
                    os.mkdir(os.path.join(self.lab, new_directory))
                    dprint(_("Moving %s into %s.") % (snapshot_lab[0], \
                        new_directory))
                    os.rename(os.path.join(self.lab, snapshot_lab[0]), \
                        os.path.join(self.lab, new_directory, snapshot_lab[0]))
        elif len(snapshot_lab) == 0:
            raise UnpackException("no source files found.")
        else:
            if not os.path.exists(new_directory):
                os.mkdir(new_directory)
            for file in snapshot_lab:
                if file == new_directory:
                    continue
                dprint(_("Moving %s into %s") % (file, new_directory))
                os.rename(file, os.path.join(new_directory, file))
        if filename['patch']:
            dprint(_("Applying patch: %s.") % filename['patch'])
            try:
                run_external_cmd('zcat %s | patch -p0 -g 0 -t -s' % \
                    self.files['patch'])
            except ExtCmdException:
                dprint(out)
                raise UnpackException('patch failed to run!')
        try:
            dprint(_("Parsing control file."))
            self.information['control']['self'] = \
                DebianControlParser(os.path.join(self.information['dir'], \
                'debian', 'control'))
        except DCPException, e:
            raise UnpackException(e)
        self.information['collector'] = Collector('src', self.lab, \
            filter(file_or_sym, iterate_dir(new_directory)))
        os.chdir(cur_dir)
        dprint(_("Files: %s") % \
            self.information['collector']('files', 'files'), 4)
        dprint(_("Output: %s") % \
            self.information['collector']('output', 'file'), 4)

    def set_up_lab(self):
        for dir in (clparser['lab-root'], os.environ.get('TMPDIR'), '/tmp'):
            if dir:
                lab_root = dir
                break
        lab_directory = "%s/linda-lab-%05d" % (lab_root, \
            random.choice(range(100000)))
        if os.path.exists(lab_directory):
            dprint(_("Lab %s already exists; trying again.") % lab_directory)
            lab_directory = "%s/linda-lab-%05d" % (lab_root, \
                random.choice(range(100000)))
        try:
            os.makedirs(lab_directory + '/control')
            os.mkdir(lab_directory + '/unpacked')
            dprint(_("Creating lab directory: %s.") % lab_directory)
            vprint(_("Creating lab directory: %s.") % lab_directory, 2)
            return lab_directory
        except OSError, e:
            raise UnpackException('Failed to create lab directory: %s.' % e)

    def cull_lab(self):
        real_cull(self.lab)

class UnpackException(Exception):
    pass

def real_cull(lab):
    # So I don't have to duplicate lab cleaning code.
    if not clparser['no-cull']:
        try:
            shutil.rmtree(lab)
        except OSError:
            print _("Failed to remove lab directory: %s") % lab
        dprint(_("Removing lab directory: %s.") % lab)
        vprint(_("Removing lab directory: %s.") % lab, 2)

