import re
from linda import libchecks, checks

class ExampleFilesCheck(libchecks.LindaChecker):
    'See if a package contains any example or unneeded files.'
    def check_source_2(self):
        self.example_files()

    def example_files(self):
        for file in self.information['collector']('files', 'files').keys():
            if re.search(r'debian/(ex|.*\.ex$)', file):
                self.signal_error('examples-files')
            elif file.find('debian/files') != -1:
                self.signal_error('debian-files-found')
            elif re.search(r'config\.(status|cache)', file):
                self.signal_error('autoconf-generated-files')

    def check_binary_2(self):
        self.example_dirs()
        
    def example_dirs(self):
        if os.path.isdir(os.path.join(self.information['dir'], 'unpacked', \
            'usr/share/doc', self.pkg_name, 'examples', 'examples')):
            self.signal_error('usr-share-doc-double-examples')

checks.register(ExampleFilesCheck)

