import re
from linda import libchecks, checks
from types import NoneType

class ShebangCheck(libchecks.LindaChecker):
    'Check the maintainer scripts are using correct depends.'
    def init(self):
        self.scripts = {'postinst': None, 'preinst': None, 'prerm': None, \
            'postrm': None, 'config': None}
        
    def check_binary_2(self):
        for script in self.scripts.keys():
            self.fetch_script_name(script)
            self.check_maint(script)

    def fetch_script_name(self, script):
        try:
            f = open(os.path.join(self.information['dir'], 'control', script))
        except IOError:
            f = 0
        if f:
            self.scripts[script] = []            
            sre = re.match(r'#![ ]?([^ ]*)[ ]?.*', f.readline())
            if sre.groups():
                shebang = sre.groups()[0].split('\n')[0]
                self.scripts[script].append(shebang)
                self.scripts[script].append(os.path.split(shebang))
            f.close()
    def check_maint(self, script):
        if type(self.scripts[script]) == NoneType:
            return
        if not self.scripts[script]:
            self.signal_error('no-shebang-line', [script])
            return
        if self.scripts[script][1][0].startswith('/usr/local'):
            self.signal_error('usr-local-interpreter', [script])
            return
        dependancy = self.return_dependancy(self.scripts[script][1][1])
        if not dependancy:
            self.signal_error('unknown-exec', [script, \
                self.scripts[script][1][1]])
            return
        if not dependancy[0]:
            return
        if not re.match(r'((ba)?sh|perl)', self.scripts[script][1][1]) or \
            dependancy[0] != self.pkg_name:
            doesnot_depend = 1
            if script.startswith('pre'):
                field_name = 'Pre-Depends'
                if self.information['control']['self'][0].has_key('pre-depends'):
                    if self.information['control']['self'][0]['pre-depends'].has_key(dependancy[0]):
                        doesnot_depend = 0
            else:
                field_name = 'Depends'
                if self.information['control']['self'][0].has_key('depends'):
                    if self.information['control']['self'][0]['depends'].has_key(dependancy[0]):
                        doesnot_depend = 0
            if doesnot_depend:
                self.signal_error('script-depends', [script, dependancy[0], \
                    field_name])
        if self.scripts[script][1][0] != dependancy[1]:
            self.signal_error('wrong-path-script', [script, \
                self.scripts[script][1][1]])
        if self.scripts[script][0].find('csh') != -1:
            self.signal_error('csh-harmful', [script])
    
    def return_dependancy(self, script_name):
        script_depends = {'sh': ['', '/bin'], 'ash': ['ash', '/bin'], \
            'bash': ['', '/bin'], 'csh': ['tcsh', '/bin'], 'perl': [], 'awk': \
            [], 'burlap': ['felt'], 'expect': [], 'gawk': [], 'gforth': [], \
            'gnuplot': [], 'guile': [], 'install-menu': ['menu'], \
            'install-fvwmgenmenu': ['menu'], 'js': ['ngs-js'], 'kforth': [], \
            'ksh': ['pdksh'], 'magicfilter': [], 'make': [], 'mawk': [], \
            'ocaml': [], 'perl': ['', '/usr/bin'], 'pforth': [], 'php': \
            ['php-cgi'], 'pike': [], 'pike7': [], 'python': [], 'python2.1': \
            [], 'python2.2': [], 'rc': [], 'regina': ['regina-rexx'], 'rexx': \
            ['regina-rexx'], 'ruby': [], 'runhugs1.4': ['hugs'], 'runhugs98': \
            ['hugs98'], 'scsh': [], 'sed': ['sed', '/bin'], 'suidperl': \
            ['perl-suid'], 'tclsh': [], 'tcsh': [], 'tixwish': ['tix'], \
            'trs': ['konwert'], 'yforth': [], 'zsh': []}
        if script_depends.has_key(script_name):
            if len(script_depends[script_name]) == 0:
                return [script_name, '/usr/bin']
            elif len(script_depends[script_name]) == 1:
                return script_depends[script_name] + ['/usr/bin']
            elif len(script_depends[script_name]) == 2:
                return script_depends[script_name]
        else:
            return []

checks.register(ShebangCheck)

