from linda import libchecks, checks
from sets import Set

class UDebControlCheck(libchecks.LindaChecker):
    def check_udeb_1(self):
        self.check_control()

    def check_control(self):
        if self.information['control']['self'][0].has_key('section'):
            if self.information['control']['self'][0]['section'] != \
                'debian-installer':
                self.signal_error('section-not-di')
        if self.information['control']['self'][0].has_key('priority'):
            if not DataValidator('priority', \
                self.information['control']['self'][0]['priority']):
                self.signal_error('unknown-priority', \
                    [self.information['control']['self'][0]['priority']])
        for field in ('pre-depends', 'conflicts', 'essential', 'suggests'):
            if self.information['control']['self'][0].has_key(field):
                self.signal_error('invalid-control-header', field)
        forbidden_control_files = Set(('preinst', 'postrm', 'prerm', \
            'md5sums', 'conffiles'))
        if len(forbidden_control_files.intersection(self.information['control']['info'])):
            self.signal_error('invalid-control-file')
        for field in ('depends', 'recommends'):
            if self.information['control']['self'][0].has_key('%s-orig' % field):
                if self.information['control']['self'][0]['%s-orig' % field].find('|') != -1:
                    self.signal_error('no-dependency-alternatives', \
                        field.capitalize())
                
checks.register(UDebControlCheck)

