import re
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.unixperm import UnixPermParser

class Collector:
    def __init__(self, type, lab, files):
        self.files = {'files': {}, 'dirs': {}, 'elf': []}
        self.output = {'file': {}, 'ldd': {}, 'objdump': {}}
        self.lab = lab
        self._files = files
        getattr(self, '%s_parse' % type)()
        self.run_file()
        if type == 'bin':
            self.determine_elf()
            self.run_ldd_objdump()

    def bin_parse(self):
        for line in filter(None, self._files.split('\n')):
            split_line = line.split(' ')
            if split_line[-2] == '->':
                cur_file = re.sub(r'^\.', '', split_line[-3])
            else:
                cur_file = re.sub(r'^\.', '', split_line[-1])
            if cur_file.endswith('/'):
                if cur_file[1:-1]:
                    self.files['dirs'][cur_file[:-1]] = \
                        [UnixPermParser(split_line[0]), split_line[1]]
            else:
                self.files['files'][cur_file] = \
                    UnixPermParser(split_line[0])

    def src_parse(self):
        src_files = self.files['files'].fromkeys(self._files)
        self.files['files'] = {}
        for file in src_files.keys():
            cur_file = file
            if file.startswith('./'):
                cur_file = file[len('./'):]
            self.files['files'][cur_file] = src_files[file]
                
    def run_file(self):
        lists_to_run = ['']
        for file in map(lambda x: '%s/%s' % (self.lab, x), \
            self.files['files'].keys()):
            if len(lists_to_run[-1]) + len(file) < 65535:
                lists_to_run[-1] += '"%s" ' % file
            else:
                lists_to_run.append('"%s" ' % file)
        file_output = []
        for list in filter(None, lists_to_run):
            file_output.append(run_external_cmd('file %s' % list))
        for output in file_output:
            for line in output.split('\n'):
                split_line = re.split(r': +', line)
                cur_file = re.sub('%s/' % self.lab, '', split_line[0])
                if len(split_line) == 2:
                    self.output['file'][cur_file] = split_line[1]
                else:
                    self.output['file'][cur_file] = \
                        ': '.join(split_line[1:])
    
    def determine_elf(self):
        for file in self.output['file'].keys():
            if re.search(r'ELF.*(executable|shared object|relocatable)', \
                self.output['file'][file]):
                self.files['elf'].append(file)
    
    def run_ldd_objdump(self):
        ld_lib_path = ':'.join(map(lambda x: '%s/%s' % (self.lab, x), \
            ('lib', 'usr/lib', 'usr/X11R6/lib', 'var/lib')))
        for file in self.files['elf']:
            self.output['ldd'][file] = \
                run_external_cmd('LD_LIBRARY_PATH="%s" ldd "%s/%s"' % \
                (ld_lib_path, self.lab, file), 1)
            self.output['objdump'][file] = \
                run_external_cmd('LC_ALL=C objdump -hpT "%s/%s"' % \
                (self.lab, file), 1)

    def __call__(self, kind, key):
        if hasattr(self, kind):
            if getattr(self, kind).has_key(key):
                return getattr(self, kind)[key]

    def set(self, kind, key, data):
        if hasattr(self, kind):
            getattr(self, kind)[key] = data
        else:
            raise KeyError

