import os, commands

def run_external_cmd(command='false', ignoreexit=0):
    exitstat, output = commands.getstatusoutput(command)
    if exitstat != 0 and not ignoreexit:
        raise ExtCmdException("%s exited with a status of %d" % (command, \
            exitstat))
    return output

class ExtCmdException(Exception):
    pass

def iterate_dir(directory):
    tmp_file = []
    os.path.walk(directory, add_file, tmp_file)
    return tmp_file

def add_file(arg, dirname, names):
    for x in names:
        if os.path.isfile(os.path.join(dirname, x)):
            arg.append(os.path.join(dirname, x))

def explode_path(path):
    if not path:
        return []
    if path[0] == '.':
        path = path[1:]
    split = list(os.path.split(path))
    sentinal = 1
    while sentinal:
        other_split = list(os.path.split(split[0]))
        if other_split[0] == '/':
            split = other_split[1:] + split[1:]
            break
        else:
            split = other_split + split[1:]
    return split

