import os, re, gettext
from linda import clparser
from linda.debug import dprint
_ = gettext.gettext

class ConfigFileParser:
    def __init__(self):
        if clparser['config']:
            self.file = clparser['config']
        elif os.path.exists(os.path.expanduser('~/.linda/config')):
            self.file = os.path.expanduser('~/.linda/config')
        else:
            self.file = '/dev/null'
        self.data = []
        self.read()
        self.parse()
    
    def read(self):
        f = open(self.file)
        for k in f:
            if k.startswith('#') or k == '\n':
                continue
            else:
                self.data.append(k[:-1])

    def parse(self):
        for line in self.data:
            splitted_line = re.split(r'\s', line)
            if splitted_line[0] in ('info', 'informational', 'no-cull', \
                'show-overridden', 'quiet', 'show-tag', 'traceback'):
                clparser[line] = 1
            elif splitted_line[0] in ('debug', 'verbose'):
                if len(splitted_line) > 1:
                    clparser[splitted_line[0]] = int(splitted_line[1])
                else:
                    clparser[splitted_line[0]] += 1
            elif splitted_line[0] in ('checks', 'format', 'lab-root', \
                'more-overrides'):
                if len(splitted_line) > 1:
                    if splitted_line[0] == 'lab-root':
                        if os.path.isdir(splitted_line[1]):
                            clparser[splitted_line[0]] = splitted_line[1]
                    else:
                        if splitted_line[1]:
                            clparser[splitted_line[0]] = splitted_line[1]
                        else:
                            raise ConfigFileParserException, \
                                'Required argument to %s empty' % \
                                splitted_line[0]
                else:
                    raise ConfigFileParserException, \
                        'Required argument to %s missing' % splitted_line[0]
            else:
                raise ConfigFileParserException, \
                    'Unknown line in config file: %s' % line

class ConfigFileParserException(Exception):
    pass

