import os, unittest
from sets import Set
from linda.parser.data import DataFileParser

class KeysTest(unittest.TestCase):
    def setUp(self):
        self.keys = Set(('unknown-arch', 'pkg-should-be-arch-any', \
            'binary-in-etc', 'binary-in-doc-dir', 'arch-dep-in-usr-share', \
            'no-depends-line', 'double-shlib', 'not-quite-stripped-binary', \
            'binary-note-or-comment', 'static-binary', 'unstripped-binary', \
            'stripped-binary-not', 'binary-rpath', 'binary-libc5', \
            'libc6-binary-in-libc5-dir', 'binary-libc6', 'binary-upx', \
            'binary-profiling', 'shared-binary', 'no-cdbs-but-build-dep', \
            'missing-build-dep-on-cdbs', 'missing-build-dep-on-debhelper', \
            'cdbs-debhelper-build-dep-too-old', 'usd-symlink-no-depends', \
            'non-compressed-changelog', 'not-max-compression-changelog', \
            'changelog-usr-doc', 'html-only-changelog', 'wrong-changelog-name', \
            'no-upstream-changelog', 'emacs-settings-in-changelog', \
            'no-changelog', 'next-ver-less-than-prev', \
            'switching-native-nonnative', 'obsolete-dist', \
            'incorrect-distribution', 'md5sum-mismatch', 'file-size-mismatch', \
            'unknown-component-changes', 'unknown-section-changes', \
            'non-etc-conffile', 'relative-conffile', 'etc-conffile', \
            'upper-in-package', 'perl-pkg-should-be-sct-perl', \
            'python-pkg-should-be-sct-py', 'unknown-priority', \
            'spelling-non-us', 'unknown-component', 'unknown-section', \
            'empty-maintainer', 'no-maintainer-email', \
            'malformed-maint-mail-addr', 'no-maintainer', \
            'essential-no-redundant', 'essential-not-yes-or-no', \
            'new-essential-package', 'desc-starts-with-package', \
            'multiple-spaces-in-desc', 'description-too-long', 'tab-in-desc', \
            'ex-desc-contains-desc', 'no-description', \
            'no-version-dep-on-essential', 'pkg-depends-on-self', \
            'versioned-provides', 'no-package-line', 'no-priority-line', \
            'no-version-line', 'deb-revision-zero', 'obsolete-field-in-control', \
            'recommends-suggests-dependant-pkg', 'invalid-arch-in-b-d', \
            'package-b-d-on-autostar', 'essential-field-in-source', \
            'no-source-field-in-source', 'bad-source-field', \
            'source-not-like-package', 'build-dep-indep-with-no-all', \
            'char-forbidden-rfc822', 'unknown-control-file', \
            'incorrect-ownership-control', 'incorrect-control-perms', \
            'possible-maint-error', 'duplicate-conffile', 'bin-sh-e-in-maint', \
            'killall-in-maint', 'mknod-in-maint', 'dpkg-pa-in-maint', \
            'suid-in-maint', 'update-alt-in-postrm', 'insecure-tmp-handling', \
            'netbase-managed-in-maint', 'inetd-in-maint', \
            'multiple-update-rc.d', 'no-copyright', 'copyright-is-symlink', \
            'old-copyright-location', 'compressed-copyright', \
            'copyright-blurb-no-name', 'copyright-contains-full-gpl', \
            'probable-dh-make-template', 'copyright-old-directory', \
            'common-licenses', 'upstream-authors', 'config-no-templates', \
            'debconf-no-type', 'unknown-debconf-type', \
            'debconf-select-without-choices', 'debconf-insufficient-version', \
            'debconf-insufficient-version', 'debconf-no-template', \
            'unknown-field-templates', 'obsolete-confmodule', \
            'postinst-db-input', 'debconf-isdefault-deprecated', \
            'seen-not-recent', 'debconf-postrm-fails-purge', \
            'config-not-load-confmodule', 'missing-pre-depends-debconf', \
            'uses-dh-testversion', 'dh-compat-greater-than-depends', \
            'no-debhelper-but-build-dep', 'missing-build-dep-on-dh', \
            'maint-uses-dh-no-tag', 'manual-in-usr-man', \
            'manual-not-compressed', 'link-to-undocumented', \
            'executable-manual-page', 'manual-not-max-compression', \
            'manual-not-using-gzip', 'whatis-parse-failed-on-manpage', \
            'no-manual-for-binary', 'doc-base-format-html-no-files', \
            'doc-base-file-not-found', 'doc-base-file-not-found', \
            'newer-feature-than-allowed', 'examples-files', \
            'debian-files-found', 'autoconf-generated-files', \
            'usr-share-doc-double-examples', 'usr-doc-no-usr-share-doc', \
            'empty-directory-in-pkg', 'vercon-dir-in-package', \
            'dot-xvpics-in-package', 'non-standard-dir-perm', \
            'FSSTND-dir-found', 'non-standard-dir-in-var', \
            'non-standard-dir-in-var', 'FSSTND-dir-found', \
            'non-standard-dir-in-usr', 'file-in-opt', 'file-in-usr-local', \
            'failed-diff', 'ali-file-not-444', 'cvsignore-in-package', \
            'file-directly-in-u-s', 'incorrect-file-perms', 'cvs-bu-in-pkg', \
            'bad-perms-for-initd', 'package-install-bad-dir', \
            'pkg-has-old-app-defaults', 'extra-license-file', \
            'usr-lib-in-arch-all', 'zero-length-file', 'exec-not-elf-or-script', \
            'image-in-usr-lib', 'possible-readme-debian-template', \
            'debian-rules-not-makefile', 'debian-rules-hashbang-space', \
            'config-too-old', 'so-symlink-non-dev', 'section-not-libs', \
            'package-not-start-lib', 'package-notlike-soname', \
            'pkg-installs-into-perl-dir', 'arch-indep-should-be-u-s-p', \
            'module-pkg-no-perl-dep', 'unversioned-dep-on-perl', \
            'perl-dep-not-great-enough', 'no-shebang-line', \
            'usr-local-interpreter', 'unknown-exec', 'script-depends', \
            'wrong-path-script', 'csh-harmful', 'incorrect-standards-version', \
            'ancient-standards-version', 'out-date-standards-version', \
            'build-deps-wrong-s-v', 'newer-standards-version', \
            'no-standards-version', 'comma-in-short-desc', \
            'usr-share-doc-in-udeb', 'usr-share-man-in-udeb', \
            'usr-local-in-udeb', 'udeb-pkg-should-be-arch-any', 'file-in-u-s', \
            'usr-doc-in-udeb', 'cvs-dir-in-udeb', 'section-not-di', \
            'unknown-priority', 'invalid-control-header', 'invalid-control-file', \
            'too-old-file', 'init-script-suggests-versioned-depends', \
            'no-dependency-alternatives', 'possible-empty-stanzas-templates'))

    def test_po_file(self):
        "Check the keys from the PO file match the checks"
        po_keys = {'short': Set(()), 'long': Set(())}
        f = open('po/en.po')
        for line in f:
            if line.startswith('msgid'):
                if line[:-1].endswith('_s"'):
                    po_keys['short'].add(line.split('_')[0].split('"')[1])
                elif line[:-1].endswith('_l"'):
                    po_keys['long'].add(line.split('_')[0].split('"')[1])
        self.assertEqual(self.keys.difference(po_keys['short']), Set(()))
        self.assertEqual(po_keys['short'].difference(self.keys), Set(()))
        self.assertEqual(self.keys.difference(po_keys['long']), Set(()))
        self.assertEqual(po_keys['long'].difference(self.keys), Set(()))

    def test_data_files(self):
        "Check the keys from the data files match the checks"
        data_keys = []
        for file in os.listdir('data'):
            if file.endswith('.data'):
                dfp = DataFileParser(os.path.join('data', file))
                data_keys += dfp.keys()
        data_keys = Set(data_keys)
        self.assertEqual(self.keys.difference(data_keys), Set(()))
        self.assertEqual(data_keys.difference(self.keys), Set(()))

