import sys, os, unittest, linda, tempfile
from linda import clparser
from linda.output import OutputFormats
from linda.parser.clparser import CLParser

class LintianOutputTest(unittest.TestCase):
    def setUp(self):
        self.filename = tempfile.mkstemp()[1]
        linda.outputformats = OutputFormats()
        execfile('output/lintian.py')
        for klass in linda.outputformats.registry.keys():
            self.instance = linda.outputformats.registry[klass]()
        clparser = CLParser()
        
    def tearDown(self):
        os.unlink(self.filename)
        
    def test_output(self):
        "Check the output LintianOutput gives"
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type_char = 'E'
        self.instance.tag = 'lala-not-defined'
        self.instance.data = []
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        f = open(self.filename)
        k = f.readline()
        self.assertEqual(k, "E: test: lala-not-defined \n")
        f.close()
        f = open(self.filename, 'w')
        f.write('')
        f.close()

    def test_output_data(self):
        "Check the output LintianOutput gives with data provided"
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type_char = 'E'
        self.instance.tag = 'lala-not-defined'
        self.instance.data = ['a', 'b']
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        f = open(self.filename)
        k = f.readline()
        self.assertEqual(k, "E: test: lala-not-defined a b\n")
        f.close()
        f = open(self.filename, 'w')
        f.write('')
        f.close()

